/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import phex.Res;
import phex.common.Environment;
import phex.common.SortedProperties;
import phex.msg.GUID;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class Cfg {
    public static final String GENERAL_GNUTELLA_NETWORK = "<General Gnutella Network>";
    public static final String PRIVATE_NETWORK = null;
    public static final String PRIVATE_BUILD_ID = "";
    public static String DEFAULT_NETWORK_TO_USE = PRIVATE_NETWORK == null ? "<General Gnutella Network>" : PRIVATE_NETWORK;
    public static final boolean DEFAULT_FORCE_TOBE_ULTRAPEER = false;
    private static final String UNSET_STRING = "<unset>";
    private static final String BACKUP_CONFIG_FILENAME = "phex.bk";
    public static final int DEFAULT_SOCKS5_PORT = 1080;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 65536;
    public static final short DEFAULT_LOGGER_VERBOSE_LEVEL = 6;
    public static final boolean DEFAULT_ENABLE_HIT_SNOOPING = true;
    public static final boolean DEFAULT_IS_CHAT_ENABLED = true;
    public static final boolean DEFAULT_ALLOW_TO_BECOME_LEAF = true;
    public static final boolean DEFAULT_ALLOW_TO_BECOME_ULTRAPEER = true;
    public static final boolean DEFAULT_FORCE_UP_CONNECTIONS = false;
    public static final boolean DEFAULT_IS_NOVENDOR_NODE_DISCONNECTED = false;
    public static final int DEFAULT_FREELOADER_FILES = 0;
    public static final int DEFAULT_FREELOADER_SHARE_SIZE = 0;
    public static final int DEFAULT_HOST_ERROR_DISPLAY_TIME = 1000;
    public static final int DEFAULT_TTL = 7;
    public static final int DEFAULT_MAX_NETWORK_TTL = 7;
    public static final int DEFAULT_UP_2_UP_CONNECTIONS = 32;
    public static final int DEFAULT_UP_2_LEAF_CONNECTIONS = 31;
    public static final int DEFAULT_UP_2_PEER_CONNECTIONS = 2;
    public static final int DEFAULT_LEAF_2_UP_CONNECTIONS = 5;
    public static final int DEFAULT_LEAF_2_PEER_CONNECTIONS = 1;
    public static final int DEFAULT_PEER_CONNECTIONS = 4;
    public static final int DEFAULT_MAX_CONNECTTO_HISTORY_SIZE = 10;
    public static final int DEFAULT_MAX_SEARCHTERM_HISTORY_SIZE = 10;
    public static final boolean DEFAULT_ARE_PARTIAL_FILES_SHARED = true;
    private static final char LIST_PREFIX = '_';
    public static final short DEFAULT_URN_CALCUATION_MODE = 2;
    public static final int DEFAULT_DYNAMIC_QUERY_MAX_TTL = 4;
    public static final int DEFAULT_MAX_DOWNLOADS_PER_IP = 1;
    public static final boolean DEFAULT_ALLOW_UPLOAD_QUEUING = true;
    public static final int DEFAULT_MAX_UPLOAD_QUEUE_SIZE = 100;
    public static final int DEFAULT_MIN_UPLOAD_QUEUE_POLL_TIME = 45;
    public static final int DEFAULT_MAX_UPLOAD_QUEUE_POLL_TIME = 120;
    public static final boolean DEFAULT_IS_DEFLATE_CONNECTION_ACCEPTED = true;
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_SOCKET_RW_TIMEOUT = 60000;
    public static final int DEFAULT_OFFLINE_CONNECTION_FAILURE_COUNT = 100;
    public static final int DEFAULT_LAST_SHOWN_UPDATE_INFO_ID = 0;
    public static final int UNLIMITED_BANDWIDTH = Integer.MAX_VALUE;
    public static int MIN_SEARCH_TERM_LENGTH = 2;
    public static final int INITIAL_SEGMENT_SIZE = 16384;
    public static final short SEGMENT_TRANSFER_TIME = 90;
    public static final long MINIMUM_ALLOWED_TRANSFER_RATE = 1L;
    public static final long MAXIMUM_SEGMENT_SIZE = 0xA00000L;
    public static final int DEFAULT_ORDERING_METHOD = 322;
    public int initialSegmentSize;
    public int segmentTransferTime;
    public long minimumAllowedTransferRate;
    public long maximumSegmentSize;
    public GUID mProgramClientID = new GUID();
    public String mMyIP = "";
    public int mListeningPort = -1;
    public int mMaxUpload = 4;
    public int mMaxUploadPerIP = 1;
    public int mUploadMaxBandwidth = 102400;
    public int mNetMaxHostToCatch = 1000;
    public int mNetMaxSendQueue = 500;
    public int mSearchMaxConcurrent = 10;
    public int mNetMaxRate = 50000;
    public int mDownloadMaxBandwidth = 102400;
    public boolean mDownloadAutoRemoveCompleted = false;
    public String mDownloadDir = ".";
    public int mDownloadMaxRetry = 999;
    public int mDownloadRetryWait = 4000;
    public boolean mAutoConnect = true;
    public int mNetMinConn = 4;
    public boolean mAutoCleanup = true;
    public int mUploadMaxSearch = 64;
    public boolean mShareBrowseDir = true;
    public int mPushTransferTimeout = 30000;
    public String mCurrentNetwork = DEFAULT_NETWORK_TO_USE;
    public ArrayList mNetNetworkHistory = new ArrayList();
    public boolean mAutoJoin = true;
    public boolean mDisconnectApplyPolicy = false;
    public int mDisconnectDropRatio = 70;
    public boolean mProxyUse = false;
    public String mProxyHost = "";
    public int mProxyPort = 1080;
    public boolean useProxyAuthentication = false;
    public String mProxyUserName = "";
    public String mProxyPassword = "";
    public String mFindText = "";
    public boolean mFindMatchCase = false;
    public boolean mFindDown = true;
    public boolean mUIDisplayTooltip = true;
    public String mUploadDir = "";
    public String mUploadFileExclusions = "";
    public String mUploadFileInclusions = "*";
    public boolean mUploadAutoRemoveCompleted = false;
    public HashSet sharedDirectoriesSet;
    public ArrayList libraryExclusionRegExList;
    public short urnCalculationMode;
    public boolean monitorSearchHistory = false;
    public String searchMonitorFile = "";
    public int searchHistoryLength = 10;
    public boolean connectedToLAN = true;
    public boolean minimizeToBackground = true;
    public boolean showCloseOptionsDialog = true;
    public String incompleteDir = ".";
    public ArrayList filteredCatcherPorts = new ArrayList();
    public short maxWorkerPerDownload = (short)3;
    public short maxTotalDownloadWorker = (short)6;
    public boolean allowUploadQueuing;
    public int maxUploadQueueSize;
    public int minUploadQueuePollTime;
    public int maxUploadQueuePollTime;
    public int maxDownloadsPerIP;
    public int networkSpeedKbps = 256;
    public int maxTotalBandwidth = 16384;
    public String runningPhexVersion = "";
    public String runningBuildNumber = "";
    public boolean isHttpProxyUsed = false;
    public String httpProxyHost = "";
    public int httpProxyPort = 80;
    public String lastUpdateCheckVersion = "0";
    public String lastBetaUpdateCheckVersion = "0";
    public long lastUpdateCheckTime = 0L;
    public boolean showUpdateNotification = true;
    public boolean showBetaUpdateNotification = false;
    public int socketConnectTimeout;
    public int socketRWTimeout;
    public int mNetConnectionTimeout = 8000;
    public int searchRetryTimeout = 30000;
    public short loggerVerboseLevel;
    public short logType = 1;
    public boolean logToConsole = false;
    public long maxLogFileLength = 524288L;
    public boolean enableHitSnooping;
    public int maxMessageLength;
    public boolean isChatEnabled;
    public boolean allowUPConnections;
    public boolean allowToBecomeLeaf;
    public boolean forceUPConnections;
    public boolean allowToBecomeUP;
    public boolean forceToBeUltrapeer;
    public int up2upConnections;
    public int up2leafConnections;
    public int up2peerConnections;
    public int leaf2upConnections;
    public int leaf2peerConnections;
    public int peerConnections;
    public int offlineConnectionFailureCount;
    public boolean isNoVendorNodeDisconnected;
    public int freeloaderFiles;
    public int freeloaderShareSize;
    public int hostErrorDisplayTime;
    public int ttl;
    public int maxNetworkTTL;
    public ArrayList connectToHistory;
    public int maxConnectToHistorySize;
    public ArrayList searchTermHistory;
    public ArrayList streamableSuffixes;
    public static final String default_streamableSuffixes = new String("avi|mpe?g|asf|wmv|ogg|mp3|mov|txt|html?|rtf|lit");
    public int segmentHijacking;
    public static final String default_segmentHijacking = "-1";
    public boolean copyBeforePreviewing;
    public static final boolean DEFAULT_COPY_BEFORE_PREVIEWING = true;
    public ArrayList unstreamableSuffixes;
    public static final String default_unstreamableSuffixes = new String("iso|zip|rar|bin|r\\\\d\\\\d|exe|bmp|msi|doc|torrent|pdf");
    public HashMap previewMethod;
    public String fallbackPreviewMethod;
    public static final String DEFAULT_FALLBACK_PREVIEW_METHOD = "";
    public String completionNotifyMethod;
    public long segmentMultiple;
    public static final long DEFAULT_SEGMENT_MULTIPLE = 4096L;
    public int maxSearchTermHistorySize;
    public boolean arePartialFilesShared;
    public long movingTotalUptime;
    public int movingTotalUptimeCount;
    public long maximalUptime;
    public long lastShutdownTime;
    public float fractionalUptime;
    public boolean isDeflateConnectionAccepted;
    public int lastShownUpdateInfoId;
    public int totalDownloadCount;
    public int totalUploadCount;
    public String usedLocale;
    private File configFile;
    private Properties mSetting;
    public int orderingMethod;

    public Cfg(File file) {
        this.configFile = file;
        this.mSetting = new SortedProperties();
    }

    public void load() {
        Object object;
        this.loadDefaultValues();
        try {
            object = new FileInputStream(this.configFile);
            this.mSetting.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(this.configFile.getParentFile(), BACKUP_CONFIG_FILENAME));
                this.mSetting.load(fileInputStream);
                fileInputStream.close();
                Logger.logMessage(Logger.SEVERE, (short)255, "Loading configuration from backup file");
            }
            catch (FileNotFoundException fileNotFoundException2) {
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
        this.deserializeSimpleFields();
        this.deserializeComplexFields();
        this.handlePhexVersionAdjustments();
        if (this.mListeningPort == -1) {
            object = new Random(System.currentTimeMillis());
            this.mListeningPort = ((Random)object).nextInt();
            this.mListeningPort = this.mListeningPort < 0 ? -this.mListeningPort : this.mListeningPort;
            this.mListeningPort %= 20000;
            this.mListeningPort += 4000;
        }
        this.updateSystemSettings();
        object = new File(this.mDownloadDir);
        ((File)object).mkdirs();
        object = new File(this.incompleteDir);
        ((File)object).mkdirs();
    }

    public void save() {
        Logger.logMessage(Logger.FINEST, (short)255, "Saving configuration.");
        this.mSetting.clear();
        this.serializeSimpleFields();
        this.serializeComplexField();
        try {
            File file = this.configFile.getCanonicalFile();
            File file2 = this.configFile.getParentFile();
            File file3 = new File(file2, BACKUP_CONFIG_FILENAME);
            File file4 = File.createTempFile("config", "temp", file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            this.mSetting.store(fileOutputStream, "PHEX Config Values");
            fileOutputStream.close();
            file3.delete();
            if (this.configFile.exists() && !this.configFile.renameTo(file3)) {
                Logger.logMessage(Logger.SEVERE, (short)255, "Could not rename configuration file to backup name!");
            }
            if (!file4.renameTo(file)) {
                Logger.logMessage(Logger.SEVERE, (short)255, "Could not rename new configuration file to proper name!");
                file3.renameTo(file);
            }
            file4.delete();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private void loadDefaultValues() {
        this.maxDownloadsPerIP = 1;
        this.enableHitSnooping = true;
        this.maxMessageLength = 65536;
        this.isChatEnabled = true;
        this.allowToBecomeLeaf = true;
        this.forceUPConnections = false;
        this.forceToBeUltrapeer = false;
        this.allowToBecomeUP = true;
        this.isNoVendorNodeDisconnected = false;
        this.freeloaderFiles = 0;
        this.freeloaderShareSize = 0;
        this.hostErrorDisplayTime = 1000;
        this.ttl = 7;
        this.maxNetworkTTL = 7;
        this.up2upConnections = 32;
        this.up2leafConnections = 31;
        this.up2peerConnections = 2;
        this.leaf2upConnections = 5;
        this.leaf2peerConnections = 1;
        this.peerConnections = 4;
        this.arePartialFilesShared = true;
        this.allowUploadQueuing = true;
        this.maxUploadQueueSize = 100;
        this.minUploadQueuePollTime = 45;
        this.maxUploadQueuePollTime = 120;
        this.isDeflateConnectionAccepted = true;
        this.lastShownUpdateInfoId = 0;
        this.initialSegmentSize = 16384;
        this.segmentTransferTime = 90;
        this.minimumAllowedTransferRate = 1L;
        this.maximumSegmentSize = 0xA00000L;
        this.urnCalculationMode = (short)2;
        this.orderingMethod = 322;
        this.fallbackPreviewMethod = "";
        this.completionNotifyMethod = null;
        this.copyBeforePreviewing = true;
        this.segmentMultiple = 4096L;
        this.socketConnectTimeout = 60000;
        this.socketRWTimeout = 60000;
        this.offlineConnectionFailureCount = 100;
        this.loggerVerboseLevel = (short)6;
        this.maxConnectToHistorySize = 10;
        this.maxSearchTermHistorySize = 10;
    }

    private String get(String string) {
        String string2 = (String)this.mSetting.get(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null || string3.equals(UNSET_STRING)) {
            return string2;
        }
        return string3;
    }

    private void set(String string, String string2) {
        if (string2 == null) {
            string2 = new String(UNSET_STRING);
        }
        this.mSetting.put(string, string2);
    }

    private void set(String string, long l) {
        this.mSetting.put(string, String.valueOf(l));
    }

    private void set(String string, double d) {
        this.mSetting.put(string, String.valueOf(d));
    }

    private void set(String string, boolean bl) {
        this.mSetting.put(string, bl ? "true" : "false");
    }

    private void serializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            int n = fieldArray[i].getModifiers();
            Class<?> clazz = fieldArray[i].getType();
            if (!Modifier.isPublic(n) || Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
            try {
                String string2;
                Object object;
                int n2;
                Object object2;
                if (clazz.getName().equals("int")) {
                    this.set(string, fieldArray[i].getInt(this));
                    continue;
                }
                if (clazz.getName().equals("short")) {
                    this.set(string, fieldArray[i].getShort(this));
                    continue;
                }
                if (clazz.getName().equals("long")) {
                    this.set(string, fieldArray[i].getLong(this));
                    continue;
                }
                if (clazz.getName().equals("float")) {
                    this.set(string, fieldArray[i].getFloat(this));
                    continue;
                }
                if (clazz.getName().equals("boolean")) {
                    this.set(string, fieldArray[i].getBoolean(this));
                    continue;
                }
                if (clazz.getName().equals("java.lang.String")) {
                    this.set(string, (String)fieldArray[i].get(this));
                    continue;
                }
                if (clazz.getName().equals("java.util.ArrayList")) {
                    object2 = (List)fieldArray[i].get(this);
                    for (n2 = 0; n2 < object2.size(); ++n2) {
                        object = new String(fieldArray[i].getName() + '_' + (n2 + 1));
                        this.set((String)object, object2.get(n2).toString());
                    }
                    continue;
                }
                if (clazz.getName().equals("java.util.HashMap")) {
                    object2 = (Map)fieldArray[i].get(this);
                    if (object2.keySet().size() == 0) continue;
                    Iterator iterator = object2.keySet().iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        string2 = new String(fieldArray[i].getName() + '_' + (String)object);
                        this.set(string2, (String)object2.get(object));
                    }
                    continue;
                }
                if (!clazz.getName().equals("java.util.HashSet") || (object2 = (Set)fieldArray[i].get(this)).size() == 0) continue;
                n2 = 0;
                object = object2.iterator();
                while (object.hasNext()) {
                    string2 = new String(fieldArray[i].getName() + '_' + "SET" + ++n2);
                    this.set(string2, (String)object.next());
                }
                continue;
            }
            catch (Exception exception) {
                Logger.logError(exception, "Error in field: " + string);
            }
        }
    }

    private void serializeComplexField() {
        try {
            this.set("mProgramClientID", this.mProgramClientID.toHexString());
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    private void deserializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            int n = fieldArray[i].getModifiers();
            Class<?> clazz = fieldArray[i].getType();
            String string2 = "";
            if (!Modifier.isPublic(n) || Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
            try {
                if (this.deserialiseMap(fieldArray[i])) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.deserialiseList(fieldArray[i])) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.deserialiseSet(fieldArray[i])) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string2 = this.get(string);
                if (string2 == null) {
                    System.out.println(string + ": ");
                    try {
                        string2 = (String)this.getClass().getDeclaredField("default_" + fieldArray[i].getName()).get(this);
                        System.out.println(fieldArray[i].getName() + ": " + string2);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (string2 == null) continue;
                if (clazz.getName().equals("int")) {
                    fieldArray[i].setInt(this, Integer.parseInt(string2));
                    continue;
                }
                if (clazz.getName().equals("short")) {
                    fieldArray[i].setShort(this, Short.parseShort(string2));
                    continue;
                }
                if (clazz.getName().equals("long")) {
                    fieldArray[i].setLong(this, Long.parseLong(string2));
                    continue;
                }
                if (clazz.getName().equals("float")) {
                    fieldArray[i].setFloat(this, Float.parseFloat(string2));
                    continue;
                }
                if (clazz.getName().equals("boolean")) {
                    fieldArray[i].setBoolean(this, string2.equals("true"));
                    continue;
                }
                if (!clazz.getName().equals("java.lang.String")) continue;
                fieldArray[i].set(this, string2);
                continue;
            }
            catch (Exception exception) {
                Logger.logError(exception, "Error in field: " + string + ", value: " + string2);
            }
        }
    }

    private boolean deserialiseMap(Field field) {
        boolean bl = false;
        try {
            if (field.getType().getName().equals("java.util.HashMap")) {
                field.set(this, new HashMap());
                Map map = (Map)field.get(this);
                String string = new String(field.getName() + '_');
                Enumeration<?> enumeration = this.mSetting.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(string) || (string2 = string3.substring(string.length())).length() <= 0 || this.mSetting.getProperty(string3).length() <= 0) continue;
                    map.put(string2, this.mSetting.getProperty(string3));
                }
                bl = true;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean deserialiseList(Field field) {
        boolean bl;
        block7: {
            bl = false;
            try {
                String string;
                if (!field.getType().getName().equals("java.util.ArrayList")) break block7;
                field.set(this, new ArrayList());
                List list = (List)field.get(this);
                int n = 1;
                while ((string = this.get(field.getName() + '_' + n)) != null && string.length() > 0) {
                    list.add(string);
                    ++n;
                }
                if (n == 1) {
                    try {
                        Object object = this.getClass().getDeclaredField("default_" + field.getName()).get(this);
                        String string2 = (String)object;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            list.add(stringTokenizer.nextToken());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    private boolean deserialiseSet(Field field) {
        boolean bl = false;
        try {
            if (field.getType().getName().equals("java.util.HashSet")) {
                field.set(this, new HashSet());
                Set set = (Set)field.get(this);
                String string = new String(field.getName() + '_' + "SET");
                Enumeration<?> enumeration = this.mSetting.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.startsWith(string) || this.mSetting.getProperty(string2).length() <= 0) continue;
                    set.add(this.mSetting.getProperty(string2));
                }
                bl = true;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void deserializeComplexFields() {
        try {
            try {
                this.mProgramClientID.fromHexString(this.get("mProgramClientID"));
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    public void updateSystemSettings() {
        System.setProperty("http.agent", Environment.getPhexVendor());
        if (this.isHttpProxyUsed) {
            System.setProperty("http.proxyHost", this.httpProxyHost);
            System.setProperty("http.proxyPort", String.valueOf(this.httpProxyPort));
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
        System.setProperty("networkaddress.cache.ttl", "1800");
        Security.setProperty("networkaddress.cache.ttl", "1800");
    }

    private void handlePhexVersionAdjustments() {
        if (!(this.runningPhexVersion != null && this.runningPhexVersion.length() != 0 || this.runningBuildNumber != null && this.runningBuildNumber.length() != 0)) {
            this.updatesForBuild78();
        } else {
            if (this.runningPhexVersion == null || this.runningPhexVersion.length() == 0) {
                this.runningPhexVersion = "0.6";
            }
            if (VersionUtils.compare("0.7", this.runningPhexVersion) > 0) {
                this.updatesFor0_7();
            }
            if (VersionUtils.compare("0.8", this.runningPhexVersion) > 0) {
                this.updatesFor0_8();
            }
            if (this.runningBuildNumber == null || this.runningBuildNumber.length() == 0) {
                this.runningBuildNumber = "35";
            }
            if (VersionUtils.compare("36", this.runningBuildNumber) > 0) {
                this.updatesForBuild36();
            }
            if (VersionUtils.compare("42", this.runningBuildNumber) > 0) {
                this.updatesForBuild42();
            }
            if (VersionUtils.compare("56", this.runningBuildNumber) > 0) {
                this.updatesForBuild56();
            }
            if (VersionUtils.compare("78", this.runningBuildNumber) > 0) {
                this.updatesForBuild78();
            }
            if (VersionUtils.compare("81", this.runningBuildNumber) > 0) {
                this.updatesForBuild81();
            }
        }
        this.runningBuildNumber = Environment.getInstance().getProperty("build.number");
        this.runningPhexVersion = Res.getStr("Program.Version");
        this.save();
    }

    private void updatesFor0_7() {
        try {
            File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
            if (file.exists()) {
                FileUtils.copyFile(file, new File(file.getAbsolutePath() + ".v0.6.4"));
            }
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        this.runningPhexVersion = "0.7";
    }

    private void updatesFor0_8() {
        this.peerConnections = this.mNetMinConn;
        this.runningPhexVersion = "0.8";
        this.mUploadMaxSearch = 64;
        this.mNetMaxHostToCatch = 1000;
    }

    private void updatesForBuild36() {
        this.runningBuildNumber = "36";
        this.allowToBecomeLeaf = this.allowUPConnections;
    }

    private void updatesForBuild42() {
        this.runningBuildNumber = "42";
        if (this.up2upConnections < 32) {
            this.up2upConnections = 32;
        }
    }

    private void updatesForBuild56() {
        this.runningBuildNumber = "56";
        this.lastUpdateCheckTime = 0L;
    }

    private void updatesForBuild78() {
        this.runningBuildNumber = "78";
        this.u78("mNetNetworkHistory", " ");
        this.u78("filteredCatcherPorts", " ");
        this.u78("connectToHistory", " ");
        this.u78("searchTermHistory", ",");
    }

    private void u78(String string, String string2) {
        String string3 = this.get(string);
        try {
            if (string3 != null) {
                List list = (List)this.getClass().getDeclaredField(string).get(this);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
                while (stringTokenizer.hasMoreTokens()) {
                    list.add(stringTokenizer.nextToken());
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new Error("No such field: " + string + "!");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Cannot convert " + string + " to a list!!");
        }
    }

    private void updatesForBuild81() {
        this.runningBuildNumber = "81";
        StringTokenizer stringTokenizer = new StringTokenizer(this.mUploadDir, ";");
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken().trim());
            if (this.sharedDirectoriesSet.contains(file)) continue;
            this.sharedDirectoriesSet.add(file);
        }
    }
}

