/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import phex.chat.ChatManager;
import phex.common.Ip2CountryManager;
import phex.common.Manager;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.NetworkManager;
import phex.download.swarming.SwarmingManager;
import phex.gwebcache.GWebCacheManager;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareManager;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.VersionUtils;

public class Environment {
    private static final Class[] MANAGER_CLASSES = new Class[]{SwarmingManager.class, NetworkManager.class, UploadManager.class, ShareManager.class, QueryManager.class, ChatManager.class, HostManager.class, PhexSecurityManager.class, MsgManager.class, StatisticsManager.class, BandwidthManager.class, GWebCacheManager.class, Ip2CountryManager.class};
    private static Environment environment;
    private Properties properties;
    private File configurationRoot;
    private Timer timerService;
    private boolean isWindowsOS;
    private boolean isWin2000orXpOS;
    private boolean isMacOSX;
    private String javaVersion;

    private Environment() {
        try {
            this.properties = new Properties();
            this.properties.load(Environment.class.getResourceAsStream("/phex/resources/version.properties"));
        }
        catch (IOException iOException) {
            NLogger.error("STARTUP", iOException, iOException);
            throw new RuntimeException();
        }
        this.initializeOS();
        this.initializeJavaVersion();
        this.timerService = new Timer(true);
    }

    public static Environment getInstance() {
        if (environment == null) {
            environment = new Environment();
        }
        return environment;
    }

    public void initializeManagers() {
        Manager manager;
        int n;
        ArrayList<Manager> arrayList = new ArrayList<Manager>(MANAGER_CLASSES.length);
        for (n = 0; n < MANAGER_CLASSES.length; ++n) {
            long l = System.currentTimeMillis();
            try {
                Logger.logMessage(Logger.FINER, (short)255, "Initializing " + MANAGER_CLASSES[n].getName());
                Method method = MANAGER_CLASSES[n].getMethod("getInstance", new Class[0]);
                manager = (Manager)method.invoke(null, new Object[0]);
                boolean bl = manager.initialize();
                if (!bl) {
                    Logger.logError((short)255, "Failed to initialize " + manager.getClass().getName());
                    throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
                }
                arrayList.add(manager);
                long l2 = System.currentTimeMillis();
                Logger.logMessage(Logger.INFO, (short)64, "Initialization time: " + (l2 - l) + " - " + manager.getClass().getName());
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.logError(invocationTargetException);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.logError(noSuchMethodException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            long l = System.currentTimeMillis();
            manager = (Manager)arrayList.get(i);
            Logger.logMessage(Logger.FINER, (short)255, "On post initialization " + manager.getClass().getName());
            boolean bl = manager.onPostInitialization();
            if (!bl) {
                Logger.logError((short)255, "Failed to initialize " + manager.getClass().getName());
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long l3 = System.currentTimeMillis();
            Logger.logMessage(Logger.INFO, (short)64, "Post-Initialization time: " + (l3 - l) + " - " + manager.getClass().getName());
        }
    }

    public void startupCompletedNotify() {
        Object object = null;
        for (int i = 0; i < MANAGER_CLASSES.length; ++i) {
            long l = System.currentTimeMillis();
            try {
                Logger.logMessage(Logger.FINER, (short)255, "StartupCompletedNotify " + MANAGER_CLASSES[i].getName());
                Method method = MANAGER_CLASSES[i].getMethod("getInstance", new Class[0]);
                object = (Manager)method.invoke(null, new Object[0]);
                object.startupCompletedNotify();
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.logError(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.logError(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            long l2 = System.currentTimeMillis();
            Logger.logMessage(Logger.INFO, (short)64, "StartupCompletedNotify time: " + (l2 - l) + " - " + object.getClass().getName());
        }
    }

    public void shutdownManagers() {
        for (int i = 0; i < MANAGER_CLASSES.length; ++i) {
            try {
                Logger.logMessage(Logger.FINER, (short)255, "Shutdown " + MANAGER_CLASSES[i].getName());
                Method method = MANAGER_CLASSES[i].getMethod("getInstance", new Class[0]);
                Manager manager = (Manager)method.invoke(null, new Object[0]);
                manager.shutdown();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.logError(invocationTargetException);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.logError(noSuchMethodException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
                continue;
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    public void setPhexConfigRoot(File file) throws IOException {
        boolean bl;
        if (file == null) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(System.getProperty("user.home"));
            stringBuffer.append(File.separator);
            if (File.separatorChar == '/') {
                stringBuffer.append('.');
            }
            stringBuffer.append("phex");
            file = new File(stringBuffer.toString());
        }
        if (!file.isDirectory() && !(bl = file.mkdirs())) {
            throw new IOException("Cant create directory: " + file.getAbsolutePath());
        }
        this.configurationRoot = file;
    }

    public File getPhexConfigFile(String string) {
        if (this.configurationRoot == null) {
            try {
                this.setPhexConfigRoot(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new File(this.configurationRoot, string);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public static String getPhexVendor() {
        return "Phex " + VersionUtils.getFullProgramVersion();
    }

    public void scheduleTimerTask(TimerTask timerTask, long l, long l2) {
        this.timerService.schedule(timerTask, l, l2);
    }

    public void scheduleTimerTask(TimerTask timerTask, long l) {
        this.timerService.schedule(timerTask, l);
    }

    public boolean isWindowsOS() {
        return this.isWindowsOS;
    }

    public boolean isMacOSX() {
        return this.isMacOSX;
    }

    public boolean isUltrapeerOS() {
        return !this.isWindowsOS || this.isWin2000orXpOS;
    }

    private void initializeOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os")) {
            this.isMacOSX = string.endsWith("x");
            return;
        }
        if (string.indexOf("windows") != -1) {
            this.isWindowsOS = true;
            if (string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
                this.isWin2000orXpOS = true;
            }
            return;
        }
    }

    private void initializeJavaVersion() {
        this.javaVersion = System.getProperty("java.version");
    }

    public boolean isJava14orLater() {
        return !this.javaVersion.startsWith("1.3") && !this.javaVersion.startsWith("1.2") && !this.javaVersion.startsWith("1.1") && !this.javaVersion.startsWith("1.0");
    }
}

