/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import phex.xml.XJBMediaType;

public class MediaType {
    public static final String MEDIA_TYPE_ANY = "AnyMediaType";
    public static final String MEDIA_TYPE_AUDIO = "AudioMediaType";
    public static final String MEDIA_TYPE_VIDEO = "VideoMediaType";
    public static final String MEDIA_TYPE_PROGRAM = "ProgramMediaType";
    public static final String MEDIA_TYPE_IMAGES = "ImagesMediaType";
    public static final String MEDIA_TYPE_DOCUMENTS = "DocumentsMediaType";
    private static MediaType[] allMediaTypes = new MediaType[6];
    private String name;
    private String[] fileTypes;
    private String fileTypesView;

    private MediaType(String string, String[] stringArray) {
        this.name = string;
        this.fileTypes = stringArray;
    }

    public String getName() {
        return this.name;
    }

    public String getFileTypesUIText() {
        if (this.fileTypesView == null) {
            if (this.fileTypes == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.fileTypes.length * 5);
            stringBuffer.append("<html>");
            int n = 0;
            for (int i = 0; i < this.fileTypes.length; ++i) {
                stringBuffer.append(this.fileTypes[i]);
                n += this.fileTypes[i].length();
                if (i < this.fileTypes.length - 1) {
                    stringBuffer.append(", ");
                    ++n;
                }
                if (n <= 50) continue;
                n = 0;
                stringBuffer.append("<br>");
            }
            this.fileTypesView = stringBuffer.toString();
        }
        return this.fileTypesView;
    }

    public boolean isExtensionOf(String string) {
        if (this.fileTypes == null) {
            return true;
        }
        string = string.toLowerCase();
        for (int i = 0; i < this.fileTypes.length; ++i) {
            if (!this.fileTypes[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isFilenameOf(String string) {
        if (this.fileTypes == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length()) {
            return false;
        }
        String string2 = string.substring(n + 1, string.length());
        return this.isExtensionOf(string2);
    }

    public static MediaType[] getAllMediaTypes() {
        return allMediaTypes;
    }

    public static MediaType getMediaTypeAny() {
        return allMediaTypes[0];
    }

    public static XJBMediaType convertToXJBMediaType(MediaType mediaType) {
        if (mediaType.name.equals(MEDIA_TYPE_ANY)) {
            return XJBMediaType.ANY;
        }
        if (mediaType.name.equals(MEDIA_TYPE_AUDIO)) {
            return XJBMediaType.AUDIO;
        }
        if (mediaType.name.equals(MEDIA_TYPE_VIDEO)) {
            return XJBMediaType.VIDEO;
        }
        if (mediaType.name.equals(MEDIA_TYPE_PROGRAM)) {
            return XJBMediaType.PROGRAM;
        }
        throw new IllegalArgumentException("Unknown media type: " + mediaType.name);
    }

    public static MediaType convertFromXJBMediaType(XJBMediaType xJBMediaType) {
        if (xJBMediaType == XJBMediaType.ANY) {
            return allMediaTypes[0];
        }
        if (xJBMediaType == XJBMediaType.AUDIO) {
            return allMediaTypes[1];
        }
        if (xJBMediaType == XJBMediaType.VIDEO) {
            return allMediaTypes[2];
        }
        if (xJBMediaType == XJBMediaType.PROGRAM) {
            return allMediaTypes[3];
        }
        throw new IllegalArgumentException("Unknown media type: " + xJBMediaType.toString());
    }

    static {
        MediaType.allMediaTypes[0] = new MediaType(MEDIA_TYPE_ANY, null);
        MediaType.allMediaTypes[1] = new MediaType(MEDIA_TYPE_AUDIO, new String[]{"aif", "aifc", "aiff", "ape", "apl", "au", "iso", "lqt", "mac", "med", "mid", "midi", "mod", "mp3", "mpa", "mpga", "mp1", "ogg", "ra", "ram", "rm", "rmi", "rmj", "snd", "vqf", "wav", "wma"});
        MediaType.allMediaTypes[2] = new MediaType(MEDIA_TYPE_VIDEO, new String[]{"asf", "avi", "dcr", "div", "divx", "dv", "dvd", "dvx", "flc", "fli", "flx", "jve", "m2p", "m2v", "m1v", "mng", "mov", "mp2", "mp2v", "mp4", "mpe", "mpeg", "mpg", "mpv", "mpv2", "nsv", "ram", "rm", "rv", "smi", "smil", "swf", "qt", "vcd", "vob", "vrml", "wml", "wmv"});
        MediaType.allMediaTypes[3] = new MediaType(MEDIA_TYPE_PROGRAM, new String[]{"7z", "ace", "arj", "awk", "bin", "bz2", "cab", "csh", "deb", "dmg", "exe", "gz", "gzip", "hqx", "iso", "jar", "lzh", "lha", "mdb", "msi", "msp", "pl", "rar", "rpm", "sh", "shar", "sit", "tar", "tgz", "taz", "z", "zip", "zoo"});
        MediaType.allMediaTypes[4] = new MediaType(MEDIA_TYPE_IMAGES, new String[]{"ani", "bmp", "cpt", "cur", "dcx", "dib", "drw", "emf", "fax", "gif", "icl", "ico", "iff", "ilbm", "img", "jif", "jiff", "jpe", "jpeg", "jpg", "lbm", "mac", "mic", "pbm", "pcd", "pct", "pcx", "pic", "png", "pnm", "ppm", "psd", "ras", "rgb", "rle", "sgi", "sxd", "svg", "tga", "tif", "tiff", "wmf", "wpg", "xbm", "xcf", "xpm", "xwd"});
        MediaType.allMediaTypes[5] = new MediaType(MEDIA_TYPE_DOCUMENTS, new String[]{"ans", "asc", "chm", "csv", "dif", "diz", "doc", "eml", "eps", "epsf", "hlp", "html", "htm", "info", "latex", "man", "mcw", "mht", "mhtml", "pdf", "ppt", "ps", "rtf", "sxw", "sxc", "tex", "texi", "txt", "wk1", "wps", "wri", "xhtml", "xls", "xml"});
    }
}

