/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import phex.common.URN;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.InvalidMessageException;
import phex.msg.MsgQuery;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class QueryRoutingTable {
    public static final byte DEFAULT_INFINITY_TTL = 7;
    public static final int DEFAULT_TABLE_SIZE = 65536;
    private BitSet qrTable;
    private BitSet resizedQRTable;
    private int tableSize;
    private byte tableBits;
    private byte infinity;
    private int entryCount;
    private byte sequenceSize;
    private byte sequenceNumber;
    private int patchPosition;
    private Inflater inflater;
    private static final int A_INT = 1327217884;

    public QueryRoutingTable() {
        this.init(65536, (byte)7);
    }

    private void init(int n, byte by) {
        this.tableSize = n;
        this.infinity = by;
        this.tableBits = IOUtil.calculateLog2(n);
        this.qrTable = new BitSet(n);
        this.resizedQRTable = null;
        this.entryCount = 0;
        this.sequenceSize = 0;
        this.sequenceNumber = 0;
        this.patchPosition = 0;
        this.inflater = null;
    }

    public void aggregateToRouteTable(QueryRoutingTable queryRoutingTable) {
        BitSet bitSet = this.tableSize != queryRoutingTable.tableSize ? queryRoutingTable.resizeRouteTable(this.tableSize) : queryRoutingTable.qrTable;
        this.qrTable.or(bitSet);
    }

    private void add(String string) {
        String[] stringArray = QueryRoutingTable.splitFilePath(string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = QueryRoutingTable.qrpHash(stringArray[i], 0, stringArray[i].length(), this.tableBits);
            if (this.qrTable.get(n)) continue;
            ++this.entryCount;
            this.qrTable.set(n);
            this.resizedQRTable = null;
        }
    }

    private void addWord(String string) {
        int n = QueryRoutingTable.qrpHash(string, 0, string.length(), this.tableBits);
        if (!this.qrTable.get(n)) {
            ++this.entryCount;
            this.qrTable.set(n);
            this.resizedQRTable = null;
        }
    }

    public boolean containsQuery(MsgQuery msgQuery) {
        if (msgQuery.hasQueryURNs()) {
            URN[] uRNArray = msgQuery.getQueryURNs();
            for (int i = 0; i < uRNArray.length; ++i) {
                String string = uRNArray[i].getAsString();
                int n = QueryRoutingTable.qrpHash(string, 0, string.length(), this.tableBits);
                if (!this.qrTable.get(n)) continue;
                return true;
            }
            return false;
        }
        String string = msgQuery.getSearchString();
        if (string == null) {
            return false;
        }
        String[] stringArray = QueryRoutingTable.splitQueryString(string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = QueryRoutingTable.qrpHash(stringArray[i], 0, stringArray[i].length(), this.tableBits);
            if (this.qrTable.get(n)) continue;
            return false;
        }
        return true;
    }

    public void updateRouteTable(RouteTableUpdateMsg routeTableUpdateMsg) throws InvalidMessageException {
        if (routeTableUpdateMsg.getVariant() == 0) {
            int n = ((QRResetTableMsg)routeTableUpdateMsg).getTableSize();
            Logger.logMessage(Logger.FINER, (short)16, "Reseting QRT from: " + routeTableUpdateMsg.getHeader().getFromHost() + " Size: " + n);
            this.init(n, this.infinity);
        } else if (routeTableUpdateMsg.getVariant() == 1) {
            byte by;
            int n;
            byte by2;
            QRPatchTableMsg qRPatchTableMsg = (QRPatchTableMsg)routeTableUpdateMsg;
            byte by3 = qRPatchTableMsg.getSequenceSize();
            byte by4 = qRPatchTableMsg.getSequenceNumber();
            Logger.logMessage(Logger.FINER, (short)16, "Patching QRT from: " + routeTableUpdateMsg.getHeader().getFromHost() + " " + by4 + "/" + by3);
            if (this.sequenceSize == 0 && this.sequenceNumber == 0) {
                this.sequenceSize = by3;
                this.sequenceNumber = 1;
            }
            if (this.sequenceSize != by3 || by4 != this.sequenceNumber || by3 == 0) {
                throw new InvalidMessageException("QRTPatchMsg sequence size or number not valid.\nSize: (" + by3 + "/" + this.sequenceSize + ").\n" + "Number: (" + by4 + "/" + this.sequenceNumber + ").");
            }
            this.sequenceNumber = by4;
            byte[] byArray = qRPatchTableMsg.getPatchData();
            byte by5 = qRPatchTableMsg.getCompressor();
            if (by5 == 1) {
                block30: {
                    if (this.sequenceNumber == 1) {
                        this.inflater = new Inflater();
                    }
                    try {
                        byArray = IOUtil.inflate(this.inflater, byArray);
                    }
                    catch (DataFormatException dataFormatException) {
                        byArray = null;
                        if (!Logger.isLevelTypeLogged(Logger.WARNING, (short)16)) break block30;
                        Logger.logWarning((short)16, dataFormatException, "Invalid QRT data format to inflate.");
                    }
                }
                if (byArray == null) {
                    throw new InvalidMessageException("Can't inflate patch data");
                }
            } else if (by5 != 0) {
                throw new InvalidMessageException("QRTPatchMsg Unknown compression: " + by5);
            }
            if ((by2 = qRPatchTableMsg.getEntryBits()) == 4) {
                byte[] byArray2 = new byte[byArray.length * 2];
                for (n = 0; n < byArray.length; ++n) {
                    byArray2[n * 2] = (byte)(byArray[n] >> 4);
                    by = (byte)(byArray[n] & 0xF);
                    if ((by & 8) != 0) {
                        by = (byte)(0xF0 | by);
                    }
                    byArray2[n * 2 + 1] = by;
                }
                byArray = byArray2;
            } else if (by2 != 8) {
                throw new InvalidMessageException("QRTPatchMsg Unknown ENTRY_BITS value: " + by2);
            }
            try {
                n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    boolean bl = this.qrTable.get(this.patchPosition);
                    if (byArray[i] < 0) {
                        this.qrTable.set(this.patchPosition);
                        this.resizedQRTable = null;
                    } else if (byArray[i] > 0) {
                        this.qrTable.clear(this.patchPosition);
                        this.resizedQRTable = null;
                    } else if (byArray[i] != 0 && (n == 0 || n != byArray[i])) {
                        Logger.logWarning((short)16, routeTableUpdateMsg.getHeader().getFromHost(), (Object)("Received invalid PatchData field value: " + byArray[i]));
                        n = byArray[i];
                    }
                    by = (byte)(this.qrTable.get(this.patchPosition) ? 1 : 0);
                    if (bl && by == 0) {
                        --this.entryCount;
                    } else if (!bl && by != 0) {
                        ++this.entryCount;
                    }
                    ++this.patchPosition;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidMessageException("QRTPatchMsg Wrong patch message data size.");
            }
            if (this.sequenceNumber == this.sequenceSize) {
                this.sequenceSize = 0;
                this.sequenceNumber = 0;
                this.patchPosition = 0;
                this.inflater = null;
                Logger.logMessage(Logger.FINER, (short)16, "Updated QRT: " + this.entryCount + " / " + this.tableSize);
            } else {
                this.sequenceNumber = (byte)(this.sequenceNumber + 1);
            }
        }
    }

    private BitSet resizeRouteTable(int n) {
        if (this.tableSize == n) {
            return this.qrTable;
        }
        if (this.resizedQRTable != null && this.resizedQRTable.size() == n) {
            return this.resizedQRTable;
        }
        this.resizedQRTable = new BitSet(n);
        double d = (double)n / (double)this.tableSize;
        for (int i = 0; i < this.tableSize; ++i) {
            if (!this.qrTable.get(i)) continue;
            int n2 = (int)Math.floor((double)i * d);
            int n3 = (int)Math.ceil((double)(i + 1) * d);
            for (int j = n2; j < n3; ++j) {
                this.resizedQRTable.set(j);
            }
        }
        return this.resizedQRTable;
    }

    private static String[] splitQueryString(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()[]\\");
        ArrayList<String[]> arrayList = new ArrayList<String[]>(10);
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] splitFilePath(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()[]\\");
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
            int n = stringArray.length();
            for (int i = 1; i < 5 && n - i > 5; ++i) {
                arrayList.add(stringArray.substring(0, n - i));
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static QueryRoutingTable createLocalQueryRoutingTable() {
        Object[] objectArray;
        Object object;
        long l = System.currentTimeMillis();
        QueryRoutingTable queryRoutingTable = new QueryRoutingTable();
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        ShareFile[] shareFileArray = sharedFilesService.getSharedFiles();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < shareFileArray.length; ++i) {
            object = shareFileArray[i].getURN();
            if (object != null) {
                hashSet.add(((URN)object).getAsString());
            }
            objectArray = QueryRoutingTable.splitFilePath(shareFileArray[i].getSystemFile().getAbsolutePath());
            for (int j = 0; j < objectArray.length; ++j) {
                hashSet.add(objectArray[j]);
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            queryRoutingTable.addWord((String)iterator.next());
        }
        object = HostManager.getInstance();
        if (((HostManager)object).isUltrapeer()) {
            objectArray = ((HostManager)object).getNetworkHostsContainer().getLeafConnections();
            for (int i = 0; i < objectArray.length; ++i) {
                QueryRoutingTable queryRoutingTable2 = ((Host)objectArray[i]).getLastReceivedRoutingTable();
                if (queryRoutingTable2 == null) continue;
                queryRoutingTable.aggregateToRouteTable(queryRoutingTable2);
            }
        }
        long l2 = System.currentTimeMillis();
        Logger.logMessage(Logger.FINER, (short)16, "Created QRT: " + queryRoutingTable.entryCount + " / " + queryRoutingTable.tableSize + " time: " + (l2 - l));
        return queryRoutingTable;
    }

    public static Iterator buildRouteTableUpdateMsgIterator(QueryRoutingTable queryRoutingTable, QueryRoutingTable queryRoutingTable2) {
        int n;
        byte by;
        byte by2;
        byte by3;
        ArrayList<RouteTableUpdateMsg> arrayList = new ArrayList<RouteTableUpdateMsg>();
        if (queryRoutingTable2 == null) {
            arrayList.add(new QRResetTableMsg(queryRoutingTable.tableSize, queryRoutingTable.infinity));
        }
        boolean bl = false;
        byte[] byArray = new byte[queryRoutingTable.tableSize / 2];
        for (by3 = 0; by3 < byArray.length; ++by3) {
            byte by4;
            if (queryRoutingTable2 == null) {
                by4 = queryRoutingTable.qrTable.get(by3 * 2) ? (byte)(1 - queryRoutingTable.infinity) : (byte)0;
                by2 = queryRoutingTable.qrTable.get(by3 * 2 + 1) ? (byte)(1 - queryRoutingTable.infinity) : (byte)0;
            } else {
                by = (byte)(queryRoutingTable.qrTable.get(by3 * 2) ? 1 : 0);
                by4 = by == queryRoutingTable2.qrTable.get(by3 * 2) ? (byte)0 : (by != 0 ? (byte)(1 - queryRoutingTable.infinity) : (byte)(queryRoutingTable.infinity - 1));
                by = queryRoutingTable.qrTable.get(by3 * 2 + 1);
                by2 = by == queryRoutingTable2.qrTable.get(by3 * 2 + 1) ? (byte)0 : (by != 0 ? (byte)(1 - queryRoutingTable.infinity) : (byte)(queryRoutingTable.infinity - 1));
            }
            byArray[by3] = (byte)(by4 << 4 | by2 & 0xF);
            if (byArray[by3] == 0) continue;
            bl = true;
        }
        if (!bl) {
            return arrayList.iterator();
        }
        by3 = 0;
        byte[] byArray2 = IOUtil.deflate(byArray);
        if (byArray2.length < byArray.length) {
            byArray = byArray2;
            by3 = 1;
        }
        by2 = (byte)Math.ceil((double)byArray.length / 4096.0);
        by = 1;
        int n2 = 0;
        do {
            n = Math.min(4096, byArray.length - n2);
            QRPatchTableMsg qRPatchTableMsg = new QRPatchTableMsg(by, by2, by3, 4, byArray, n2, n);
            arrayList.add(qRPatchTableMsg);
            by = (byte)(by + 1);
        } while ((n2 += n) < byArray.length);
        return arrayList.iterator();
    }

    private static int qrpHash(String string, int n, int n2, byte by) {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            int n5 = Character.toLowerCase(string.charAt(i)) & 0xFF;
            n3 ^= (n5 <<= n4 * 8);
            n4 = (n4 + 1) % 4;
        }
        long l = (long)n3 * 1327217884L;
        long l2 = l << 32;
        return (int)(l2 >>>= 32 + (32 - by));
    }
}

