/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Vector;
import phex.utils.Logger;
import phex.utils.NLogger;

public class RunnerQueueWorker {
    private Vector queue = new Vector();
    private Thread runnerThread;

    public synchronized void stopAndClear() {
        this.queue.clear();
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
        }
    }

    public synchronized void add(Runnable runnable) {
        this.queue.add(runnable);
        this.notify();
        if (this.runnerThread == null) {
            this.createRunner();
        }
    }

    private synchronized void createRunner() {
        this.runnerThread = new Thread(new QueueWorker());
        this.runnerThread.setDaemon(true);
        this.runnerThread.start();
    }

    private class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Runnable runnable = (Runnable)RunnerQueueWorker.this.queue.remove(0);
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        NLogger.error("GLOBAL", throwable, throwable);
                    }
                    RunnerQueueWorker runnerQueueWorker = RunnerQueueWorker.this;
                    synchronized (runnerQueueWorker) {
                        if (!RunnerQueueWorker.this.queue.isEmpty()) {
                            continue;
                        }
                        try {
                            RunnerQueueWorker.this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (RunnerQueueWorker.this.queue.isEmpty()) break;
                    }
                }
                {
                    RunnerQueueWorker.this.runnerThread = null;
                }
            }
            catch (Exception exception) {
                RunnerQueueWorker.this.runnerThread = null;
                Logger.logError(exception);
            }
            if (!RunnerQueueWorker.this.queue.isEmpty()) {
                RunnerQueueWorker.this.createRunner();
            }
        }
    }
}

