/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.TransferDataProvider;
import phex.utils.Logger;

public class TransferRateService {
    private HashSet providerSet = new HashSet();

    public TransferRateService() {
        Environment.getInstance().scheduleTimerTask(new SetTimestampTimer(), 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransferDataProvider(TransferDataProvider transferDataProvider) {
        HashSet hashSet = this.providerSet;
        synchronized (hashSet) {
            this.providerSet.add(transferDataProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterTransferDataProvider(TransferDataProvider transferDataProvider) {
        HashSet hashSet = this.providerSet;
        synchronized (hashSet) {
            this.providerSet.remove(transferDataProvider);
        }
    }

    private class SetTimestampTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 10000L;

        private SetTimestampTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long l = System.currentTimeMillis();
                HashSet hashSet = TransferRateService.this.providerSet;
                synchronized (hashSet) {
                    Iterator iterator = TransferRateService.this.providerSet.iterator();
                    while (iterator.hasNext()) {
                        TransferDataProvider transferDataProvider = (TransferDataProvider)iterator.next();
                        transferDataProvider.setTransferRateTimestamp(l);
                    }
                }
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }
}

