/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.DoubleObj;
import phex.common.LongObj;
import phex.statistic.StatisticProvider;
import phex.utils.NLogger;
import phex.utils.StrUtil;

public class BandwidthController
implements StatisticProvider {
    private Object syncObject;
    private static final long MINUTES_5 = 300000L;
    private static final long ONE_SECOND = 1000L;
    private static final int DEFAULT_MINIMUM_BYTES = 1024;
    private static final int WINDOWS_PER_SECONDS = 5;
    private static final int MILLIS_PER_WINDOW = 200;
    private long startTime1 = 0L;
    private long startTime2 = 0L;
    private long totalBytes1 = 0L;
    private long totalBytes2 = 0L;
    private long thisRate = 0L;
    private long maxRate = 0L;
    private long lastSecondTime = 0L;
    private int bytesInSecond;
    private int bytesPerWindow;
    private int bytesRemaining;
    private long lastWindowTime;
    private long throttlingRate;
    private final String controllerName;
    private BandwidthController nextContollerInChain = null;

    private BandwidthController(String string, long l) {
        this.controllerName = string + " " + Integer.toHexString(this.hashCode());
        this.syncObject = new Object();
        this.setThrottlingRate(l);
        this.bytesRemaining = this.bytesPerWindow;
    }

    public synchronized BandwidthController linkControllerIntoChain(BandwidthController bandwidthController) {
        BandwidthController bandwidthController2 = this.nextContollerInChain;
        this.nextContollerInChain = bandwidthController;
        return bandwidthController2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThrottlingRate(long l) {
        Object object = this.syncObject;
        synchronized (object) {
            this.throttlingRate = l;
            this.bytesPerWindow = (int)((double)this.throttlingRate / 5.0);
            if (NLogger.isDebugEnabled("BANDWIDTH")) {
                NLogger.debug("BANDWIDTH", "[" + this.controllerName + "] Set throttling rate to " + l + "bps (" + this.bytesPerWindow + " per window)");
            }
            this.bytesRemaining = Math.min(this.bytesRemaining, this.bytesPerWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int demandBandwidth(int n) {
        Object object = this.syncObject;
        synchronized (object) {
            if (NLogger.isDebugEnabled("BANDWIDTH")) {
                NLogger.debug("BANDWIDTH", "[" + this.controllerName + "] Requesting " + n + " bytes.");
            }
            long l = System.currentTimeMillis();
            if (this.startTime1 == 0L || this.startTime2 > 0L && l - this.startTime2 > 300000L) {
                this.startTime1 = l;
            }
            if (l - this.startTime1 > 300000L && this.startTime2 == 0L) {
                this.startTime2 = l;
            }
            boolean bl = false;
            while (true) {
                long l2;
                long l3;
                if ((l3 = (l = System.currentTimeMillis()) - this.lastSecondTime) >= 1000L) {
                    double d = (double)l3 / 1000.0;
                    this.thisRate = (long)((double)this.bytesInSecond / d);
                    if (this.thisRate > this.maxRate) {
                        this.maxRate = this.thisRate;
                    }
                    this.lastSecondTime = l;
                    this.bytesInSecond = 0;
                }
                if ((l2 = l - this.lastWindowTime) >= 200L) {
                    this.bytesInSecond += this.bytesPerWindow - this.bytesRemaining;
                    this.bytesRemaining = this.bytesPerWindow;
                    this.lastWindowTime = l;
                    break;
                }
                if (this.bytesRemaining > 0) break;
                try {
                    Thread.sleep(200L - l2);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    break;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            int n2 = Math.min(n, this.bytesRemaining);
            if (NLogger.isDebugEnabled("BANDWIDTH")) {
                NLogger.debug("BANDWIDTH", "[" + this.controllerName + "] Authorised " + n2 + " bytes.");
            }
            if (this.nextContollerInChain != null) {
                n2 = this.nextContollerInChain.demandBandwidth(n2);
                if (NLogger.isDebugEnabled("BANDWIDTH")) {
                    NLogger.debug("BANDWIDTH", "[" + this.controllerName + "] Modified to " + n2 + " bytes in chain.");
                }
            }
            this.bytesRemaining -= n2;
            if (this.startTime1 > 0L) {
                this.totalBytes1 += (long)n2;
            }
            if (this.startTime2 > 0L) {
                this.totalBytes2 += (long)n2;
            }
            return n2;
        }
    }

    public String getName() {
        return this.controllerName;
    }

    public String toDebugString() {
        return "ThrottleController[Name:" + this.controllerName + ",bytesPerWindow:" + this.bytesPerWindow + ",bytesRemaining:" + this.bytesRemaining + ",Rate:" + this.getValue() + ",Avg:" + this.getAverageValue();
    }

    public static BandwidthController acquireBandwidthController(String string, long l) {
        return new BandwidthController(string, l);
    }

    public static void releaseController(BandwidthController bandwidthController) {
        bandwidthController.nextContollerInChain = null;
    }

    public Object getValue() {
        return new LongObj(this.thisRate);
    }

    public Object getAverageValue() {
        long l = System.currentTimeMillis();
        if (this.startTime2 > 0L && l - this.startTime2 > 300000L) {
            return new DoubleObj((double)this.totalBytes2 / (double)(l - this.startTime2) * 1000.0);
        }
        if ((double)this.startTime1 != 0.0 && l > this.startTime1) {
            return new DoubleObj((double)this.totalBytes1 / (double)(l - this.startTime1) * 1000.0);
        }
        return new DoubleObj(0.0);
    }

    public Object getMaxValue() {
        return new LongObj(this.maxRate);
    }

    public String toStatisticString(Object object) {
        return StrUtil.formatSizeBytes((Number)object) + " / sec.";
    }
}

