/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.TransferRateService;
import phex.common.bandwidth.BandwidthController;

public class BandwidthManager
implements Manager {
    private static BandwidthManager instance;
    private TransferRateService transferRateService;
    private BandwidthController phexBandwidthController;
    private BandwidthController networkBandwidthController;
    private BandwidthController downloadBandwidthController;
    private BandwidthController uploadBandwidthController;

    public void setDownloadBandwidth(int n) {
        ServiceManager.sCfg.mDownloadMaxBandwidth = n;
        this.downloadBandwidthController.setThrottlingRate(n);
    }

    public void setNetworkBandwidth(int n) {
        ServiceManager.sCfg.mNetMaxRate = n;
        this.networkBandwidthController.setThrottlingRate(n);
    }

    public void setPhexTotalBandwidth(int n) {
        ServiceManager.sCfg.maxTotalBandwidth = n;
        this.phexBandwidthController.setThrottlingRate(n);
    }

    public void setUploadBandwidth(int n) {
        ServiceManager.sCfg.mUploadMaxBandwidth = n;
        this.uploadBandwidthController.setThrottlingRate(n);
    }

    public BandwidthController getPhexBandwidthController() {
        return this.phexBandwidthController;
    }

    public BandwidthController getNetworkBandwidthController() {
        return this.networkBandwidthController;
    }

    public BandwidthController getDownloadBandwidthController() {
        return this.downloadBandwidthController;
    }

    public BandwidthController getUploadBandwidthController() {
        return this.uploadBandwidthController;
    }

    public TransferRateService getTransferRateService() {
        return BandwidthManager.getInstance().transferRateService;
    }

    public static BandwidthManager getInstance() {
        if (instance == null) {
            instance = new BandwidthManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.transferRateService = new TransferRateService();
        this.phexBandwidthController = BandwidthController.acquireBandwidthController("PhexThrottle", ServiceManager.sCfg.maxTotalBandwidth);
        this.networkBandwidthController = BandwidthController.acquireBandwidthController("NetworkThrottle", ServiceManager.sCfg.mNetMaxRate);
        this.networkBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.downloadBandwidthController = BandwidthController.acquireBandwidthController("DownloadThrottle", ServiceManager.sCfg.mDownloadMaxBandwidth);
        this.downloadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.uploadBandwidthController = BandwidthController.acquireBandwidthController("UploadThrottle", ServiceManager.sCfg.mUploadMaxBandwidth);
        this.uploadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        BandwidthController.releaseController(this.downloadBandwidthController);
        BandwidthController.releaseController(this.uploadBandwidthController);
        BandwidthController.releaseController(this.networkBandwidthController);
        BandwidthController.releaseController(this.phexBandwidthController);
    }
}

