/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import phex.common.HorizonTracker;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.ConnectionClosedException;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPProcessor;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgManager;
import phex.msg.MsgPing;
import phex.msg.MsgPong;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.QueryResponseRecord;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msg.vendor.PushProxyAcknowledgementVMsg;
import phex.msg.vendor.PushProxyRequestVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMsg;
import phex.net.OnlineObserver;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.MessageCountStatistic;
import phex.upload.PushWorker;
import phex.utils.HexConverter;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.VersionUtils;

public class ConnectionEngine
implements ConnectionConstants {
    private final HostManager hostMgr;
    private final ShareManager shareMgr;
    private final QueryHistoryMonitor queryHistory;
    private final SharedFilesService sharedFilesService;
    private final MsgManager messageMgr;
    private final NetworkManager networkMgr;
    private final PhexSecurityManager securityManager;
    private byte[] headerBuffer;
    private final Host connectedHost;
    private Connection connection;
    private HTTPHeaderGroup headersRead;
    private HTTPHeaderGroup headersSend;

    public ConnectionEngine(Host host) throws IOException {
        this.connectedHost = host;
        this.connection = host.getConnection();
        this.shareMgr = ShareManager.getInstance();
        this.sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        this.queryHistory = QueryManager.getInstance().getQueryHistoryMonitor();
        this.messageMgr = MsgManager.getInstance();
        this.hostMgr = HostManager.getInstance();
        this.networkMgr = NetworkManager.getInstance();
        this.securityManager = PhexSecurityManager.getInstance();
    }

    public void processIncomingData() throws IOException {
        this.headerBuffer = new byte[23];
        try {
            while (true) {
                Message message;
                MsgHeader msgHeader;
                block23: {
                    msgHeader = this.readHeader();
                    byte[] byArray = MessageProcessor.readMessageBody(this.connection, msgHeader.getDataLen());
                    this.connectedHost.incReceivedCount();
                    byte by = msgHeader.getTTL();
                    byte by2 = msgHeader.getHopsTaken();
                    if (by < 0 || by2 < 0) {
                        this.dropMessage(msgHeader, byArray, "TTL or hops below 0");
                        continue;
                    }
                    if (by2 >= ServiceManager.sCfg.maxNetworkTTL) {
                        this.dropMessage(msgHeader, byArray, "Hops larger then maxNetworkTTL");
                        continue;
                    }
                    if (by >= ServiceManager.sCfg.maxNetworkTTL) {
                        msgHeader.setTTL((byte)(ServiceManager.sCfg.maxNetworkTTL - by2));
                    }
                    try {
                        message = MessageProcessor.createMessageFromBody(msgHeader, byArray);
                        if (message == null) {
                            this.dropMessage(msgHeader, byArray, "Unknown message type");
                        }
                        break block23;
                    }
                    catch (InvalidMessageException invalidMessageException) {
                        this.dropMessage(msgHeader, byArray, "Invalid message: " + invalidMessageException.getMessage());
                        NLogger.warn("INCOMING_MESSAGES", invalidMessageException, invalidMessageException);
                    }
                    continue;
                }
                msgHeader.countHop();
                switch (msgHeader.getPayload()) {
                    case 0: {
                        this.handlePing((MsgPing)message);
                        break;
                    }
                    case 1: {
                        this.handlePong((MsgPong)message);
                        break;
                    }
                    case 64: {
                        this.handlePushRequest((MsgPushRequest)message);
                        break;
                    }
                    case -128: {
                        this.handleQuery((MsgQuery)message);
                        break;
                    }
                    case -127: {
                        this.handleQueryResponse((MsgQueryResponse)message);
                        break;
                    }
                    case 48: {
                        this.handleRouteTableUpdate((RouteTableUpdateMsg)message);
                        break;
                    }
                    case 49: 
                    case 50: {
                        this.handleVendorMessage((VendorMsg)message);
                    }
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage(Logger.WARNING, (short)16, unknownHostException);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, unknownHostException.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw new IOException("Exception occured: " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINEST, (short)16, iOException);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, iOException.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw iOException;
        }
        catch (Exception exception) {
            Logger.logMessage(Logger.WARNING, (short)16, exception);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, exception.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw new IOException("Exception occured: " + exception.getMessage());
        }
    }

    private void handlePing(MsgPing msgPing) {
        if (NLogger.isDebugEnabled("INCOMING_MESSAGES")) {
            NLogger.debug("INCOMING_MESSAGES", "Received Ping: " + msgPing.getDebugString() + " - " + msgPing.getHeader().getDebugString());
        }
        MessageCountStatistic.pingMsgInCounter.increment(1);
        MsgHeader msgHeader = msgPing.getHeader();
        if (!this.messageMgr.checkAndAddToPingRoutingTable(msgHeader.getMsgID(), this.connectedHost)) {
            this.dropMessage(msgPing, "Dropping already seen ping");
            return;
        }
        if (msgPing.getHeader().getTTL() > 0) {
            this.messageMgr.forwardPing(msgPing, this.connectedHost);
        }
        this.respondToPing(msgPing);
    }

    private void respondToPing(MsgPing msgPing) {
        byte by;
        MsgHeader msgHeader = msgPing.getHeader();
        byte by2 = msgHeader.getTTL();
        if (by2 + (by = msgHeader.getHopsTaken()) > 2 && !this.hostMgr.areIncommingSlotsAdvertised()) {
            return;
        }
        byte by3 = by;
        by = (byte)(by + 1);
        byte by4 = by3;
        if (by + by2 <= 2) {
            by4 = 1;
        }
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID(), 1, by4, 0, 0);
        try {
            HostAddress hostAddress = this.networkMgr.getLocalAddress();
            MsgPong msgPong = new MsgPong(msgHeader2, hostAddress.getHostIP(), (short)hostAddress.getPort(), this.sharedFilesService.getFileCount(), this.sharedFilesService.getTotalFileSizeInKb());
            this.connectedHost.queueMessageToSend(msgPong);
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logError(unknownHostException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlePong(MsgPong msgPong) {
        Object object;
        if (NLogger.isDebugEnabled("INCOMING_MESSAGES")) {
            NLogger.debug("INCOMING_MESSAGES", "Received Pong: " + msgPong.getDebugString() + " - " + msgPong.getHeader().getDebugString());
        }
        MessageCountStatistic.pongMsgInCounter.increment(1);
        HorizonTracker.getInstance().trackPong(msgPong);
        MsgHeader msgHeader = msgPong.getHeader();
        byte[] byArray = msgPong.getIP();
        byte by = this.securityManager.controlHostIPAccess(byArray);
        if (by == 3) {
            this.dropMessage(msgPong, "IP access strongly denied.");
            return;
        }
        if (by == 1) {
            this.hostMgr.getCaughtHostsContainer().addCaughtHost(msgPong);
        }
        int n = msgPong.getPort();
        byte by2 = msgPong.getHeader().getHopsTaken();
        try {
            byte[] byArray2;
            if (by2 == 1 && Arrays.equals(byArray2 = ((HostAddress)(object = this.connectedHost.getHostAddress())).getHostIP(), byArray)) {
                this.connectedHost.setFileCount(msgPong.getFileCount());
                this.connectedHost.setTotalFileSize(msgPong.getFileSizeInKB());
                int n2 = ((HostAddress)object).getPort();
                if (n2 == n) {
                    // empty if block
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        object = this.messageMgr.getPingRouting(msgHeader.getMsgID());
        if (object == null || object == Host.LOCAL_HOST) {
            return;
        }
        if (msgPong.getHeader().getTTL() > 0) {
            ((Host)object).queueMessageToSend(msgPong);
        }
    }

    private void handleQuery(MsgQuery msgQuery) throws UnknownHostException {
        MessageCountStatistic.queryMsgInCounter.increment(1);
        MsgHeader msgHeader = msgQuery.getHeader();
        if (!this.messageMgr.checkAndAddToQueryRoutingTable(msgHeader.getMsgID(), this.connectedHost)) {
            this.dropMessage(msgQuery, "Dropping already seen query");
            return;
        }
        if (this.connectedHost.isUltrapeerLeafConnection() && msgHeader.getHopsTaken() > 2) {
            this.dropMessage(msgQuery, "Dropping Query from Leaf with hops > 2.");
        }
        this.queryHistory.addSearchQuery(msgQuery);
        this.messageMgr.forwardQuery(msgQuery, this.connectedHost);
        ShareFile[] shareFileArray = this.shareMgr.handleQuery(msgQuery);
        if (shareFileArray.length == 0) {
            return;
        }
        this.replyToQuery(msgHeader, shareFileArray);
    }

    private void replyToQuery(MsgHeader msgHeader, ShareFile[] shareFileArray) throws UnknownHostException {
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID(), -127, (byte)(msgHeader.getHopsTaken() + 1), 0, 0);
        int n = shareFileArray.length;
        if (n > 255) {
            n = 255;
        }
        ShareFile shareFile = null;
        QueryResponseRecord[] queryResponseRecordArray = new QueryResponseRecord[n];
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord;
            shareFile = shareFileArray[i];
            queryResponseRecordArray[i] = queryResponseRecord = new QueryResponseRecord(shareFile.getFileIndex(), shareFile.getURN(), (int)shareFile.getFileSize(), shareFile.getFileName());
        }
        HostAddress hostAddress = this.networkMgr.getLocalAddress();
        MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader2, ServiceManager.sCfg.mProgramClientID, hostAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L), queryResponseRecordArray);
        this.connectedHost.queueMessageToSend(msgQueryResponse);
    }

    private void handleQueryResponse(MsgQueryResponse msgQueryResponse) {
        MessageCountStatistic.queryHitMsgInCounter.increment(1);
        byte[] byArray = msgQueryResponse.getHostIP();
        byte by = this.securityManager.controlHostIPAccess(byArray);
        if (by == 3) {
            this.dropMessage(msgQueryResponse, "IP access strongly denied.");
            return;
        }
        if (by == 1) {
            this.messageMgr.processQueryResponse(this.connectedHost, msgQueryResponse);
        }
        this.messageMgr.addToPushRoutingTable(msgQueryResponse.getRemoteClientID(), this.connectedHost);
        MsgHeader msgHeader = msgQueryResponse.getHeader();
        QueryGUIDRoutingPair queryGUIDRoutingPair = this.messageMgr.getQueryRouting(msgHeader.getMsgID(), msgQueryResponse.getRecordCount());
        if (queryGUIDRoutingPair == null) {
            return;
        }
        Host host = queryGUIDRoutingPair.getHost();
        if (msgHeader.getTTL() > 0 && host != Host.LOCAL_HOST && queryGUIDRoutingPair.getRoutedResultCount() < 200) {
            host.queueMessageToSend(msgQueryResponse);
        }
    }

    private void handleRouteTableUpdate(RouteTableUpdateMsg routeTableUpdateMsg) {
        MessageCountStatistic.totalInMsgCounter.increment(1);
        if (!this.connectedHost.isQueryRoutingSupported() && !this.connectedHost.isUPQueryRoutingSupported()) {
            this.dropMessage(routeTableUpdateMsg, "QRP not supported from host.");
            return;
        }
        QueryRoutingTable queryRoutingTable = this.connectedHost.getLastReceivedRoutingTable();
        if (queryRoutingTable == null) {
            queryRoutingTable = new QueryRoutingTable();
            this.connectedHost.setLastReceivedRoutingTable(queryRoutingTable);
        }
        try {
            queryRoutingTable.updateRouteTable(routeTableUpdateMsg);
            if (this.connectedHost.isUltrapeerLeafConnection()) {
                this.messageMgr.updateLocalQueryRoutingTable();
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.dropMessage(routeTableUpdateMsg, "Invalid QRT update message.");
        }
    }

    private void handlePushRequest(MsgPushRequest msgPushRequest) throws UnknownHostException {
        MessageCountStatistic.pushMsgInCounter.increment(1);
        byte by = this.securityManager.controlHostAddressAccess(msgPushRequest.getRequestAddress());
        if (by == 3) {
            this.dropMessage(msgPushRequest, "IP access strongly denied.");
            return;
        }
        if (ServiceManager.sCfg.mProgramClientID.equals(msgPushRequest.getClientGUID())) {
            if (by == 1) {
                new PushWorker(msgPushRequest);
            }
            return;
        }
        Host host = this.messageMgr.getPushRouting(msgPushRequest.getClientGUID());
        if (host == null) {
            return;
        }
        if (msgPushRequest.getHeader().getTTL() > 0) {
            host.queueMessageToSend(msgPushRequest);
        }
    }

    private void handleVendorMessage(VendorMsg vendorMsg) {
        if (NLogger.isDebugEnabled("INCOMING_MESSAGES")) {
            NLogger.debug("INCOMING_MESSAGES", "Received VendorMsg: " + vendorMsg.toString() + " - " + vendorMsg.getHeader().getDebugString());
        }
        if (vendorMsg instanceof MessagesSupportedVMsg) {
            this.handleMessagesSupportedVMsg((MessagesSupportedVMsg)vendorMsg);
        } else if (vendorMsg instanceof TCPConnectBackVMsg) {
            this.handleTCPConnectBackVMsg((TCPConnectBackVMsg)vendorMsg);
        } else if (vendorMsg instanceof PushProxyRequestVMsg) {
            this.handlePushProxyRequestVMsg((PushProxyRequestVMsg)vendorMsg);
        } else if (vendorMsg instanceof PushProxyAcknowledgementVMsg) {
            this.handlePushProxyAcknowledgementVMsg((PushProxyAcknowledgementVMsg)vendorMsg);
        }
    }

    private void handleMessagesSupportedVMsg(MessagesSupportedVMsg messagesSupportedVMsg) {
        this.connectedHost.setSupportedVMsgs(messagesSupportedVMsg);
        boolean bl = this.networkMgr.hasConnectedIncoming();
        if ((this.connectedHost.isLeafUltrapeerConnection() || bl && this.connectedHost.isUltrapeer()) && this.connectedHost.isPushProxySupported()) {
            PushProxyRequestVMsg pushProxyRequestVMsg = new PushProxyRequestVMsg();
            this.connectedHost.queueMessageToSend(pushProxyRequestVMsg);
        }
    }

    private void handleTCPConnectBackVMsg(TCPConnectBackVMsg tCPConnectBackVMsg) {
        final int n = tCPConnectBackVMsg.getPort();
        final HostAddress hostAddress = this.connectedHost.getHostAddress();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                Object var2_2 = null;
                try {
                    connection = ConnectionFactory.createConnection(hostAddress.getHostName(), n, 2000);
                    connection.write("\n\n".getBytes());
                    connection.flush();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    Logger.logError(exception);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        };
        ThreadPool.getInstance().addJob(runnable, "TCPConnectBackJob");
    }

    private void handlePushProxyRequestVMsg(PushProxyRequestVMsg pushProxyRequestVMsg) {
        if (this.connectedHost.isUltrapeerLeafConnection()) {
            HostAddress hostAddress = this.networkMgr.getLocalAddress();
            GUID gUID = pushProxyRequestVMsg.getHeader().getMsgID();
            PushProxyAcknowledgementVMsg pushProxyAcknowledgementVMsg = new PushProxyAcknowledgementVMsg(hostAddress, gUID);
            this.connectedHost.queueMessageToSend(pushProxyAcknowledgementVMsg);
            this.messageMgr.addToPushRoutingTable(gUID, this.connectedHost);
        }
    }

    private void handlePushProxyAcknowledgementVMsg(PushProxyAcknowledgementVMsg pushProxyAcknowledgementVMsg) {
        if (ServiceManager.sCfg.mProgramClientID.equals(pushProxyAcknowledgementVMsg.getHeader().getMsgID())) {
            this.connectedHost.setPushProxyAddress(pushProxyAcknowledgementVMsg.getHostAddress());
        }
    }

    private void dropMessage(MsgHeader msgHeader, byte[] byArray, String string) {
        Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Dropping message: " + string));
        if (Logger.isLevelLogged(Logger.FINEST)) {
            Logger.logMessage(Logger.FINEST, (short)16, this.connectedHost, (Object)("Header: " + msgHeader.getDebugString() + " Body: " + " (" + HexConverter.toHexString(byArray, 0, msgHeader.getDataLen()) + ")."));
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private void dropMessage(Message message, String string) {
        if (Logger.isLevelLogged(Logger.FINEST)) {
            Logger.logMessage(Logger.FINEST, (short)16, this.connectedHost, (Object)("Dropping message: " + string + " Header: [" + message.getHeader().getDebugString() + "] - Message: [" + message.toDebugString() + "]."));
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private MsgHeader readHeader() throws IOException {
        MsgHeader msgHeader = MessageProcessor.parseMessageHeader(this.connection, this.headerBuffer);
        if (msgHeader == null) {
            throw new ConnectionClosedException("Connection closed by remote host");
        }
        int n = msgHeader.getDataLen();
        if (n < 0) {
            throw new IOException("Negative body size. Disconnecting the remote host.");
        }
        if (n > ServiceManager.sCfg.maxMessageLength) {
            if (Logger.isLevelLogged(Logger.WARNING)) {
                byte[] byArray = MessageProcessor.readMessageBody(this.connection, 262144);
                String string = HexConverter.toHexString(byArray);
                Logger.logMessage(Logger.WARNING, (short)16, this.connectedHost, (Object)("Body too big. Header: " + msgHeader + "\nBody(256KB): " + string));
            }
            throw new IOException("Packet too big. Disconnecting the remote host.");
        }
        msgHeader.setArrivalTime(System.currentTimeMillis());
        msgHeader.setFromHost(this.connectedHost);
        return msgHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeOutgoingConnection() throws IOException {
        this.connectedHost.setStatus(2);
        this.connection = ConnectionFactory.createConnection(this.connectedHost.getHostAddress());
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        onlineObserver.markSuccessfulConnection();
        this.connectedHost.setConnection(this.connection);
        try {
            this.initializeOutgoingWith06();
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addConnectedHost(this.connectedHost);
        this.messageMgr.pingHost(this.connectedHost, (byte)ServiceManager.sCfg.ttl);
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg messagesSupportedVMsg = MessagesSupportedVMsg.getMyMsgSupported();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", "Queueing MessagesSupportedVMsg: " + messagesSupportedVMsg.toString() + " - " + messagesSupportedVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString());
            }
            this.connectedHost.queueMessageToSend(messagesSupportedVMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeIncomingConnection(String string) throws IOException {
        int n = string.lastIndexOf(47) + 1;
        String string2 = string.substring(n, string.length());
        try {
            if (string2.equals("0.4")) {
                this.initializeIncomingWith04();
            } else if (this.is06orHigher(string2)) {
                this.initializeIncomingWith06();
            }
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addIncomingHost(this.connectedHost);
        this.messageMgr.pingHost(this.connectedHost, (byte)ServiceManager.sCfg.ttl);
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg messagesSupportedVMsg = MessagesSupportedVMsg.getMyMsgSupported();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", "Queueing MessagesSupportedVMsg: " + messagesSupportedVMsg.toString() + " - " + messagesSupportedVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString());
            }
            this.connectedHost.queueMessageToSend(messagesSupportedVMsg);
        }
    }

    private void initializeIncomingWith04() throws IOException {
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus handshakeStatus = handshakeHandler.createHandshakeResponse(new HandshakeStatus(200, "OK"), false);
        if (handshakeStatus.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
        }
        this.sendStringToHost("GNUTELLA OK\n\n");
        this.headersRead = HTTPHeaderGroup.EMPTY_HEADERGROUP;
        this.headersSend = HTTPHeaderGroup.EMPTY_HEADERGROUP;
    }

    private void initializeIncomingWith06() throws IOException {
        this.headersRead = HTTPProcessor.parseHTTPHeaders(this.connection);
        if (Logger.isLevelLogged(Logger.FINER)) {
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Connect headers: " + this.headersRead.buildHTTPHeaderString()));
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus handshakeStatus = handshakeHandler.createHandshakeResponse(new HandshakeStatus(this.headersRead), false);
        this.headersSend = handshakeStatus.getResponseHeaders();
        this.sendStringToHost("GNUTELLA/0.6 " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage() + "\r\n");
        String string = handshakeStatus.getResponseHeaders().buildHTTPHeaderString();
        this.sendStringToHost(string);
        this.sendStringToHost("\r\n");
        if (handshakeStatus.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
        }
        HandshakeStatus handshakeStatus2 = HandshakeStatus.parseHandshakeResponse(this.connection);
        if (Logger.isLevelLogged(Logger.FINER)) {
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Response Code: '" + handshakeStatus2.getStatusCode() + "'."));
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Response Message: '" + handshakeStatus2.getStatusMessage() + "'."));
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Response Headers: " + handshakeStatus2.getResponseHeaders().buildHTTPHeaderString()));
        }
        if (handshakeStatus2.getStatusCode() != 200) {
            throw new IOException("Host rejected connection: " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage());
        }
        this.headersRead.replaceHeaders(handshakeStatus2.getResponseHeaders());
    }

    private void initializeOutgoingWith06() throws IOException {
        this.connectedHost.setStatus(2, Localizer.getString("Negotiate0_6Handshake"));
        String string = this.networkMgr.getGnutellaNetwork().getNetworkGreeting();
        String string2 = string + '/' + "0.6" + "\r\n";
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string2);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HTTPHeaderGroup hTTPHeaderGroup = handshakeHandler.createOutgoingHandshakeHeaders();
        stringBuffer.append(hTTPHeaderGroup.buildHTTPHeaderString());
        stringBuffer.append("\r\n");
        this.headersSend = hTTPHeaderGroup;
        String string3 = stringBuffer.toString();
        this.sendStringToHost(string3);
        HandshakeStatus handshakeStatus = HandshakeStatus.parseHandshakeResponse(this.connection);
        this.headersRead = handshakeStatus.getResponseHeaders();
        if (Logger.isLevelLogged(Logger.FINER)) {
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Response Code: '" + handshakeStatus.getStatusCode() + "'."));
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Response Message: '" + handshakeStatus.getStatusMessage() + "'."));
            Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Response Headers: " + this.headersRead.buildHTTPHeaderString()));
        }
        if (handshakeStatus.getStatusCode() != 200) {
            if (handshakeStatus.getStatusCode() == 503) {
                throw new ConnectionRejectedException(handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
            }
            throw new ConnectionRejectedException("Gnutella 0.6 connection rejected. Status: " + handshakeStatus.getStatusCode() + " - " + handshakeStatus.getStatusMessage());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeStatus handshakeStatus2 = handshakeHandler.createHandshakeResponse(handshakeStatus, true);
        HTTPHeaderGroup hTTPHeaderGroup2 = handshakeStatus2.getResponseHeaders();
        this.headersSend.replaceHeaders(hTTPHeaderGroup2);
        this.sendStringToHost("GNUTELLA/0.6 " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage() + "\r\n");
        String string4 = hTTPHeaderGroup2.buildHTTPHeaderString();
        this.sendStringToHost(string4);
        this.sendStringToHost("\r\n");
        if (handshakeStatus2.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage());
        }
    }

    private void configureConnectionType(HTTPHeaderGroup hTTPHeaderGroup, HTTPHeaderGroup hTTPHeaderGroup2) {
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer");
        HTTPHeader hTTPHeader2 = hTTPHeaderGroup2.getHeader("X-Ultrapeer");
        if (hTTPHeader == null || hTTPHeader2 == null) {
            this.connectedHost.setConnectionType((byte)0);
        } else if (hTTPHeader.booleanValue()) {
            if (hTTPHeader2.booleanValue()) {
                this.connectedHost.setConnectionType((byte)2);
            } else {
                this.connectedHost.setConnectionType((byte)3);
            }
        } else if (hTTPHeader2.booleanValue()) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
        }
    }

    private void handleXTryHeaders(HTTPHeaderGroup hTTPHeaderGroup) {
        HTTPHeader[] hTTPHeaderArray = hTTPHeaderGroup.getHeaders("X-Try");
        if (hTTPHeaderArray != null) {
            this.handleXTryHosts(hTTPHeaderArray, true);
        }
        if ((hTTPHeaderArray = hTTPHeaderGroup.getHeaders("X-Try-Ultrapeers")) != null) {
            this.handleXTryHosts(hTTPHeaderArray, false);
        }
    }

    private void handleXTryHosts(HTTPHeader[] hTTPHeaderArray, boolean bl) {
        short s = bl ? (short)2 : 1;
        CaughtHostsContainer caughtHostsContainer = this.hostMgr.getCaughtHostsContainer();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeaderArray[i].getValue(), ",");
            block4: while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                byte[] byArray = HostAddress.parseIP(string);
                if (byArray == null) continue;
                byte by = this.securityManager.controlHostIPAccess(byArray);
                switch (by) {
                    case 2: 
                    case 3: {
                        continue block4;
                    }
                }
                int n = HostAddress.parsePort(string);
                if (n == -1) {
                    n = 6346;
                }
                HostAddress hostAddress = new HostAddress(byArray, n);
                if (!bl && hostAddress.isPrivateIP()) {
                    s = 0;
                }
                caughtHostsContainer.addCaughtHost(hostAddress, s);
            }
        }
    }

    private void configureRemoteHost(HTTPHeaderGroup hTTPHeaderGroup) {
        Object object;
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("User-Agent");
        if (hTTPHeader != null) {
            this.connectedHost.setVendor(hTTPHeader.getValue());
        }
        if (this.connectedHost.isIncomming()) {
            hTTPHeader = hTTPHeaderGroup.getHeader("Listen-IP");
            if (hTTPHeader == null) {
                hTTPHeader = hTTPHeaderGroup.getHeader("X-My-Address");
            }
            if (hTTPHeader != null) {
                object = this.connectedHost.getHostAddress();
                int n = HostAddress.parsePort(hTTPHeader.getValue());
                if (n > 0) {
                    ((HostAddress)object).updateAddress(((HostAddress)object).getHostName(), n);
                }
            }
        }
        try {
            HostAddress hostAddress;
            hTTPHeader = hTTPHeaderGroup.getHeader("Remote-IP");
            if (hTTPHeader != null && (object = HostAddress.parseIP(hTTPHeader.getValue())) != null && !Arrays.equals((byte[])object, (hostAddress = this.networkMgr.getLocalAddress()).getHostIP())) {
                this.networkMgr.updateLocalAddress((byte[])object);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hTTPHeader = hTTPHeaderGroup.getHeader("X-Query-Routing");
        if (hTTPHeader != null) {
            try {
                float f = Float.parseFloat(hTTPHeader.getValue());
                if (f >= 0.1f) {
                    this.connectedHost.setQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer-Query-Routing")) != null) {
            try {
                float f = Float.parseFloat(hTTPHeader.getValue());
                if (f >= 0.1f) {
                    this.connectedHost.setUPQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((hTTPHeader = hTTPHeaderGroup.getHeader("X-Dynamic-Querying")) != null) {
            try {
                float f = hTTPHeader.floatValue();
                if (f >= 0.1f) {
                    this.connectedHost.setDynamicQuerySupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        byte by = hTTPHeaderGroup.getByteHeaderValue("X-Max-TTL", (byte)4);
        this.connectedHost.setMaxTTL(by);
        int n = hTTPHeaderGroup.getIntHeaderValue("X-Degree", 6);
        this.connectedHost.setUltrapeerDegree(n);
    }

    private void postHandshakeConfiguration(HTTPHeaderGroup hTTPHeaderGroup, HTTPHeaderGroup hTTPHeaderGroup2) throws IOException {
        HTTPHeader hTTPHeader;
        if (hTTPHeaderGroup.isHeaderValueContaining("Accept-Encoding", "deflate") && hTTPHeaderGroup2.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateInputInflation();
        }
        if (hTTPHeaderGroup2.isHeaderValueContaining("Accept-Encoding", "deflate") && hTTPHeaderGroup.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateOutputDeflation();
        }
        if ((hTTPHeader = hTTPHeaderGroup2.getHeader("Vendor-Message")) != null && !hTTPHeader.getValue().equals("")) {
            this.connectedHost.setVendorMessageSupported(true);
        }
    }

    private boolean is06orHigher(String string) {
        int n = VersionUtils.compare(string, "0.6");
        return n >= 0;
    }

    private void sendStringToHost(String string) throws IOException {
        Logger.logMessage(Logger.FINER, (short)16, this.connectedHost, (Object)("Send: " + string));
        byte[] byArray = string.getBytes();
        this.connection.write(byArray, 0, byArray.length);
        this.connection.flush();
    }
}

