/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.util.ArrayList;
import phex.common.ThreadTracking;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.utils.Localizer;
import phex.utils.Logger;

public class ConnectionObserver
implements Runnable {
    private long SLEEP_TIME = 30000L;
    private long PING_WAIT_TIME = 20000L;
    private MsgManager messageMgr;
    private ArrayList snapshootList;
    private ArrayList quiteList;
    private NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();

    public ConnectionObserver() {
        this.messageMgr = MsgManager.getInstance();
    }

    public void start() {
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "ConnectionObserver-" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.snapshootList = new ArrayList<E>();
        this.quiteList = new ArrayList<E>();
        block4: while (true) {
            this.snapshootList.clear();
            this.quiteList.clear();
            var1_1 = this.networkHostsContainer.getUltrapeerConnections();
            this.createSnapshoots(var1_1);
            var1_1 = this.networkHostsContainer.getLeafConnections();
            this.createSnapshoots(var1_1);
            var1_1 = this.networkHostsContainer.getPeerConnections();
            this.createSnapshoots(var1_1);
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
            var1_1 = this.networkHostsContainer.getUltrapeerConnections();
            this.findQuiteHosts(var1_1);
            var1_1 = this.networkHostsContainer.getLeafConnections();
            this.findQuiteHosts(var1_1);
            var1_1 = this.networkHostsContainer.getPeerConnections();
            this.findQuiteHosts(var1_1);
            if (this.quiteList.size() <= 0) continue;
            var2_3 = this.quiteList.size();
            for (var3_4 = 0; var3_4 < var2_3; ++var3_4) {
                var4_7 = (Host)this.quiteList.get(var3_4);
                Logger.logMessage(Logger.FINEST, (short)16, var4_7, (Object)"Sending keep alive ping.");
                this.messageMgr.pingHost(var4_7);
            }
            try {
                Thread.sleep(this.PING_WAIT_TIME);
            }
            catch (InterruptedException var3_5) {
                // empty catch block
            }
            var3_4 = 0;
            while (true) {
                if (var3_4 < var2_3) ** break;
                continue block4;
                var4_7 = (Host)this.quiteList.get(var3_4);
                var5_8 = this.findSnapshoot(var4_7);
                if (var5_8.hasBeenQuite(var4_7)) {
                    var4_7.setStatus(1, Localizer.getString("HostNotResponding"));
                    Logger.logMessage(Logger.FINEST, (short)16, var4_7, (Object)"Host not responding, disconnecting..");
                    this.networkHostsContainer.disconnectHost(var4_7);
                }
                ++var3_4;
            }
            break;
        }
    }

    private void findQuiteHosts(Host[] hostArray) {
        for (int i = 0; i < hostArray.length; ++i) {
            ConnectionSnapshoot connectionSnapshoot = this.findSnapshoot(hostArray[i]);
            if (connectionSnapshoot == null || !connectionSnapshoot.hasBeenQuite(hostArray[i])) continue;
            this.quiteList.add(hostArray[i]);
        }
    }

    private void createSnapshoots(Host[] hostArray) {
        for (int i = 0; i < hostArray.length; ++i) {
            this.snapshootList.add(new ConnectionSnapshoot(hostArray[i]));
        }
    }

    private ConnectionSnapshoot findSnapshoot(Host host) {
        int n = this.snapshootList.size();
        for (int i = 0; i < n; ++i) {
            ConnectionSnapshoot connectionSnapshoot = (ConnectionSnapshoot)this.snapshootList.get(i);
            if (connectionSnapshoot.host != host) continue;
            return connectionSnapshoot;
        }
        return null;
    }

    private class ConnectionSnapshoot {
        Host host;
        int receivedCount;
        int sentCount;
        int sendDropCount;

        ConnectionSnapshoot(Host host) {
            this.host = host;
            this.receivedCount = host.getReceivedCount();
            this.sentCount = host.getSentCount();
            this.sendDropCount = host.getSendDropCount();
        }

        public boolean hasBeenQuite(Host host) {
            int n = host.getReceivedCount() - this.receivedCount;
            int n2 = host.getSentCount() - this.sentCount;
            int n3 = host.getSendDropCount() - this.sendDropCount;
            if (n == 0 || host.getFileCount() == -1L) {
                return true;
            }
            return n2 == n3 && n2 != 0;
        }
    }
}

