/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.NetworkManager;
import phex.download.PushHandler;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.msg.GUID;
import phex.net.connection.Connection;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.URLCodecUtils;

public class IncomingConnectionDispatcher
implements Runnable {
    public static final String GET_REQUEST_PREFIX = "GET ";
    public static final String GIV_REQUEST_PREFIX = "GIV ";
    public static final String CHAT_REQUEST_PREFIX = "CHAT ";
    public static final String URI_DOWNLOAD_PREFIX = "PHEX_URI ";
    public static final String MAGMA_DOWNLOAD_PREFIX = "PHEX_MAGMA ";
    private final Socket socket;

    public IncomingConnectionDispatcher(Socket socket) {
        this.socket = socket;
    }

    public void run() {
        block14: {
            GnutellaInputStream gnutellaInputStream = null;
            try {
                NetworkManager networkManager = NetworkManager.getInstance();
                if (!networkManager.isNetworkJoined() && !this.socket.getInetAddress().isLoopbackAddress()) {
                    throw new IOException("Network not joined.");
                }
                this.socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
                BandwidthController bandwidthController = BandwidthManager.getInstance().getNetworkBandwidthController();
                Connection connection = new Connection(this.socket, bandwidthController);
                String string = connection.readLine();
                if (string == null) {
                    throw new IOException("Disconnected from remote host during handshake");
                }
                Logger.logMessage(Logger.FINE, (short)16, "ConnectionRequest " + string);
                String string2 = networkManager.getGnutellaNetwork().getNetworkGreeting();
                if (string.startsWith(string2 + "/")) {
                    HostAddress hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                    Host host = new Host(hostAddress, connection);
                    host.setType(Host.TYPE_INCOMING);
                    host.setStatus(3, "");
                    HostManager.getInstance().acceptIncomingConnection(host, string);
                    break block14;
                }
                if (string.startsWith(GET_REQUEST_PREFIX)) {
                    HTTPRequest hTTPRequest = HTTPProcessor.parseHTTPRequest(string);
                    HTTPProcessor.parseHTTPHeaders(hTTPRequest, connection);
                    Logger.logMessage(Logger.FINEST, (short)255, "GET Request: " + hTTPRequest.buildHTTPRequestString());
                    if (hTTPRequest.isGnutellaRequest()) {
                        UploadManager.getInstance().handleUploadRequest(connection, hTTPRequest);
                    } else {
                        ShareManager.getInstance().httpRequestHandler(connection, hTTPRequest);
                    }
                    break block14;
                }
                if (string.startsWith(GIV_REQUEST_PREFIX)) {
                    this.handleIncommingGIV(string);
                    break block14;
                }
                if (string.startsWith(CHAT_REQUEST_PREFIX)) {
                    HostAddress hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                    Logger.logMessage(Logger.FINE, (short)16, "Chat request from: " + hostAddress.getFullHostName());
                    gnutellaInputStream = connection.getInputStream();
                    ChatManager.getInstance().acceptChat(this.socket, gnutellaInputStream, hostAddress);
                    break block14;
                }
                if (string.startsWith(URI_DOWNLOAD_PREFIX)) {
                    this.handleIncommingUriDownload(string);
                    break block14;
                }
                if (string.startsWith(MAGMA_DOWNLOAD_PREFIX)) {
                    this.handleIncommingMagmaDownload(string);
                    break block14;
                }
                throw new IOException("Unknown connection request: " + string);
            }
            catch (HTTPMessageException hTTPMessageException) {
                Logger.logMessage(Logger.FINE, (short)16, hTTPMessageException);
                IOUtil.closeQuietly(gnutellaInputStream);
                IOUtil.closeQuietly(this.socket);
            }
            catch (IOException iOException) {
                Logger.logMessage(Logger.FINE, (short)16, iOException);
                IOUtil.closeQuietly(gnutellaInputStream);
                IOUtil.closeQuietly(this.socket);
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingUriDownload(String string) throws IOException {
        Object object;
        try {
            if (!this.socket.getInetAddress().isLoopbackAddress()) {
                return;
            }
            object = this.socket.getOutputStream();
            ((OutputStream)object).write("OK".getBytes());
            ((OutputStream)object).flush();
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        object = string.substring(4);
        NetworkManager.getInstance().fireIncomingUriDownload((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingMagmaDownload(String string) throws IOException {
        Object object;
        try {
            if (!this.socket.getInetAddress().isLoopbackAddress()) {
                return;
            }
            object = this.socket.getOutputStream();
            ((OutputStream)object).write("OK".getBytes());
            ((OutputStream)object).flush();
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        object = string.substring(4);
        NetworkManager.getInstance().fireIncomingMagmaDownload((String)object);
    }

    private void handleIncommingGIV(String string) throws IOException {
        String string2 = string.substring(4);
        try {
            int n = string2.indexOf(58);
            string2.substring(0, n);
            int n2 = string2.indexOf(47, n);
            String string3 = string2.substring(n + 1, n2);
            String string4 = string2.substring(n2 + 1);
            string4 = URLCodecUtils.decodeURL(string4);
            GUID gUID = new GUID(string3);
            PushHandler.handleIncommingGIV(this.socket, gUID, string4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.logError((short)16, "Failed to parse GIV: " + string);
            Logger.logError(indexOutOfBoundsException);
        }
    }
}

