/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.OnlineObserver;
import phex.utils.NLogger;

public class OutgoingConnectionDispatcher
implements Runnable {
    public HostAddress hostAddress;

    public void setHostAddressToConnect(HostAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    public void run() {
        if (this.hostAddress == null) {
            this.connectToNextCaughtHost();
        } else {
            this.connectToHostAddress();
        }
    }

    private void connectToHostAddress() {
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        Host host = new Host(this.hostAddress);
        host.setType(Host.TYPE_OUTGOING);
        networkHostsContainer.addNetworkHost(host);
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        try {
            ConnectionEngine connectionEngine = new ConnectionEngine(host);
            connectionEngine.initializeOutgoingConnection();
            connectionEngine.processIncomingData();
        }
        catch (IOException iOException) {
            onlineObserver.markFailedConnection();
            host.setStatus(1, iOException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", iOException);
        }
        catch (Exception exception) {
            host.setStatus(1, exception.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", exception, exception);
        }
    }

    private void connectToNextCaughtHost() {
        HostAddress hostAddress;
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        CaughtHostsContainer caughtHostsContainer = HostManager.getInstance().getCaughtHostsContainer();
        do {
            if ((hostAddress = caughtHostsContainer.getNextCaughtHost()) != null) continue;
            return;
        } while (networkHostsContainer.isConnectedToHost(hostAddress));
        Host host = new Host(hostAddress);
        host.setType(Host.TYPE_OUTGOING);
        networkHostsContainer.addNetworkHost(host);
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        try {
            ConnectionEngine connectionEngine = new ConnectionEngine(host);
            connectionEngine.initializeOutgoingConnection();
            connectionEngine.processIncomingData();
            caughtHostsContainer.reportConnectionStatus(hostAddress, true);
        }
        catch (ConnectionRejectedException connectionRejectedException) {
            caughtHostsContainer.reportConnectionStatus(hostAddress, true);
            host.setStatus(1, connectionRejectedException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", connectionRejectedException);
        }
        catch (IOException iOException) {
            onlineObserver.markFailedConnection();
            caughtHostsContainer.reportConnectionStatus(hostAddress, false);
            host.setStatus(1, iOException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", iOException);
        }
        catch (Exception exception) {
            caughtHostsContainer.reportConnectionStatus(hostAddress, false);
            host.setStatus(1, exception.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", exception, exception);
        }
    }
}

