/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import java.net.UnknownHostException;
import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeStatus;
import phex.connection.handshake.LeafHandshakeHandler;
import phex.connection.handshake.PeerHandshakeHandler;
import phex.connection.handshake.UltrapeerHandshakeHandler;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public abstract class HandshakeHandler
implements ConnectionConstants {
    protected Host connectedHost;

    public HandshakeHandler(Host host) {
        this.connectedHost = host;
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(HTTPHeaderGroup.ACCEPT_HANDSHAKE_GROUP);
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        hTTPHeaderGroup.addHeader(new HTTPHeader("Listen-IP", hostAddress.getFullHostName()));
        try {
            hTTPHeaderGroup.addHeader(new HTTPHeader("Remote-IP", this.connectedHost.getHostAddress().getFullIpHostName()));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (ServiceManager.sCfg.isDeflateConnectionAccepted) {
            hTTPHeaderGroup.addHeader(new HTTPHeader("Accept-Encoding", "deflate"));
        }
        return hTTPHeaderGroup;
    }

    public HTTPHeaderGroup createOutgoingHandshakeHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = this.createDefaultHandshakeHeaders();
        return hTTPHeaderGroup;
    }

    protected HandshakeStatus createCrawlerHandshakeStatus() {
        String string;
        Host[] hostArray;
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        HostManager hostManager = HostManager.getInstance();
        NetworkHostsContainer networkHostsContainer = hostManager.getNetworkHostsContainer();
        boolean bl = hostManager.isUltrapeer();
        if (bl && (hostArray = networkHostsContainer.getLeafConnections()).length > 0) {
            string = this.buildHostAddressString(hostArray, hostArray.length);
            hTTPHeaderGroup.addHeader(new HTTPHeader("Leaves", string));
        }
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Ultrapeer", String.valueOf(bl)));
        hostArray = networkHostsContainer.getUltrapeerConnections();
        if (hostArray.length > 0) {
            string = this.buildHostAddressString(hostArray, hostArray.length);
            hTTPHeaderGroup.addHeader(new HTTPHeader("Peers", string));
        }
        return new HandshakeStatus(200, "OK", hTTPHeaderGroup);
    }

    protected HTTPHeaderGroup createRejectOutgoingHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        return hTTPHeaderGroup;
    }

    protected HTTPHeaderGroup createRejectIncomingHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        hTTPHeaderGroup.addHeader(new HTTPHeader("Remote-IP", this.connectedHost.getHostAddress().getFullHostName()));
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        Host[] hostArray = networkHostsContainer.getUltrapeerConnections();
        String string = this.buildHostAddressString(hostArray, hostArray.length);
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Try-Ultrapeers", string));
        return hTTPHeaderGroup;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus handshakeStatus, boolean bl) {
        if (bl) {
            HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
            if (handshakeStatus.isDeflateAccepted()) {
                hTTPHeaderGroup.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
            }
            return new HandshakeStatus(200, "OK", hTTPHeaderGroup);
        }
        if (HostManager.getInstance().getNetworkHostsContainer().hasPeerSlotsAvailable()) {
            HTTPHeaderGroup hTTPHeaderGroup = this.createDefaultHandshakeHeaders();
            if (handshakeStatus.isDeflateAccepted()) {
                hTTPHeaderGroup.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
            }
            return new HandshakeStatus(200, "OK", hTTPHeaderGroup);
        }
        return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
    }

    public static HandshakeHandler createHandshakeHandler(Host host) {
        if (HostManager.getInstance().isAbleToBecomeUltrapeer()) {
            return new UltrapeerHandshakeHandler(host);
        }
        if (ServiceManager.sCfg.allowToBecomeLeaf) {
            return new LeafHandshakeHandler(host);
        }
        return new PeerHandshakeHandler(host);
    }

    protected String buildHostAddressString(Host[] hostArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        n = Math.min(n, hostArray.length);
        for (int i = 0; i < hostArray.length; ++i) {
            HostAddress hostAddress = hostArray[i].getHostAddress();
            stringBuffer.append(hostAddress.getFullHostName());
            if (i >= hostArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    protected boolean isCrawlerConnection(HTTPHeaderGroup hTTPHeaderGroup) {
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("Crawler");
        if (hTTPHeader == null) {
            return false;
        }
        try {
            float f = hTTPHeader.floatValue();
            return f >= 0.1f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

