/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class UltrapeerHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostContainer = this.hostMgr.getNetworkHostsContainer();

    public UltrapeerHandshakeHandler(Host host) {
        super(host);
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = super.createDefaultHandshakeHeaders();
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Ultrapeer", "true"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Dynamic-Querying", "0.1"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Degree", String.valueOf(ServiceManager.sCfg.up2upConnections)));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Max-TTL", String.valueOf(4)));
        return hTTPHeaderGroup;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus handshakeStatus, boolean bl) {
        if (bl) {
            return this.createOutgoingResponse(handshakeStatus);
        }
        return this.createIncomingResponse(handshakeStatus);
    }

    private HandshakeStatus createIncomingResponse(HandshakeStatus handshakeStatus) {
        HTTPHeaderGroup hTTPHeaderGroup = handshakeStatus.getResponseHeaders();
        boolean bl = this.isCrawlerConnection(hTTPHeaderGroup);
        if (bl) {
            return this.createCrawlerHandshakeStatus();
        }
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer");
        if (!this.isConnectionAccepted(hTTPHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
        }
        HTTPHeaderGroup hTTPHeaderGroup2 = this.createDefaultHandshakeHeaders();
        if (hTTPHeader != null && Boolean.valueOf(hTTPHeader.getValue()).booleanValue()) {
            boolean bl2 = this.hostContainer.hasUltrapeerSlotsAvailable();
            String string = bl2 ? "true" : "false";
            hTTPHeaderGroup2.addHeader(new HTTPHeader("X-Ultrapeer-Needed", string));
        }
        if (handshakeStatus.isDeflateAccepted()) {
            hTTPHeaderGroup2.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", hTTPHeaderGroup2);
    }

    private HandshakeStatus createOutgoingResponse(HandshakeStatus handshakeStatus) {
        HTTPHeaderGroup hTTPHeaderGroup = handshakeStatus.getResponseHeaders();
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer");
        if (!this.isConnectionAccepted(hTTPHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectOutgoingHeaders());
        }
        HTTPHeaderGroup hTTPHeaderGroup2 = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        HTTPHeader hTTPHeader2 = hTTPHeaderGroup.getHeader("X-Ultrapeer-Needed");
        if (hTTPHeader2 != null && !hTTPHeader2.booleanValue() && !this.isBearshare(hTTPHeaderGroup) && this.hostMgr.isAbleToBecomeLeafNode()) {
            hTTPHeaderGroup2 = new HTTPHeaderGroup(false);
            hTTPHeaderGroup2.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
        }
        if (handshakeStatus.isDeflateAccepted()) {
            hTTPHeaderGroup2.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", hTTPHeaderGroup2);
    }

    private boolean isConnectionAccepted(HTTPHeader hTTPHeader) {
        if (hTTPHeader == null) {
            return this.hostContainer.hasPeerSlotsAvailable();
        }
        return Boolean.valueOf(hTTPHeader.getValue()) != false ? this.hostContainer.hasUltrapeerSlotsAvailable() || this.hostContainer.hasLeafSlotForUltrapeerAvailable() : this.hostContainer.hasLeafSlotsAvailable();
    }

    private boolean isBearshare(HTTPHeaderGroup hTTPHeaderGroup) {
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("User-Agent");
        return hTTPHeader != null && hTTPHeader.getValue().startsWith("BearShare");
    }
}

