/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import phex.common.AlternateLocation;
import phex.common.AlternateLocationContainer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.RangeUnavailableException;
import phex.download.RemotelyQueuedException;
import phex.download.WrongHTTPHeaderException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.host.UnusableHostException;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.HTTPRetryAfter;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.utils.BandwidthInputStream;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.LengthLimitedInputStream;
import phex.utils.NLogger;

public class DownloadEngine {
    private static final int BUFFER_LENGTH = 16384;
    private SWDownloadCandidate candidate;
    private SWDownloadSegment segment;
    private SWDownloadFile downloadFile;
    private RandomAccessFile raFile;
    private Connection connection;
    private Socket socket;
    private GnutellaInputStream inStream;
    private boolean isKeepAliveSupported;
    private boolean isDownloadSuccessful;
    private ContentRange replyContentRange;
    private long replyContentLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DownloadEngine(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) {
        this.downloadFile = sWDownloadFile;
        this.candidate = sWDownloadCandidate;
    }

    public DownloadEngine(Socket socket, SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) {
        this(sWDownloadFile, sWDownloadCandidate);
        this.socket = socket;
    }

    public void connect(int n) throws IOException {
        if (this.socket == null) {
            HostAddress hostAddress = this.candidate.getHostAddress();
            NLogger.debug("DOWNLOAD", "DownloadEngine - Connecting to " + hostAddress.getHostName() + ":" + hostAddress.getPort());
            try {
                this.socket = OIOSocketFactory.connect(hostAddress, n);
            }
            catch (SocketException socketException) {
                throw new ConnectionFailedException(socketException.getMessage());
            }
        }
        this.connection = new Connection(this.socket, BandwidthManager.getInstance().getDownloadBandwidthController());
        this.inStream = new GnutellaInputStream(new BandwidthInputStream(this.connection.getInputStream(), BandwidthManager.getInstance().getDownloadBandwidthController()));
        NLogger.debug("DOWNLOAD", "Download Engine @" + Integer.toHexString(this.hashCode()) + " connected successfully to " + this.socket.getRemoteSocketAddress() + ".");
    }

    public void exchangeHTTPHandshake(SWDownloadSegment sWDownloadSegment) throws IOException, UnusableHostException, HTTPMessageException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.isDownloadSuccessful = false;
        this.segment = sWDownloadSegment;
        long l = this.segment.getTransferStartPosition();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.connection.getOutputStream());
        String string = this.candidate.getDownloadRequestUrl();
        HTTPRequest hTTPRequest = new HTTPRequest("GET", string, true);
        hTTPRequest.addHeader(new HTTPHeader("Host", this.candidate.getHostAddress().getFullHostName()));
        hTTPRequest.addHeader(new HTTPHeader("Listen-IP", NetworkManager.getInstance().getLocalAddress().getFullHostName()));
        long l2 = this.segment.getEndOffset();
        if (l2 == -1L) {
            hTTPRequest.addHeader(new HTTPHeader("Range", "bytes=" + l + "-"));
        } else {
            hTTPRequest.addHeader(new HTTPHeader("Range", "bytes=" + l + "-" + (l2 - 1L)));
        }
        hTTPRequest.addHeader(new HTTPHeader("X-Queue", "0.1"));
        hTTPRequest.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        if (this.candidate.isG2Faked()) {
            hTTPRequest.addHeader(new HTTPHeader("X-Features", "g2/1.0"));
        }
        this.buildAltLocRequestHeader(hTTPRequest);
        if (ServiceManager.sCfg.isChatEnabled && !((HostAddress)(object4 = NetworkManager.getInstance().getLocalAddress())).isLocalHost() && !((HostAddress)object4).isPrivateIP()) {
            hTTPRequest.addHeader(new HTTPHeader("Chat", ((HostAddress)object4).getFullHostName()));
        }
        object4 = hTTPRequest.buildHTTPRequestString();
        NLogger.debug("DOWNLOAD", "HTTP Request to: " + this.candidate.getHostAddress() + "\n" + (String)object4);
        outputStreamWriter.write((String)object4);
        outputStreamWriter.flush();
        HTTPResponse hTTPResponse = HTTPProcessor.parseHTTPResponse(this.connection);
        NLogger.debug("DOWNLOAD", "HTTP Response from: " + this.candidate.getHostAddress() + "\n" + hTTPResponse.buildHTTPResponseString());
        HTTPHeader hTTPHeader = hTTPResponse.getHeader("Server");
        if (hTTPHeader != null) {
            this.candidate.setVendor(hTTPHeader.getValue());
        }
        this.replyContentRange = null;
        hTTPHeader = hTTPResponse.getHeader("Content-Range");
        if (hTTPHeader != null) {
            this.replyContentRange = this.parseContentRange(hTTPHeader.getValue());
            if (this.replyContentRange.startPos != l) {
                throw new IOException("Invalid 'CONTENT-RANGE' start offset.");
            }
        }
        this.replyContentLength = -1L;
        hTTPHeader = hTTPResponse.getHeader("Content-Length");
        if (hTTPHeader != null) {
            try {
                this.replyContentLength = hTTPHeader.longValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        URN uRN = this.downloadFile.getFileURN();
        ArrayList<HTTPHeader> arrayList = new ArrayList<HTTPHeader>();
        hTTPHeader = hTTPResponse.getHeader("X-Gnutella-Content-URN");
        if (hTTPHeader != null) {
            arrayList.add(hTTPHeader);
        }
        Object[] objectArray = hTTPResponse.getHeaders("X-Content-URN");
        CollectionUtils.addAll(arrayList, objectArray);
        if (uRN != null) {
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                hTTPHeader = (HTTPHeader)object3.next();
                object2 = hTTPHeader.getValue();
                if (!URN.isValidURN((String)object2) || uRN.equals((URN)(object = new URN((String)object2)))) continue;
                throw new IOException("Required URN and content URN do not match.");
            }
        }
        if ((hTTPHeader = hTTPResponse.getHeader("Chat")) != null) {
            this.candidate.setChatSupported(true);
        }
        if ((hTTPHeader = hTTPResponse.getHeader("Remote-IP")) != null && (object3 = (Object)HostAddress.parseIP(hTTPHeader.getValue())) != null && !Arrays.equals(object3, ((HostAddress)(object2 = NetworkManager.getInstance().getLocalAddress())).getHostIP())) {
            NetworkManager.getInstance().updateLocalAddress((byte[])object3);
        }
        if ((hTTPHeader = hTTPResponse.getHeader("X-Available-Ranges")) != null) {
            object3 = HTTPRangeSet.parseHTTPRangeSet(hTTPHeader.getValue());
            if (object3 == null) {
                NLogger.error("DOWNLOAD", "Failed to parse X-Available-Ranges in " + this.candidate.getVendor() + " request: " + hTTPResponse.buildHTTPResponseString());
            }
            this.candidate.setAvailableRangeSet((HTTPRangeSet)object3);
        }
        object3 = new ArrayList();
        objectArray = hTTPResponse.getHeaders("Alt-Location");
        object2 = AlternateLocationContainer.parseUriResAltLocFromHTTPHeaders((HTTPHeader[])objectArray);
        object3.addAll(object2);
        objectArray = hTTPResponse.getHeaders("X-Gnutella-Alternate-Location");
        object2 = AlternateLocationContainer.parseUriResAltLocFromHTTPHeaders((HTTPHeader[])objectArray);
        object3.addAll(object2);
        objectArray = hTTPResponse.getHeaders("X-Alt");
        object2 = AlternateLocationContainer.parseCompactIpAltLocFromHTTPHeaders((HTTPHeader[])objectArray, uRN);
        object3.addAll(object2);
        object = object3.iterator();
        while (object.hasNext()) {
            this.downloadFile.addDownloadCandidate((AlternateLocation)object.next());
        }
        objectArray = hTTPResponse.getHeaders("X-Pushproxies");
        this.handlePushProxyHeaders((HTTPHeader[])objectArray);
        objectArray = hTTPResponse.getHeaders("X-Push-Proxies");
        this.handlePushProxyHeaders((HTTPHeader[])objectArray);
        objectArray = hTTPResponse.getHeaders("X-Push-Proxy");
        this.handlePushProxyHeaders((HTTPHeader[])objectArray);
        this.updateKeepAliveSupport(hTTPResponse);
        int n = hTTPResponse.getStatusCode();
        if (n >= 200 && n < 300) {
            if (arrayList.size() == 0 && string.startsWith("/uri-res/N2R?")) {
                throw new IOException("Response to uri-res request without valid Content-URN header.");
            }
            if (this.downloadFile.getTotalDataSize() == -1L) {
                if (!$assertionsDisabled && this.segment.getTotalDataSize() != -1L) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.downloadFile.getSegmentCount() != 1) {
                    throw new AssertionError();
                }
                if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                    this.downloadFile.setFileSize(this.replyContentRange.totalLength);
                    this.segment.setTransferDataSize(this.replyContentRange.totalLength);
                    this.stopDownload();
                }
            }
            NLogger.debug("DOWNLOAD", "HTTP Handshake successfull.");
            return;
        }
        if (n == 503) {
            int n2;
            hTTPHeader = hTTPResponse.getHeader("X-Queue");
            XQueueParameters xQueueParameters = null;
            if (hTTPHeader != null) {
                xQueueParameters = XQueueParameters.parseHTTPRangeSet(hTTPHeader.getValue());
            }
            if (xQueueParameters != null && this.isKeepAliveSupported) {
                throw new RemotelyQueuedException(xQueueParameters);
            }
            hTTPHeader = hTTPResponse.getHeader("Retry-After");
            if (hTTPHeader != null && (n2 = HTTPRetryAfter.parseDeltaInSeconds(hTTPHeader)) > 0) {
                throw new HostBusyException(n2);
            }
            throw new HostBusyException();
        }
        if (n == 403) {
            if (this.candidate.isG2Faked()) {
                hTTPHeader = hTTPRequest.getHeader("X-Features");
                if (hTTPHeader != null && hTTPHeader.getValue().indexOf("g2/1.0") != -1) {
                    throw new UnusableHostException("Request Forbidden");
                }
                throw new HostBusyException();
            }
            throw new UnusableHostException("Request Forbidden");
        }
        if (n == 408) {
            throw new HostBusyException();
        }
        if (n == 404 || n == 410) {
            throw new FileNotAvailableException();
        }
        if (n == 416) {
            throw new RangeUnavailableException();
        }
        throw new IOException("Unknown HTTP code: " + n);
    }

    private void buildAltLocRequestHeader(HTTPRequest hTTPRequest) {
        Object object;
        URN uRN = this.downloadFile.getFileURN();
        if (uRN == null) {
            return;
        }
        AlternateLocationContainer alternateLocationContainer = new AlternateLocationContainer(uRN);
        alternateLocationContainer.addContainer(this.downloadFile.getGoodAltLocContainer());
        if (ServiceManager.sCfg.arePartialFilesShared && NetworkManager.getInstance().hasConnectedIncoming() && !((HostAddress)(object = NetworkManager.getInstance().getLocalAddress())).isPrivateIP()) {
            AlternateLocation alternateLocation = new AlternateLocation((HostAddress)object, uRN);
            alternateLocationContainer.addAlternateLocation(alternateLocation);
        }
        if ((object = alternateLocationContainer.getAltLocHTTPHeaderForAddress("X-Alt", this.candidate.getHostAddress(), this.candidate.getSendAltLocsSet())) != null) {
            hTTPRequest.addHeader((HTTPHeader)object);
        }
        if ((object = (alternateLocationContainer = this.downloadFile.getBadAltLocContainer()).getAltLocHTTPHeaderForAddress("X-NAlt", this.candidate.getHostAddress(), this.candidate.getSendAltLocsSet())) != null) {
            hTTPRequest.addHeader((HTTPHeader)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownload(File file) throws IOException {
        NLogger.debug("DOWNLOAD", "Download Engine starts download.");
        this.raFile = new RandomAccessFile(file, "rw");
        LengthLimitedInputStream lengthLimitedInputStream = null;
        try {
            int n;
            long l;
            this.segment.downloadStartNotify();
            String string = this.segment.toString();
            long l2 = Long.MAX_VALUE;
            if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                l2 = this.replyContentRange.totalLength;
            }
            if (this.replyContentLength != -1L) {
                l2 = Math.min(this.replyContentLength, l2);
            }
            if ((l = this.segment.getTransferDataSizeLeft()) != -1L) {
                l2 = Math.min(l, l2);
            }
            lengthLimitedInputStream = new LengthLimitedInputStream(this.inStream, l2);
            long l3 = this.segment.getTransferredDataSize();
            long l4 = this.segment.getTransferredDataSize();
            if (!$assertionsDisabled && l3 != l4) {
                throw new AssertionError();
            }
            this.raFile.seek(l3);
            byte[] byArray = new byte[16384];
            while ((n = lengthLimitedInputStream.read(byArray, 0, 16384)) > 0) {
                SWDownloadSegment sWDownloadSegment = this.segment;
                synchronized (sWDownloadSegment) {
                    if (!this.segment.isAllocatedByWorker()) {
                        NLogger.warn("DOWNLOAD", "Lucky we checked - would have added to a segment with no worker!  ll " + l2 + " l " + n + " ld " + l4 + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " worker: " + this.segment.getAllocatedByWorker() + " originally: " + string);
                        throw new IOException("Downloading to a segment with no worker!");
                    }
                    long l5 = l4 + (long)n;
                    if (l5 < this.segment.getTransferredDataSize()) {
                        NLogger.error("DOWNLOAD", "TransferredDataSize would be going down!  ll " + l2 + " l " + n + " ld " + l4 + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " originally: " + string);
                        throw new IOException("TransferredDataSize would be going down!");
                    }
                    if (this.segment.getTransferDataSize() > -1L && l5 > this.segment.getTransferDataSize()) {
                        NLogger.error("DOWNLOAD", "TransferredDataSize would be larger then segment!  ll " + l2 + " l " + n + " ld " + l4 + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " originally: " + string);
                        throw new IOException("TransferredDataSize would be larger then segment!");
                    }
                    this.raFile.write(byArray, 0, n);
                    this.segment.setTransferredDataSize(l4 += (long)n);
                    l = this.segment.getTransferDataSizeLeft();
                    if (l != -1L) {
                        l2 = Math.min(l, l2);
                        lengthLimitedInputStream.setLengthLimit(l2);
                    }
                }
            }
            this.isDownloadSuccessful = true;
        }
        finally {
            if (this.isAcceptingNextSegment()) {
                lengthLimitedInputStream.close();
                this.closeDownloadFile();
            } else {
                this.stopDownload();
            }
        }
    }

    private void closeDownloadFile() {
        if (this.raFile != null) {
            try {
                this.raFile.getFD().sync();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stopDownload() {
        NLogger.debug("DOWNLOAD", "Closing pipe and socket and telling segment we've stopped.");
        IOUtil.closeQuietly(this.inStream);
        if (this.segment != null) {
            this.segment.downloadStopNotify();
        }
        this.closeDownloadFile();
        if (this.connection != null) {
            this.connection.disconnect();
        }
        IOUtil.closeQuietly(this.socket);
    }

    public boolean isAcceptingNextSegment() {
        return this.isDownloadSuccessful && this.isKeepAliveSupported && this.replyContentLength != -1L;
    }

    private ContentRange parseContentRange(String string) throws WrongHTTPHeaderException {
        try {
            long l;
            ContentRange contentRange = new ContentRange();
            string = string.toLowerCase();
            int n = string.indexOf("bytes") + 6;
            String string2 = string.substring(n).trim();
            int n2 = string2.indexOf(47);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            contentRange.totalLength = string4.charAt(0) == '*' ? -1L : (l = Long.parseLong(string4));
            if (string3.charAt(0) == '*') {
                contentRange.startPos = 0L;
                contentRange.endPos = contentRange.totalLength;
            } else {
                int n3 = string2.indexOf(45);
                String string5 = string3.substring(0, n3);
                long l2 = Long.parseLong(string5);
                String string6 = string3.substring(n3 + 1);
                long l3 = Long.parseLong(string6);
                contentRange.startPos = l2;
                contentRange.endPos = l3;
            }
            return contentRange;
        }
        catch (NumberFormatException numberFormatException) {
            NLogger.warn("DOWNLOAD", numberFormatException, numberFormatException);
            throw new WrongHTTPHeaderException("Number error while parsing content range: " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new WrongHTTPHeaderException("Error while parsing content range: " + string);
        }
    }

    private void updateKeepAliveSupport(HTTPResponse hTTPResponse) {
        HTTPHeader hTTPHeader = hTTPResponse.getHeader("Connection");
        if (hTTPHeader != null) {
            if (hTTPHeader.getValue().equalsIgnoreCase("close")) {
                this.isKeepAliveSupported = false;
                return;
            }
            if (hTTPHeader.getValue().equalsIgnoreCase("keep-alive")) {
                this.isKeepAliveSupported = true;
                return;
            }
        }
        this.isKeepAliveSupported = hTTPResponse.getHTTPVersion().equals("HTTP/1.1");
    }

    public void handlePushProxyHeaders(HTTPHeader[] hTTPHeaderArray) {
        if (hTTPHeaderArray == null || hTTPHeaderArray.length == 0) {
            return;
        }
        ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                try {
                    HostAddress hostAddress = HostAddress.parseAndValidateAddress(string, false);
                    arrayList.add(hostAddress);
                }
                catch (MalformedHostAddressException malformedHostAddressException) {
                    NLogger.debug("DOWNLOAD", "Malformed alt-location URL: " + malformedHostAddressException.getMessage());
                }
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        HostAddress[] hostAddressArray = new HostAddress[arrayList.size()];
        arrayList.toArray(hostAddressArray);
        this.candidate.setPushProxyAddresses(hostAddressArray);
    }

    static {
        $assertionsDisabled = !DownloadEngine.class.desiredAssertionStatus();
    }

    private class ContentRange {
        long startPos;
        long endPos;
        long totalLength;

        private ContentRange() {
        }
    }
}

