/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.download.PushHandler;
import phex.host.Host;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.msg.MsgManager;
import phex.msg.MsgPushRequest;
import phex.statistic.UploadDownloadCountStatistic;
import phex.utils.NLogger;

public class PushRequestSleeper {
    private GUID clientGUID;
    private long fileIndex;
    private HostAddress[] pushProxyAddresses;
    private Socket givenSocket;

    public PushRequestSleeper(GUID gUID, long l, HostAddress[] hostAddressArray) {
        this.clientGUID = gUID;
        this.fileIndex = l;
        this.pushProxyAddresses = hostAddressArray;
    }

    public GUID getGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public synchronized boolean acceptGIVConnection(Socket socket, GUID gUID) {
        if (!this.clientGUID.equals(gUID)) {
            return false;
        }
        this.givenSocket = socket;
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Socket requestSocketViaPush() {
        boolean bl = false;
        try {
            if (this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
                bl = this.requestViaPushProxies();
            }
            if (!bl) {
                this.requestViaPushRoute();
            }
            if (!bl) {
                Socket socket = null;
                return socket;
            }
            try {
                this.wait(ServiceManager.sCfg.mPushTransferTimeout);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.givenSocket == null) {
                Socket socket = null;
                return socket;
            }
            Socket socket = this.givenSocket;
            return socket;
        }
        finally {
            PushHandler.unregisterPushRequestSleeper(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestViaPushProxies() {
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        String string = "/gnet/push-proxy?guid=" + this.clientGUID.toHexString();
        HttpURLConnection httpURLConnection = null;
        if (this.pushProxyAddresses.length > 0) {
            UploadDownloadCountStatistic.pushDldPushProxyAttempts.increment(1);
        }
        for (int i = 0; i < this.pushProxyAddresses.length; ++i) {
            try {
                String string2 = "http://" + this.pushProxyAddresses[i].getFullHostName() + string;
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", "PUSH via push proxy: " + string2);
                }
                URL uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.setRequestProperty("User-Agent", Environment.getPhexVendor());
                httpURLConnection.setRequestProperty("X-Node", hostAddress.getFullHostName());
                httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
                httpURLConnection.connect();
                int n = httpURLConnection.getResponseCode();
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", "PUSH via push proxy response code: " + n + " (" + string2 + ")");
                }
                if (n != 202) continue;
                UploadDownloadCountStatistic.pushDldPushProxySuccess.increment(1);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                if (!NLogger.isWarnEnabled("PUSH")) continue;
                NLogger.warn("PUSH", iOException);
                continue;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return false;
    }

    private boolean requestViaPushRoute() {
        try {
            HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
            MsgPushRequest msgPushRequest = new MsgPushRequest(this.clientGUID, this.fileIndex, hostAddress);
            Host host = MsgManager.getInstance().getPushRouting(this.clientGUID);
            if (host == null) {
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", "No PUSH route for " + this.clientGUID + ".");
                }
                return false;
            }
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", "Push route for " + this.clientGUID + " is " + host);
            }
            host.queueMessageToSend(msgPushRequest);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

