/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AlternateLocation;
import phex.common.ServiceManager;
import phex.common.ShortObj;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.http.CandidateRating;
import phex.http.HTTPRangeSet;
import phex.http.XQueueParameters;
import phex.msg.GUID;
import phex.query.QueryHitHost;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XMLUtils;

public class SWDownloadCandidate
implements SWDownloadConstants {
    private int failedConnectionTries;
    private GUID guid;
    private long fileIndex;
    private URN resourceURN;
    private URI downloadURI;
    private String fileName;
    private int lastTransferRateBPS;
    private HostAddress hostAddress;
    private ShortObj statusObj;
    private short errorStatus;
    private long statusTimeout;
    private int errorStatusRepetition;
    private String vendor;
    private boolean isG2Faked;
    private boolean isPushNeeded;
    private HostAddress[] pushProxyAddresses;
    private boolean isChatSupported;
    private Short hostRating;
    private HTTPRangeSet availableRangeSet = null;
    private long availableRangeSetTime = 0L;
    private SWDownloadFile downloadFile;
    private SWDownloadSegment downloadSegment;
    private XQueueParameters xQueueParameters;
    private Set sendAltLocSet;

    public SWDownloadCandidate(RemoteFile remoteFile, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = remoteFile.getFileIndex();
        this.fileName = remoteFile.getFilename();
        this.resourceURN = remoteFile.getURN();
        this.guid = remoteFile.getRemoteClientID();
        QueryHitHost queryHitHost = remoteFile.getQueryHitHost();
        this.vendor = queryHitHost.getVendor();
        this.isPushNeeded = queryHitHost.isPushNeeded();
        this.hostRating = queryHitHost.getHostRatingObject();
        this.hostAddress = remoteFile.getHostAddress();
        this.isChatSupported = queryHitHost.isChatSupported();
        this.pushProxyAddresses = queryHitHost.getPushProxyAddresses();
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.checkForG2Fake();
    }

    public SWDownloadCandidate(HostAddress hostAddress, long l, String string, Short s, URN uRN, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = l;
        this.fileName = string;
        this.resourceURN = uRN;
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostRating = s;
        this.hostAddress = hostAddress;
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
    }

    public SWDownloadCandidate(HostAddress hostAddress, URI uRI, SWDownloadFile sWDownloadFile) throws URIException {
        this.downloadFile = sWDownloadFile;
        this.fileName = URLUtil.getPathQueryFromUri(uRI);
        this.downloadURI = uRI;
        this.resourceURN = null;
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostRating = AlternateLocation.DEFAULT_HOST_RATING;
        this.hostAddress = hostAddress;
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
    }

    public SWDownloadCandidate(XJBSWDownloadCandidate xJBSWDownloadCandidate, SWDownloadFile sWDownloadFile) throws MalformedHostAddressException, URIException {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = xJBSWDownloadCandidate.getFileIndex();
        this.fileName = xJBSWDownloadCandidate.getFileName();
        this.lastTransferRateBPS = 0;
        String string = xJBSWDownloadCandidate.getGUID();
        if (string != null) {
            this.guid = new GUID(string);
        }
        try {
            this.downloadURI = new URI(xJBSWDownloadCandidate.getDownloadURI(), true);
        }
        catch (URIException uRIException) {
            NLogger.warn("DOWNLOAD", "Malformed URI in: " + sWDownloadFile.toString() + " - " + xJBSWDownloadCandidate.getDownloadURI() + " - " + this.toString(), uRIException);
            throw uRIException;
        }
        this.vendor = xJBSWDownloadCandidate.getVendor();
        this.isPushNeeded = xJBSWDownloadCandidate.isPushNeeded();
        this.isChatSupported = xJBSWDownloadCandidate.isChatSupported();
        this.hostRating = new Short(xJBSWDownloadCandidate.getRating());
        try {
            this.hostAddress = new HostAddress(xJBSWDownloadCandidate.getRemoteHost());
        }
        catch (MalformedHostAddressException malformedHostAddressException) {
            NLogger.warn("DOWNLOAD", "Malformed host address in: " + sWDownloadFile.toString() + " - " + xJBSWDownloadCandidate.getRemoteHost() + " - " + this.toString(), malformedHostAddressException);
            throw malformedHostAddressException;
        }
        this.resourceURN = sWDownloadFile.getFileURN();
        if (xJBSWDownloadCandidate.getConnectionFailedRepetition() > 0) {
            this.errorStatus = (short)13;
            this.failedConnectionTries = this.errorStatusRepetition = xJBSWDownloadCandidate.getConnectionFailedRepetition();
        }
        this.statusObj = new ShortObj(12);
        this.checkForG2Fake();
    }

    public String getDownloadRequestUrl() {
        String string;
        if (this.downloadURI != null) {
            try {
                String string2 = URLUtil.getPathQueryFromUri(this.downloadURI);
                return string2;
            }
            catch (URIException uRIException) {
                Logger.logWarning(uRIException);
            }
        }
        if (this.resourceURN != null) {
            string = URLUtil.buildName2ResourceURL(this.resourceURN);
        } else {
            String string3 = String.valueOf(this.fileIndex);
            StringBuffer stringBuffer = new StringBuffer(6 + string3.length() + this.fileName.length());
            stringBuffer.append("/get/");
            stringBuffer.append(string3);
            stringBuffer.append('/');
            stringBuffer.append(URLCodecUtils.encodeURL(this.fileName));
            string = stringBuffer.toString();
        }
        return string;
    }

    private long getRating() {
        if (this.lastTransferRateBPS == 0) {
            return 1000000L;
        }
        return this.lastTransferRateBPS;
    }

    public long getSpeed() {
        return this.lastTransferRateBPS;
    }

    protected void updateRating() {
        if (this.availableRangeSet == null) {
            return;
        }
        Logger.logMessage(Logger.INFO, (short)2, "Updating ratings for " + this);
        this.availableRangeSet.setRating(new CandidateRating(this.getRating()));
    }

    protected void finalize() {
        this.setAvailableRangeSet(null);
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getResourceURN() {
        return this.resourceURN;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getStatusTimeLeft() {
        long l = this.statusTimeout - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public short getStatus() {
        return this.statusObj.getValue();
    }

    public ShortObj getStatusObj() {
        return this.statusObj;
    }

    public int getFailedConnectionTries() {
        return this.failedConnectionTries;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        if (this.vendor == null || !this.vendor.equals(string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (XMLUtils.isXmlChar(string.charAt(i))) continue;
                return;
            }
            this.vendor = string;
            this.downloadFile.fireDownloadCandidateChanged(this);
            this.checkForG2Fake();
        }
    }

    private void checkForG2Fake() {
        this.isG2Faked = this.vendor != null && this.vendor.toLowerCase().indexOf("shareaza") != -1;
    }

    public boolean isG2Faked() {
        return this.isG2Faked;
    }

    public void updateXQueueParameters(XQueueParameters xQueueParameters) {
        if (this.xQueueParameters == null) {
            this.xQueueParameters = xQueueParameters;
        } else {
            this.xQueueParameters.update(xQueueParameters);
        }
    }

    public XQueueParameters getXQueueParameters() {
        return this.xQueueParameters;
    }

    public boolean isPushNeeded() {
        return this.isPushNeeded;
    }

    public HostAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(HostAddress[] hostAddressArray) {
        this.pushProxyAddresses = hostAddressArray;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setChatSupported(boolean bl) {
        this.isChatSupported = bl;
    }

    public short getHostRating() {
        return this.hostRating;
    }

    public Short getHostRatingObject() {
        return this.hostRating;
    }

    public boolean isRemotlyQueued() {
        return this.statusObj.value == 18;
    }

    public boolean isDownloading() {
        return this.statusObj.value == 20;
    }

    public Set getSendAltLocsSet() {
        if (this.sendAltLocSet == null) {
            this.sendAltLocSet = new HashSet();
        }
        return this.sendAltLocSet;
    }

    public void setAvailableRangeSet(HTTPRangeSet hTTPRangeSet) {
        if (hTTPRangeSet == null && this.availableRangeSet == null) {
            return;
        }
        if (this.availableRangeSet != null) {
            this.downloadFile.removeFromRangeSetList(this.availableRangeSet.getRangeSet());
        }
        this.availableRangeSet = hTTPRangeSet;
        if (this.availableRangeSet == null) {
            return;
        }
        Logger.logMessage(Logger.INFO, (short)2, "Adding a new rangeset for " + this.downloadFile.getDestinationFileName() + ": " + hTTPRangeSet);
        this.downloadFile.addToRangeSetList(this.availableRangeSet.getRangeSet());
        this.availableRangeSetTime = System.currentTimeMillis();
        this.updateRating();
    }

    public HTTPRangeSet getAvailableRangeSet() {
        if (System.currentTimeMillis() > this.availableRangeSetTime + 600000L) {
            this.setAvailableRangeSet(new HTTPRangeSet(0L, this.downloadFile.getTotalDataSize()));
        }
        return this.availableRangeSet;
    }

    public boolean equals(Object object) {
        if (object instanceof SWDownloadCandidate) {
            return this.equals((SWDownloadCandidate)object);
        }
        return false;
    }

    public boolean equals(SWDownloadCandidate sWDownloadCandidate) {
        return this.hostAddress.equals(sWDownloadCandidate.hostAddress);
    }

    public void setStatus(short s) {
        this.setStatus(s, -1);
    }

    public void setStatus(short s, int n) {
        long l;
        if (this.statusObj.value == s) {
            return;
        }
        this.statusObj.value = s;
        this.statusTimeout = l = System.currentTimeMillis();
        if (this.availableRangeSet != null && this.statusObj.value != 20) {
            this.availableRangeSet.setRating(new CandidateRating(1000000L));
        }
        switch (this.statusObj.value) {
            case 11: {
                l += 10800000L;
                break;
            }
            case 10: {
                l = Long.MAX_VALUE;
                break;
            }
            case 16: {
                break;
            }
            case 13: {
                ++this.failedConnectionTries;
                if (this.failedConnectionTries >= 12) {
                    this.downloadFile.markCandidateBad(this, true);
                    l = this.statusTimeout;
                    break;
                }
                if (this.failedConnectionTries >= 3) {
                    this.downloadFile.markCandidateBad(this, false);
                    l = this.statusTimeout;
                    break;
                }
                l += this.calculateConnectionFailedTimeout();
                break;
            }
            case 19: {
                this.failedConnectionTries = 0;
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                this.failedConnectionTries = 0;
                if (n > 0) {
                    l += (long)(n * 1000);
                    break;
                }
                l += this.determineErrorStatusTimeout(this.statusObj.value);
                break;
            }
            case 17: {
                l += (long)ServiceManager.sCfg.mPushTransferTimeout;
                break;
            }
            case 20: {
                this.errorStatus = 0;
                this.failedConnectionTries = 0;
            }
        }
        Logger.logMessage(Logger.FINEST, (short)2, "Setting status to " + s + " and raise timeout from " + this.statusTimeout + " to " + l + ".");
        this.statusTimeout = l;
        this.downloadFile.fireDownloadCandidateChanged(this);
    }

    private long calculateConnectionFailedTimeout() {
        return 120000L * (long)Math.pow(2.0, Math.min(this.failedConnectionTries - 1, 7));
    }

    private long determineErrorStatusTimeout(short s) {
        if (this.errorStatus == s) {
            ++this.errorStatusRepetition;
        } else {
            this.errorStatus = s;
            this.errorStatusRepetition = 0;
        }
        switch (this.errorStatus) {
            case 14: {
                return 60000L;
            }
            case 15: {
                return 60000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
            case 18: {
                if (this.xQueueParameters == null) {
                    return 0L;
                }
                return this.xQueueParameters.getRequestSleepTime();
            }
        }
        Logger.logWarning((short)2, "Unknown error status: " + this.errorStatus);
        return 0L;
    }

    public void manualConnectionRetry() {
        if (this.statusObj.value != 14 && this.statusObj.value != 13 && this.statusObj.value != 15 && this.statusObj.value != 11 && this.statusObj.value != 10) {
            return;
        }
        this.setStatus((short)12);
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    public boolean isAbleToBeAllocated() {
        if ((long)this.lastTransferRateBPS < ServiceManager.sCfg.minimumAllowedTransferRate && this.lastTransferRateBPS > 0) {
            Logger.logMessage(Logger.FINE, (short)2, "Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps");
            return false;
        }
        long l = System.currentTimeMillis();
        return this.statusTimeout <= l;
    }

    public void associateDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        if (this.availableRangeSet != null) {
            Logger.logMessage(Logger.INFO, (short)2, "Associating a segment, so updating ratings to " + this.lastTransferRateBPS);
            this.updateRating();
        }
        this.downloadSegment = sWDownloadSegment;
    }

    public long getPreferredSegmentSize() {
        long l = this.lastTransferRateBPS * ServiceManager.sCfg.segmentTransferTime;
        long l2 = -l % ServiceManager.sCfg.segmentMultiple;
        l += l2;
        if (this.lastTransferRateBPS == 0) {
            l = ServiceManager.sCfg.initialSegmentSize;
        }
        if (l > ServiceManager.sCfg.maximumSegmentSize) {
            l = ServiceManager.sCfg.maximumSegmentSize;
        }
        if (l < 1L) {
            Logger.logMessage(Logger.WARNING, (short)2, "Preferred size looks strange. bps=" + this.lastTransferRateBPS + " and stt=" + ServiceManager.sCfg.segmentTransferTime);
            l = ServiceManager.sCfg.initialSegmentSize;
        }
        Logger.logMessage(Logger.FINE, (short)2, "Preferred segment size is " + l);
        return l;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            this.lastTransferRateBPS = this.downloadSegment.getLongTermTransferRate();
            this.updateRating();
            this.downloadSegment = null;
        }
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public XJBSWDownloadCandidate createXJBSWDownloadCandidate() throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        XJBSWDownloadCandidate xJBSWDownloadCandidate = objectFactory.createXJBSWDownloadCandidate();
        xJBSWDownloadCandidate.setFileIndex(this.fileIndex);
        xJBSWDownloadCandidate.setFileName(this.fileName);
        if (this.guid != null) {
            xJBSWDownloadCandidate.setGUID(this.guid.toHexString());
        }
        if (this.downloadURI != null) {
            xJBSWDownloadCandidate.setDownloadURI(this.downloadURI.getEscapedURI());
        }
        xJBSWDownloadCandidate.setPushNeeded(this.isPushNeeded);
        xJBSWDownloadCandidate.setChatSupported(this.isChatSupported);
        xJBSWDownloadCandidate.setRating(this.hostRating);
        xJBSWDownloadCandidate.setRemoteHost(this.hostAddress.getFullHostName());
        xJBSWDownloadCandidate.setVendor(this.vendor);
        if (this.failedConnectionTries >= 3) {
            xJBSWDownloadCandidate.setConnectionFailedRepetition(this.failedConnectionTries);
        }
        return xJBSWDownloadCandidate;
    }

    public void log(String string) {
        if (!Logger.isLevelLogged(Logger.FINE)) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)2, "Candidate " + this.hostAddress + ": " + string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Candidate: ");
        if (this.vendor != null) {
            stringBuffer.append(this.vendor);
            stringBuffer.append(',');
        }
        stringBuffer.append("Adr:");
        stringBuffer.append(this.hostAddress);
        stringBuffer.append(" ->");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

