/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AlternateLocation;
import phex.common.AlternateLocationContainer;
import phex.common.FileHandlingException;
import phex.common.IntObj;
import phex.common.ServiceManager;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.bandwidth.BandwidthManager;
import phex.download.MagnetData;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadCandidatesChangeListener;
import phex.event.DownloadSegmentsChangeListener;
import phex.event.EventListenerList;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.http.CandidateRating;
import phex.http.HTTPRangeSet;
import phex.http.IRating;
import phex.http.PriorityRating;
import phex.http.Range;
import phex.query.ResearchSetting;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.Executer;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.StrUtil;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadSegment;

public class SWDownloadFile
implements TransferDataProvider,
SWDownloadConstants {
    private int indexOfAttemptedCandidate = -1;
    private List downloadSegments;
    private AlternateLocationContainer goodAltLocContainer;
    private AlternateLocationContainer badAltLocContainer;
    private Object candidatesLock = new Object();
    private ArrayList allCandidatesList;
    public List rangeSetList;
    private List rangePriorityList = null;
    private long rangePriorityRefreshTime = 0L;
    private ArrayList goodCandidatesList;
    private ArrayList badCandidatesList;
    private HashMap allocatedCandidateWorkerMap;
    private IntObj candidateCountObj;
    private IntObj downloadingCandidateCountObj;
    private IntObj queuedCandidateCountObj;
    private long fileSize;
    private int nextSegmentNumber;
    private File destinationFile;
    private String destinationPrefix;
    private String destinationSuffix;
    private short destinationType;
    public static final short DESTTYPE_UNKNOWN = 0;
    public static final short DESTTYPE_STREAMABLE = 1;
    public static final short DESTTYPE_UNSTREAMABLE = 2;
    private Date createdDate;
    private Date modifiedDate;
    private short status = 1;
    private long transferRateTimestamp;
    private int transferRateBytes;
    private long sessionTransferRateBytes;
    private int transferRate;
    private long transferStartTime;
    private long transferStopTime;
    private long transferDataSize;
    private long transferredDataSize;
    private long transferDataUpdateTime;
    private Integer currentProgress;
    private short workerCount;
    private URN fileURN;
    private URI downloadURI;
    private ResearchSetting researchSetting;
    public static final short ORDER_BY_POSITION = 1;
    public static final short ORDER_BY_RATING = 2;
    public static final short ORDER_IN_PREVIEW_MODE = 3;
    private int orderingMode;
    private Comparator orderingObject;
    private long previewSize;
    private EventListenerList listenerList = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private SWDownloadFile() {
        this.rangeSetList = Collections.synchronizedList(new LinkedList());
        this.allCandidatesList = new ArrayList();
        this.goodCandidatesList = new ArrayList();
        this.badCandidatesList = new ArrayList();
        this.allocatedCandidateWorkerMap = new HashMap();
        this.candidateCountObj = new IntObj(0);
        this.downloadingCandidateCountObj = new IntObj(0);
        this.queuedCandidateCountObj = new IntObj(0);
        this.currentProgress = new Integer(0);
        this.createdDate = this.modifiedDate = new Date(System.currentTimeMillis());
        BandwidthManager.getInstance().getTransferRateService().registerTransferDataProvider(this);
    }

    public SWDownloadFile(String string, String string2, long l, URN uRN) {
        this();
        this.initialize(string, uRN, l, string2, true);
    }

    public SWDownloadFile(URI uRI) throws URIException {
        this();
        this.downloadURI = uRI;
        String string = this.downloadURI.getScheme();
        if ("magnet".equals(string)) {
            MagnetData magnetData = MagnetData.parseFromURI(this.downloadURI);
            URN uRN = MagnetData.lookupSHA1URN(magnetData);
            String string2 = MagnetData.lookupFileName(magnetData);
            String string3 = ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(string2);
            String string4 = magnetData.getKeywordTopic() != null ? magnetData.getKeywordTopic() : StrUtil.createNaturalSearchTerm(MagnetData.lookupSearchName(magnetData));
            this.initialize(string3, uRN, -1L, string4, true);
            List list = MagnetData.lookupHttpURIs(magnetData);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                URI uRI2 = (URI)iterator.next();
                String string5 = uRI2.getHost();
                int n = uRI2.getPort();
                if (n == -1) {
                    n = 80;
                }
                HostAddress hostAddress = new HostAddress(string5, n);
                SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(hostAddress, uRI2, this);
                this.addDownloadCandidate(sWDownloadCandidate);
            }
            if (uRN != null || this.getCandidatesCount() == 0) {
                this.startSearchForCandidates();
            }
        } else {
            String string6 = URLUtil.getFileNameFromUri(this.downloadURI);
            String string7 = ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(string6);
            String string8 = StrUtil.createNaturalSearchTerm(string6);
            this.initialize(string7, null, -1L, string8, true);
            String string9 = this.downloadURI.getHost();
            if (string9 != null) {
                int n = this.downloadURI.getPort();
                if (n == -1) {
                    n = 80;
                }
                HostAddress hostAddress = new HostAddress(string9, n);
                SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(hostAddress, this.downloadURI, this);
                this.addDownloadCandidate(sWDownloadCandidate);
            }
        }
    }

    public SWDownloadFile(XJBSWDownloadFile xJBSWDownloadFile) {
        this();
        URN uRN = null;
        if (xJBSWDownloadFile.getFileURN() != null) {
            uRN = new URN(xJBSWDownloadFile.getFileURN());
        }
        this.initialize(ServiceManager.sCfg.mDownloadDir + File.separator + xJBSWDownloadFile.getLocalFileName(), uRN, xJBSWDownloadFile.getFileSize(), xJBSWDownloadFile.getSearchTerm(), false);
        this.setCreatedDate(new Date(xJBSWDownloadFile.getCreatedTime()));
        this.setDownloadedDate(new Date(xJBSWDownloadFile.getModifiedTime()));
        this.status = xJBSWDownloadFile.getStatus();
        this.createDownloadCandidates(xJBSWDownloadFile);
        this.createDownloadSegments(xJBSWDownloadFile);
        this.forceCollectionOfTransferData();
        this.transferRateBytes = 0;
        this.sessionTransferRateBytes = 0L;
        this.verifyStatus();
        if (this.isFileCompletedOrMoved()) {
            this.transferDataSize = this.transferredDataSize = this.fileSize;
            if (this.isFileCompleted()) {
                if (this.downloadSegments.size() == 1) {
                    this.moveToDestinationFile();
                } else {
                    this.setStatus((short)6);
                }
            }
        }
    }

    private void initialize(String string, URN uRN, long l, String string2, boolean bl) {
        this.destinationFile = new File(string);
        this.updateDestinationData();
        this.setInitialOrdering(ServiceManager.sCfg.orderingMethod);
        if (uRN != null) {
            this.fileURN = uRN;
            this.initAltLocContainers();
        }
        this.fileSize = l;
        this.previewSize = this.fileSize / 10L;
        this.researchSetting = new ResearchSetting(this);
        this.researchSetting.setSearchTerm(string2);
        if (bl) {
            this.createDownloadSegments();
        } else {
            this.downloadSegments = Collections.synchronizedList(new LinkedList());
        }
    }

    public void setFileSize(long l) {
        this.fileSize = l;
        this.previewSize = l / 10L;
    }

    private void setInitialOrdering(int n) {
        int n2;
        Logger.logMessage(Logger.FINE, (short)2, "Setting initial ordering for " + this.destinationFile.getName() + " using " + n);
        switch (this.destinationType) {
            case 1: {
                n2 = ServiceManager.sCfg.orderingMethod / 100;
                break;
            }
            case 2: {
                n2 = ServiceManager.sCfg.orderingMethod / 10 % 10;
                break;
            }
            case 0: {
                n2 = ServiceManager.sCfg.orderingMethod % 10;
                break;
            }
            default: {
                return;
            }
        }
        this.setOrdering(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        List list = this.downloadSegments;
        synchronized (list) {
            SWDownloadSegment sWDownloadSegment;
            int n = this.downloadSegments.size();
            if (n > 1) {
                return false;
            }
            if (n == 0) {
                return true;
            }
            SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(0);
            synchronized (sWDownloadSegment2) {
                return sWDownloadSegment.getTransferDataSizeLeft() == 0L;
            }
        }
    }

    public void setOrdering(int n) {
        if (n == this.orderingMode) {
            return;
        }
        try {
            switch (n) {
                case 2: {
                    this.orderingObject = new SWDownloadSegmentComparatorByRating(0L);
                    break;
                }
                case 1: {
                    this.orderingObject = new SWDownloadSegmentComparatorByPosition();
                    break;
                }
                case 3: {
                    this.orderingObject = new SWDownloadSegmentComparatorByRating(this.previewSize);
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
            this.orderingMode = n;
        }
        catch (Exception exception) {
            Logger.logMessage(Logger.SEVERE, (short)2, "Invalid ordering method requested; not changing anything");
        }
    }

    public int getOrdering() {
        return this.orderingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadSegmentAllocateable(HTTPRangeSet hTTPRangeSet) {
        if (this.fileSize != -1L && hTTPRangeSet != null) {
            Iterator iterator = hTTPRangeSet.getIterator();
            SWDownloadSegment sWDownloadSegment = null;
            while (iterator.hasNext()) {
                Range range = (Range)iterator.next();
                long l = range.getStartOffset(this.fileSize);
                long l2 = range.getEndOffset(this.fileSize);
                List list = this.downloadSegments;
                synchronized (list) {
                    Iterator iterator2 = this.downloadSegments.iterator();
                    while (iterator2.hasNext()) {
                        SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)iterator2.next();
                        synchronized (sWDownloadSegment2) {
                            long l3 = sWDownloadSegment.getTransferStartPosition();
                            long l4 = sWDownloadSegment.getEndOffset();
                            if (!$assertionsDisabled && l4 == -1L) {
                                throw new AssertionError();
                            }
                            if (l3 == l4 || l2 <= l3 || l >= l4) {
                                continue;
                            }
                            if (sWDownloadSegment.isAbleToBeAllocated()) {
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }
        List list = this.downloadSegments;
        synchronized (list) {
            SWDownloadSegment sWDownloadSegment = null;
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment = (SWDownloadSegment)iterator.next();
                synchronized (sWDownloadSegment3) {
                    if (sWDownloadSegment.isAbleToBeAllocated()) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private void validateSegments() {
    }

    public SWDownloadSegment allocateDownloadSegment(SWDownloadWorker sWDownloadWorker, HTTPRangeSet hTTPRangeSet, long l, long l2) {
        boolean bl;
        SWDownloadSegment sWDownloadSegment = null;
        do {
            bl = false;
            if (this.fileSize != -1L && hTTPRangeSet != null) {
                sWDownloadSegment = this.allocateSegmentForRangeSet(sWDownloadWorker, hTTPRangeSet, l);
                NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "Allocated: " + sWDownloadSegment);
            } else {
                sWDownloadSegment = this.allocateSegment(sWDownloadWorker, l);
                NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "Allocated: " + sWDownloadSegment);
            }
            boolean bl2 = this.canHijackSegment(hTTPRangeSet, l2);
            if (sWDownloadSegment != null || !bl2) continue;
            bl = true;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"This thread should never be interrupted!");
                }
            }
        } while (bl);
        return sWDownloadSegment;
    }

    public SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = this.allocateGoodCandidate(sWDownloadWorker);
        if (sWDownloadCandidate == null) {
            sWDownloadCandidate = this.allocateBadCandidate(sWDownloadWorker);
        }
        return sWDownloadCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateGoodCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.goodCandidatesList.size();
            if (n == 0) {
                return null;
            }
            if (++this.indexOfAttemptedCandidate >= n) {
                this.indexOfAttemptedCandidate = 0;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = i + this.indexOfAttemptedCandidate;
                if (n2 >= n) {
                    n2 -= n;
                }
                if (!(sWDownloadCandidate = (SWDownloadCandidate)this.goodCandidatesList.get(n2)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(sWDownloadCandidate)) continue;
                sWDownloadCandidate.log("Allocated from " + sWDownloadWorker);
                this.allocatedCandidateWorkerMap.put(sWDownloadCandidate, sWDownloadWorker);
                this.indexOfAttemptedCandidate = n2;
                return sWDownloadCandidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateBadCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.badCandidatesList.size();
            if (n == 0) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                sWDownloadCandidate = (SWDownloadCandidate)this.badCandidatesList.get(i);
                if (sWDownloadCandidate == null || !sWDownloadCandidate.isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(sWDownloadCandidate)) continue;
                sWDownloadCandidate.log("Allocated from " + sWDownloadWorker);
                this.allocatedCandidateWorkerMap.put(sWDownloadCandidate, sWDownloadWorker);
                Object e = this.badCandidatesList.remove(i);
                if (e != null) {
                    this.badCandidatesList.add(e);
                }
                return sWDownloadCandidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            SwarmingManager.getInstance().releaseCandidateIP(sWDownloadCandidate);
            sWDownloadCandidate.log("Releasing worker allocation");
            this.allocatedCandidateWorkerMap.remove(sWDownloadCandidate);
        }
    }

    public boolean addDownloadCandidate(RemoteFile remoteFile) {
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(remoteFile, this);
        return this.addDownloadCandidate(sWDownloadCandidate);
    }

    public boolean addDownloadCandidate(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (this.fileURN != null && !uRN.equals(this.fileURN)) {
            Logger.logMessage(Logger.FINE, (short)2, "AlternateLocation URN does not match!");
            return false;
        }
        HostAddress hostAddress = alternateLocation.getHostAddress();
        if (hostAddress.isLocalHost()) {
            return false;
        }
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(hostAddress, 0L, null, AlternateLocation.DEFAULT_HOST_RATING, uRN, this);
        return this.addDownloadCandidate(sWDownloadCandidate);
    }

    public IRating getRating() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (this.fileURN == null && uRN != null) {
            this.fileURN = uRN;
            this.initAltLocContainers();
        }
        if (this.fileURN != null && uRN != null && !this.fileURN.equals(uRN)) {
            Logger.logMessage(Logger.FINE, (short)2, "Candidate URN to add does not match!");
            return false;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            if (this.allCandidatesList.contains(sWDownloadCandidate)) {
                return false;
            }
            Logger.logMessage(Logger.FINE, (short)2, "Adding download candidate " + sWDownloadCandidate);
            int n = this.allCandidatesList.size();
            this.allCandidatesList.add(n, sWDownloadCandidate);
            this.fireDownloadCandidateAdded(n);
            this.goodCandidatesList.add(sWDownloadCandidate);
        }
        SwarmingManager.getInstance().notifyWaitingWorkers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateBad(SWDownloadCandidate sWDownloadCandidate, boolean bl) {
        if (sWDownloadCandidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.goodCandidatesList.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.goodCandidatesList.remove(n);
            }
            if (!this.badCandidatesList.contains(sWDownloadCandidate)) {
                this.badCandidatesList.add(sWDownloadCandidate);
                Logger.logMessage(Logger.FINE, (short)2, "Moving candidate to bad list: " + sWDownloadCandidate.getHostAddress());
            }
        }
        if (bl) {
            sWDownloadCandidate.setStatus((short)10);
        } else {
            sWDownloadCandidate.setStatus((short)11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateGood(SWDownloadCandidate sWDownloadCandidate) {
        if (sWDownloadCandidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.badCandidatesList.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.badCandidatesList.remove(n);
            }
            if (!this.goodCandidatesList.contains(sWDownloadCandidate)) {
                this.goodCandidatesList.add(sWDownloadCandidate);
                Logger.logMessage(Logger.FINE, (short)2, "Moving candidate to good list: " + sWDownloadCandidate.getHostAddress());
            }
        }
    }

    public void addBadAltLoc(SWDownloadCandidate sWDownloadCandidate) {
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (uRN != null && this.fileURN != null) {
            AlternateLocation alternateLocation = new AlternateLocation(sWDownloadCandidate.getHostAddress(), uRN);
            this.goodAltLocContainer.removeAlternateLocation(alternateLocation);
            this.badAltLocContainer.addAlternateLocation(alternateLocation);
        }
        Logger.logMessage(Logger.FINE, (short)2, "Adding bad alt loc: " + sWDownloadCandidate.getHostAddress());
    }

    public void addGoodAltLoc(SWDownloadCandidate sWDownloadCandidate) {
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (uRN != null && this.fileURN != null) {
            AlternateLocation alternateLocation = new AlternateLocation(sWDownloadCandidate.getHostAddress(), uRN);
            this.badAltLocContainer.removeAlternateLocation(alternateLocation);
            this.goodAltLocContainer.addAlternateLocation(alternateLocation);
        }
        Logger.logMessage(Logger.FINE, (short)2, "Adding good alt loc: " + sWDownloadCandidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment;
        synchronized (sWDownloadSegment2) {
            sWDownloadSegment.setAllocatedByWorker(null);
        }
    }

    public int getCandidatesCount() {
        return this.allCandidatesList.size();
    }

    public IntObj getCandidatesCountObject() {
        if (this.candidateCountObj.intValue() != this.allCandidatesList.size()) {
            this.candidateCountObj.setValue(this.allCandidatesList.size());
        }
        return this.candidateCountObj;
    }

    public IntObj getDownloadingCandidatesCountObject() {
        Set set = this.allocatedCandidateWorkerMap.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
            if (!sWDownloadCandidate.isDownloading()) continue;
            ++n;
        }
        if (this.downloadingCandidateCountObj.intValue() != n) {
            this.downloadingCandidateCountObj.setValue(n);
        }
        return this.downloadingCandidateCountObj;
    }

    public IntObj getQueuedCandidatesCountObject() {
        Set set = this.allocatedCandidateWorkerMap.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
            if (!sWDownloadCandidate.isRemotlyQueued()) continue;
            ++n;
        }
        if (this.queuedCandidateCountObj.intValue() != n) {
            this.queuedCandidateCountObj.setValue(n);
        }
        return this.queuedCandidateCountObj;
    }

    public SWDownloadCandidate getCandidate(int n) {
        if (n < 0 || n >= this.allCandidatesList.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.allCandidatesList.get(n);
    }

    public AlternateLocationContainer getGoodAltLocContainer() {
        return this.goodAltLocContainer;
    }

    public AlternateLocationContainer getBadAltLocContainer() {
        return this.badAltLocContainer;
    }

    public URI getURI() {
        return this.downloadURI;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    protected void setCreatedDate(Date date) {
        this.createdDate = date;
    }

    public Date getDownloadedDate() {
        return this.modifiedDate;
    }

    protected void setDownloadedDate(Date date) {
        this.modifiedDate = date;
    }

    public int getSegmentCount() {
        return this.downloadSegments.size();
    }

    public SWDownloadSegment getSegment(int n) {
        if (n >= this.downloadSegments.size()) {
            return null;
        }
        return (SWDownloadSegment)this.downloadSegments.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadSegment getSegmentForRange(Range range) {
        long l = range.getStartOffset(this.fileSize);
        long l2 = range.getEndOffset(this.fileSize);
        List list = this.downloadSegments;
        synchronized (list) {
            int n = this.downloadSegments.size();
            for (int i = 0; i < n; ++i) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(i);
                if (sWDownloadSegment.getStartOffset() > l || sWDownloadSegment.getEndOffset() < l2) continue;
                return sWDownloadSegment;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRangeSet createAvailableRangeSet() {
        HTTPRangeSet hTTPRangeSet = new HTTPRangeSet();
        List list = this.downloadSegments;
        synchronized (list) {
            int n = this.downloadSegments.size();
            for (int i = 0; i < n; ++i) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(i);
                if (sWDownloadSegment.getTransferredDataSize() <= 0L) continue;
                hTTPRangeSet.addRange(sWDownloadSegment.getStartOffset(), sWDownloadSegment.getTransferStartPosition());
            }
        }
        return hTTPRangeSet;
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public void startSearchForCandidates() {
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            Logger.logMessage(Logger.FINE, (short)2, "DownloadFile Status " + s);
            switch (s) {
                case 3: {
                    SimpleStatisticProvider simpleStatisticProvider = (SimpleStatisticProvider)StatisticsManager.getInstance().getStatisticProvider("SessionDownloadCountProvider");
                    simpleStatisticProvider.increment(1);
                }
                case 1: 
                case 4: {
                    this.downloadStopNotify();
                    break;
                }
                case 2: {
                    this.downloadStartNotify();
                }
            }
            this.status = s;
            SwarmingManager.getInstance().fireDownloadFileChanged(this);
        }
    }

    public short getStatus() {
        return this.status;
    }

    public boolean isAbleToBeAllocated() {
        return !this.isDownloadStopped() && !this.isFileCompletedOrMoved() && this.workerCount <= ServiceManager.sCfg.maxWorkerPerDownload;
    }

    public void incrementWorkerCount() {
        this.workerCount = (short)(this.workerCount + 1);
    }

    public void decrementWorkerCount() {
        this.workerCount = (short)(this.workerCount - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyStatus() {
        this.forceCollectionOfTransferData();
        Object object = this.candidatesLock;
        synchronized (object) {
            if (!this.isFileCompletedOrMoved() && this.getTransferDataSize() == this.getTransferredDataSize()) {
                this.setStatus((short)3);
                this.researchSetting.stopSearch();
                return;
            }
            Iterator iterator = this.allocatedCandidateWorkerMap.keySet().iterator();
            int n = 12;
            while (iterator.hasNext()) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                switch (sWDownloadCandidate.getStatus()) {
                    case 20: {
                        this.setStatus((short)2);
                        return;
                    }
                    case 18: {
                        n = 18;
                    }
                }
            }
            if (!this.isDownloadStopped() && !this.isFileCompletedOrMoved()) {
                if (n == 18) {
                    this.setStatus((short)5);
                } else {
                    this.setStatus((short)1);
                }
            }
        }
    }

    public boolean isFileCompleted() {
        return this.status == 3;
    }

    public boolean isFileCompletedMoved() {
        return this.status == 6;
    }

    public boolean isFileCompletedOrMoved() {
        return this.status == 6 || this.status == 3;
    }

    public boolean isDownloadInProgress() {
        return this.status == 2;
    }

    public boolean isDownloadStopped() {
        return this.status == 4;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public String getDestinationFileName() {
        return this.destinationFile.getName();
    }

    public void setDestinationFile(File file, boolean bl) throws FileHandlingException {
        if (file.compareTo(this.destinationFile) == 0) {
            return;
        }
        if (bl) {
            if (SwarmingManager.getInstance().isNewLocalFilenameUsed(this, file)) {
                throw new FileHandlingException(1);
            }
            this.renameSegmentsToDestinationRoot(file);
            FileUtils.renameLocalFile(this.destinationFile, file);
        }
        this.destinationFile = file;
        this.updateDestinationData();
    }

    private void updateDestinationData() {
        String[] stringArray = new String[2];
        Pattern pattern = Pattern.compile("^(.*)(\\..+?)$");
        Matcher matcher = pattern.matcher(this.destinationFile.getName());
        if (matcher.matches()) {
            this.destinationPrefix = new String(matcher.group(1) + " ");
            this.destinationSuffix = matcher.group(2);
        } else {
            this.destinationPrefix = this.destinationFile.getName();
            this.destinationSuffix = new String("???");
        }
        if (Executer.matches(ServiceManager.sCfg.streamableSuffixes.iterator(), this.destinationSuffix) != null) {
            Logger.logMessage(Logger.FINE, (short)2, "Appears to be a streamable file.");
            this.destinationType = 1;
        } else if (Executer.matches(ServiceManager.sCfg.unstreamableSuffixes.iterator(), this.destinationSuffix) != null) {
            Logger.logMessage(Logger.FINE, (short)2, "Appears to be an unstreamable file.");
            this.destinationType = (short)2;
        } else {
            Logger.logMessage(Logger.FINE, (short)2, "Not recognised as either streamable or unstreamable.");
            this.destinationType = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String canPreview() {
        List list = this.downloadSegments;
        synchronized (list) {
            if (this.downloadSegments.size() >= 1) {
                SWDownloadSegment sWDownloadSegment;
                if (this.destinationType == 2) {
                    return null;
                }
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(0);
                synchronized (sWDownloadSegment2) {
                    if (sWDownloadSegment.getStartOffset() != 0L || sWDownloadSegment.getTransferDataSizeLeft() > 0L || sWDownloadSegment.getTransferDataSize() < 1L || sWDownloadSegment.getAllocatedByWorker() != null) {
                        return null;
                    }
                }
            }
        }
        return this.getViewCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void generatePreview() {
        List list = this.downloadSegments;
        synchronized (list) {
            SWDownloadSegment sWDownloadSegment = null;
            if (this.downloadSegments.isEmpty()) {
                new Thread(new Executer(this.destinationFile, this.getViewCommand())).start();
                return;
            }
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)iterator.next();
                synchronized (sWDownloadSegment2) {
                    if (sWDownloadSegment.getStartOffset() == 0L) {
                        if (sWDownloadSegment.getTransferDataSizeLeft() > 0L || sWDownloadSegment.getTransferDataSize() < 1L || sWDownloadSegment.getAllocatedByWorker() != null) {
                            return;
                        }
                        File file = null;
                        StringBuffer stringBuffer = new StringBuffer("Preview of " + this.destinationPrefix);
                        if (ServiceManager.sCfg.copyBeforePreviewing) {
                            try {
                                int n;
                                File file2 = sWDownloadSegment.getIncompleteFile();
                                File file3 = File.createTempFile(stringBuffer.toString(), this.destinationSuffix, null);
                                file3.deleteOnExit();
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                                byte[] byArray = new byte[0x100000];
                                while ((n = ((InputStream)bufferedInputStream).read(byArray)) > 0) {
                                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                                }
                                ((InputStream)bufferedInputStream).close();
                                ((OutputStream)bufferedOutputStream).close();
                                file = file3;
                            }
                            catch (Exception exception) {
                                Logger.logMessage(Logger.SEVERE, (short)2, "Having trouble creating preview copy for " + sWDownloadSegment.getIncompleteFile().getName() + "(" + stringBuffer.toString() + ", " + this.destinationSuffix + ", " + this.destinationFile.getParentFile());
                                Logger.logMessage(Logger.SEVERE, (short)2, exception);
                                exception.printStackTrace();
                            }
                        } else {
                            file = sWDownloadSegment.getIncompleteFile();
                        }
                        if (file != null) {
                            new Thread(new Executer(file, this.getViewCommand())).start();
                        }
                        return;
                    }
                }
            }
        }
    }

    private String getViewCommand() {
        return Executer.getViewCommand(this.destinationSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToDestinationFile() {
        List list = this.downloadSegments;
        synchronized (list) {
            if (this.isFileCompletedMoved()) {
                return;
            }
            if (this.downloadSegments.size() != 1 && this.status == 3) {
                throw new RuntimeException("There must be exactly one download segment (found " + this.downloadSegments.size() + ") and the download must be completed to move to destination file '" + this.destinationFile.getName() + "'");
            }
            SWDownloadSegment sWDownloadSegment = this.getSegment(0);
            File file = sWDownloadSegment.getIncompleteFile();
            File file2 = this.destinationFile;
            if (!file2.isAbsolute()) {
                file2 = new File(ServiceManager.sCfg.mDownloadDir, this.destinationFile.getName());
            }
            int n = 0;
            while (file2.exists()) {
                ++n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.destinationFile.getParent());
                stringBuffer.append(File.separatorChar);
                stringBuffer.append('(');
                stringBuffer.append(n);
                stringBuffer.append(") ");
                stringBuffer.append(this.destinationFile.getName());
                file2 = new File(stringBuffer.toString());
            }
            Logger.logMessage(Logger.FINE, (short)2, "Renaming final segment from " + file.getAbsolutePath() + " to " + file2.getAbsoluteFile() + ".");
            boolean bl = file.renameTo(file2);
            if (bl) {
                this.downloadSegments.remove(sWDownloadSegment);
                Logger.logMessage(Logger.FINE, (short)2, "File " + this.destinationFile.getName() + " has been moved to its final location");
                new Thread(new Executer(this.destinationFile, ServiceManager.sCfg.completionNotifyMethod)).start();
            } else {
                Logger.logMessage(Logger.FINE, (short)2, "Renaming from " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + " failed.");
            }
            this.setStatus((short)6);
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted) {
            SwarmingManager.getInstance().removeDownloadFile(this);
        } else {
            SwarmingManager.getInstance().notifyDownloadListChange();
        }
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getShortTermTransferRate() {
        if (this.isFileCompletedOrMoved()) {
            this.transferRate = 0;
        } else if (this.transferRateTimestamp != 0L) {
            double d = (System.currentTimeMillis() - this.transferRateTimestamp) / 1000L;
            if ((this.transferRateBytes > 0 || d > 1.0) && d != 0.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 3: 
            case 6: {
                return 12;
            }
        }
        return 11;
    }

    public long getTransferDataSize() {
        this.lazyCollectTransferData();
        return this.transferDataSize;
    }

    public long getTotalDataSize() {
        return this.fileSize;
    }

    public long getTransferredDataSize() {
        this.lazyCollectTransferData();
        return this.transferredDataSize;
    }

    public int getLongTermTransferRate() {
        long l = this.transferStopTime != 0L ? (this.transferStopTime - this.transferStartTime) / 1000L : (System.currentTimeMillis() - this.transferStartTime) / 1000L;
        return (int)(this.sessionTransferRateBytes / (l + 1L));
    }

    public Integer getProgress() {
        int n;
        if (this.isFileCompletedOrMoved()) {
            n = 100;
        } else {
            long l = this.transferDataSize;
            if (l == 0L) {
                l = 1L;
            }
            n = (int)(this.transferredDataSize * 100L / l);
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void startDownload() {
        this.setStatus((short)1);
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    public void stopDownload(SWDownloadCandidate sWDownloadCandidate) {
        SWDownloadWorker sWDownloadWorker = (SWDownloadWorker)this.allocatedCandidateWorkerMap.get(sWDownloadCandidate);
        if (sWDownloadWorker != null) {
            sWDownloadWorker.stopDownload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownload() {
        this.setStatus((short)4);
        Object object = this.candidatesLock;
        synchronized (object) {
            Iterator iterator = this.allocatedCandidateWorkerMap.values().iterator();
            while (iterator.hasNext()) {
                SWDownloadWorker sWDownloadWorker = (SWDownloadWorker)iterator.next();
                if (sWDownloadWorker == null) continue;
                sWDownloadWorker.stopDownload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadSegmentFiles() {
        if (this.status != 4) {
            Logger.logMessage(Logger.WARNING, (short)2, "Can't clean temp files of not stopped download file.");
            return;
        }
        List list = this.downloadSegments;
        synchronized (list) {
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                sWDownloadSegment.removeDownloadDestinationFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameSegmentsToDestinationRoot(File file) throws FileHandlingException {
        List list = this.downloadSegments;
        synchronized (list) {
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                sWDownloadSegment.renameToDestinationRoot(file);
            }
        }
    }

    private void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.modifiedDate = new Date(this.transferStartTime);
        this.transferRateTimestamp = this.transferStartTime;
        this.transferStopTime = 0L;
        this.sessionTransferRateBytes = 0L;
    }

    private void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
            if (this.status == 2) {
                this.modifiedDate = new Date(this.transferStopTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCollectionOfTransferData() {
        long l = 0L;
        long l2 = 0L;
        List list = this.downloadSegments;
        synchronized (list) {
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment;
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)iterator.next();
                synchronized (sWDownloadSegment2) {
                    l += sWDownloadSegment.getTransferredDataSize();
                    long l3 = sWDownloadSegment.getTransferDataSize();
                    if (l3 != -1L) {
                        l2 += l3;
                    }
                }
            }
        }
        this.transferRateBytes = (int)((long)this.transferRateBytes + (l - this.transferredDataSize));
        this.sessionTransferRateBytes += l - this.transferredDataSize;
        this.transferDataSize = this.fileSize == -1L ? -1L : l2;
        this.transferredDataSize = l;
        this.transferDataUpdateTime = System.currentTimeMillis() + 1000L;
    }

    private void lazyCollectTransferData() {
        long l = System.currentTimeMillis();
        if (this.isFileCompletedOrMoved() || this.transferDataUpdateTime > l) {
            return;
        }
        this.forceCollectionOfTransferData();
    }

    private boolean closeEnough(Range range, Range range2) {
        if (range.getRating().getValue() == 0L || range2.getRating().getValue() == 0L) {
            return true;
        }
        return range.getRating().getValue() == range2.getRating().getValue();
    }

    private void compressRangePriorityList() {
        Iterator iterator = this.rangePriorityList.iterator();
        int n = 0;
        if (!iterator.hasNext()) {
            return;
        }
        Range range = (Range)iterator.next();
        while (iterator.hasNext()) {
            Range range2 = (Range)iterator.next();
            if (this.closeEnough(range, range2)) {
                range.update(range.getStartOffset(this.fileSize), range2.getEndOffset(this.fileSize));
                if (range.getRating().getValue() == 0L) {
                    range.setRating(range2.getRating());
                }
                iterator.remove();
                ++n;
                continue;
            }
            range = range2;
        }
        if (n > 0) {
            NLogger.info("DWNLD_RANGE_PRIORITY", "Compression of priority list is complete (compressed by " + n + " elements):\n" + this.rangePriorityList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRangeSetList(Collection collection) {
        List list = this.rangeSetList;
        synchronized (list) {
            Logger.logMessage(Logger.INFO, (short)2, "Removing " + collection.size() + " old entries. - " + collection);
            this.rangeSetList.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRangeSetList(Collection collection) {
        List list = this.rangeSetList;
        synchronized (list) {
            Logger.logMessage(Logger.INFO, (short)2, "Rangeset had " + this.rangeSetList.size() + " members before addition of new ranges.");
            this.rangeSetList.addAll(collection);
            Logger.logMessage(Logger.INFO, (short)2, "Rangeset now has " + this.rangeSetList.size() + " members.");
        }
    }

    public void refreshSegmentPriorities() {
        if (!this.isDownloadStopped() && !this.isFileCompletedOrMoved()) {
            this.rebuildRangePriorityList();
            this.compressRangePriorityList();
            this.rerateSegments();
            this.sortSegments();
            this.mergeSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildRangePriorityList() {
        NLogger.debug("DWNLD_RANGE_PRIORITY", "Rebuilding range priority list");
        this.rangePriorityList = new LinkedList();
        List list = this.rangeSetList;
        synchronized (list) {
            ListIterator listIterator = this.rangeSetList.listIterator();
            while (listIterator.hasNext()) {
                Range range = (Range)listIterator.next();
                NLogger.debug("DWNLD_RANGE_PRIORITY", "Adding source range: " + range);
                long l = range.getStartOffset(this.fileSize);
                long l2 = range.getEndOffset(this.fileSize);
                CandidateRating candidateRating = (CandidateRating)range.getRating();
                ListIterator<Range> listIterator2 = this.rangePriorityList.listIterator();
                NLogger.debug("DWNLD_RANGE_PRIORITY", "Adding to RPL (dst): " + this.rangePriorityList);
                while (listIterator2.hasNext() && l <= l2) {
                    Range range2 = (Range)listIterator2.next();
                    long l3 = range2.getStartOffset(this.fileSize);
                    long l4 = range2.getEndOffset(this.fileSize);
                    if (l > l4) continue;
                    NLogger.debug("DWNLD_RANGE_PRIORITY", "Src isn't completely after: " + range2);
                    if (l < l3) {
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "Adding entry from src prior to " + range2);
                        if (l2 < l3) {
                            listIterator2.previous();
                            listIterator2.add(new Range(l, l2, PriorityRating.derive(candidateRating)));
                            listIterator2.next();
                            l = l2 + 1L;
                        } else {
                            listIterator2.previous();
                            listIterator2.add(new Range(l, l3, PriorityRating.derive(candidateRating)));
                            listIterator2.next();
                            l = l3;
                        }
                    }
                    if (l > l2) continue;
                    if (l > l3) {
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "Splitting " + range2 + " at start of src (" + l + ")");
                        listIterator2.previous();
                        listIterator2.add(new Range(l3, l - 1L, new PriorityRating(range2.getRating())));
                        listIterator2.next();
                        range2.update(l, range2.getEndOffset(this.fileSize));
                        l3 = l;
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "After split, RPL is: " + this.rangePriorityList);
                    }
                    if (l != l3) continue;
                    if (l2 < l4) {
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "Splitting " + range2 + " to end of src (" + l2 + ")");
                        listIterator2.previous();
                        PriorityRating priorityRating = new PriorityRating(range2.getRating());
                        listIterator2.add(new Range(l3, l2, priorityRating));
                        listIterator2.next();
                        range2.update(l2 + 1L, range2.getEndOffset(this.fileSize));
                        priorityRating.accumulate(candidateRating);
                        l = l2 + 1L;
                        continue;
                    }
                    range2.accumulate(candidateRating);
                    l = l4 + 1L;
                }
                if (l > l2) continue;
                listIterator2.add(new Range(l, l2, PriorityRating.derive(candidateRating)));
            }
            NLogger.debug("DWNLD_RANGE_PRIORITY", "Rebuild of priority list is complete:\n" + this.rangePriorityList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rerateSegments() {
        int n = 0;
        int n2 = 0;
        ListIterator listIterator = this.rangePriorityList.listIterator();
        Range range = null;
        if (listIterator.hasNext()) {
            range = (Range)listIterator.next();
        }
        NLogger.debug("DWNLD_RANGE_PRIORITY", "Rerating segments using: " + this.rangePriorityList);
        List list = this.downloadSegments;
        synchronized (list) {
            ListIterator listIterator2 = this.downloadSegments.listIterator();
            SWDownloadSegment sWDownloadSegment = null;
            while (listIterator2.hasNext()) {
                sWDownloadSegment = (SWDownloadSegment)listIterator2.next();
                NLogger.debug("DWNLD_RANGE_PRIORITY", "Processing segment: " + sWDownloadSegment);
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment;
                synchronized (sWDownloadSegment2) {
                    while (range != null && range.getEndOffset(this.fileSize) < sWDownloadSegment.getStartOffset()) {
                        if (listIterator.hasNext()) {
                            range = (Range)listIterator.next();
                            continue;
                        }
                        range = null;
                    }
                    if (range == null) {
                        sWDownloadSegment.rating = new PriorityRating(1000000L, 0L);
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "No overlapping range found.");
                        continue;
                    }
                    NLogger.debug("DWNLD_RANGE_PRIORITY", "Applicable range: " + range);
                    if (sWDownloadSegment.isAbleToBeAllocated() && sWDownloadSegment.getAllocatedByWorker() == null && sWDownloadSegment.getTransferredDataSize() == 0L && sWDownloadSegment.getEndOffset() != -1L && sWDownloadSegment.getEndOffset() > 1L + range.getEndOffset(this.fileSize)) {
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "trying to split with s: " + sWDownloadSegment.getStartOffset() + "-" + (range.getEndOffset(this.fileSize) - sWDownloadSegment.getStartOffset()) + " for re-rating.");
                        this.validateSegments();
                        sWDownloadSegment = this.splitDownloadSegment(listIterator2, 0L, 1L + range.getEndOffset(this.fileSize) - sWDownloadSegment.getStartOffset());
                        this.validateSegments();
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "After merge it looks like: " + this.downloadSegments);
                        while ((SWDownloadSegment)listIterator2.previous() != sWDownloadSegment) {
                        }
                        listIterator2.next();
                        ++n;
                    }
                    if (!sWDownloadSegment.rating.equals(range.getRating())) {
                        ++n2;
                        sWDownloadSegment.rating = (PriorityRating)range.getRating();
                        NLogger.debug("DWNLD_RANGE_PRIORITY", "New rating is: " + sWDownloadSegment.rating);
                    }
                }
            }
        }
        if (n > 0 || n2 > 0) {
            NLogger.info("DWNLD_RANGE_PRIORITY", "Rerated " + n2 + " segments and split " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortSegments() {
        List list = this.downloadSegments;
        synchronized (list) {
            ListIterator listIterator = this.downloadSegments.listIterator();
            SWDownloadSegment sWDownloadSegment = null;
            while (listIterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                synchronized (sWDownloadSegment2) {
                    if (sWDownloadSegment.getTransferredDataSize() == sWDownloadSegment.getTransferDataSize()) {
                        sWDownloadSegment.rating = new PriorityRating(1000000L, 0L);
                    }
                }
            }
            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Unsorted segments look like this:\n" + this.downloadSegments);
            Collections.sort(this.downloadSegments, this.orderingObject);
            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Sorted segments look like this:\n" + this.downloadSegments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadSegment allocateSegment(SWDownloadWorker sWDownloadWorker, long l) {
        NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "allocateSegment() worker:" + sWDownloadWorker + ",size" + l);
        List list = this.downloadSegments;
        synchronized (list) {
            ListIterator listIterator = this.downloadSegments.listIterator();
            SWDownloadSegment sWDownloadSegment = null;
            while (listIterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                synchronized (sWDownloadSegment2) {
                    if (sWDownloadSegment.isAbleToBeAllocated()) {
                        if (this.fileSize != -1L && sWDownloadSegment.getTransferDataSizeLeft() > l) {
                            NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "Trying to split with s: " + sWDownloadSegment.getTransferredDataSize() + "-" + l + " for allocation.");
                            this.validateSegments();
                            sWDownloadSegment = this.splitDownloadSegment(listIterator, sWDownloadSegment.getTransferredDataSize(), l);
                            this.validateSegments();
                        }
                        SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment;
                        synchronized (sWDownloadSegment3) {
                            NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "Allocating worker " + sWDownloadWorker + " to segment: " + sWDownloadSegment);
                            sWDownloadSegment.setAllocatedByWorker(sWDownloadWorker);
                            return sWDownloadSegment;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadSegment allocateSegmentForRangeSet(SWDownloadWorker sWDownloadWorker, HTTPRangeSet hTTPRangeSet, long l) {
        NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "allocateSegmentForRangeSet() worker:" + sWDownloadWorker + ",size" + l);
        List list = this.downloadSegments;
        synchronized (list) {
            ListIterator listIterator = this.downloadSegments.listIterator();
            Iterator iterator = null;
            SWDownloadSegment sWDownloadSegment = null;
            while (listIterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                synchronized (sWDownloadSegment2) {
                    if (!sWDownloadSegment.isAbleToBeAllocated()) {
                        continue;
                    }
                    long l2 = sWDownloadSegment.getTransferStartPosition();
                    long l3 = sWDownloadSegment.getEndOffset();
                    if (!$assertionsDisabled && l3 == -1L) {
                        throw new AssertionError((Object)"Cant allocate segment for range set with unknown end.");
                    }
                    iterator = hTTPRangeSet.getIterator();
                    while (iterator.hasNext()) {
                        Range range = (Range)iterator.next();
                        long l4 = range.getStartOffset(this.fileSize);
                        long l5 = range.getEndOffset(this.fileSize);
                        if (l3 == l2 || l4 == l5 || l5 <= l2 || l4 >= l3) continue;
                        long l6 = Math.max(l4, l2);
                        long l7 = Math.min(l5, l3);
                        if (l2 != l6 || l3 != l7 || l7 - l6 > l) {
                            NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "Trying to split with s: " + l2 + "-" + l3 + ", r: " + l4 + "-" + l5 + " for allocation purposes");
                            this.validateSegments();
                            sWDownloadSegment = this.splitDownloadSegment(listIterator, l6 - l2, Math.min(l7 - l6, l));
                            this.validateSegments();
                        }
                        SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment;
                        synchronized (sWDownloadSegment3) {
                            NLogger.debug("DWNLD_ALLOCATE_SEGMENT", "Allocating worker " + sWDownloadWorker + " to segment for rangeset: " + sWDownloadSegment);
                            sWDownloadSegment.setAllocatedByWorker(sWDownloadWorker);
                            return sWDownloadSegment;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHijackSegment(HTTPRangeSet hTTPRangeSet, long l) {
        Object object;
        if (ServiceManager.sCfg.segmentHijacking != 1 || this.fileSize == -1L) {
            return false;
        }
        SWDownloadSegment sWDownloadSegment = null;
        if (l <= 0L) {
            return false;
        }
        if (this.status != 2) {
            return false;
        }
        Logger.logMessage(Logger.FINE, (short)2, "About to try to hijack a segment, speed=" + l);
        List list = this.downloadSegments;
        synchronized (list) {
            object = this.downloadSegments.listIterator();
            Iterator iterator = null;
            SWDownloadSegment sWDownloadSegment2 = null;
            long l2 = 0L;
            while (object.hasNext()) {
                SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment2 = (SWDownloadSegment)object.next();
                synchronized (sWDownloadSegment3) {
                    long l3;
                    long l4;
                    long l5 = sWDownloadSegment2.getTransferStartPosition();
                    long l6 = sWDownloadSegment2.getEndOffset();
                    if (!$assertionsDisabled && l6 == -1L) {
                        throw new AssertionError();
                    }
                    long l7 = (l6 - l5) / l;
                    if (sWDownloadSegment2.getTransferDataSizeLeft() < 1L) {
                        continue;
                    }
                    boolean bl = false;
                    if (hTTPRangeSet != null) {
                        iterator = hTTPRangeSet.getIterator();
                    } else {
                        bl = true;
                    }
                    while (hTTPRangeSet != null && !bl && iterator.hasNext()) {
                        Range range = (Range)iterator.next();
                        l4 = range.getStartOffset(this.fileSize);
                        l3 = range.getEndOffset(this.fileSize);
                        if (l4 > l5 || l3 < l6) continue;
                        bl = true;
                    }
                    if (!bl) {
                        continue;
                    }
                    if (sWDownloadSegment2.isAbleToBeAllocated()) {
                        return true;
                    }
                    l4 = 100L;
                    if (sWDownloadSegment2.getLongTermTransferRate() > 0) {
                        l4 = sWDownloadSegment2.getTransferDataSizeLeft() / (long)sWDownloadSegment2.getLongTermTransferRate();
                    }
                    l3 = sWDownloadSegment2.getLongTermTransferRate();
                    Logger.logMessage(Logger.FINER, (short)2, "etr: " + l4 + ", cS: " + l3);
                    if (l4 <= l2) {
                        continue;
                    }
                    if ((double)l >= 2.0 * (double)l3 && l4 > 5L) {
                        l2 = l4;
                        sWDownloadSegment = sWDownloadSegment2;
                    }
                }
            }
        }
        if (sWDownloadSegment == null) {
            return false;
        }
        list = sWDownloadSegment;
        synchronized (list) {
            Logger.logMessage(Logger.FINE, (short)2, "Freeing: " + sWDownloadSegment);
            if (!sWDownloadSegment.isAbleToBeAllocated() && (object = sWDownloadSegment.getAllocatedByWorker()) != null) {
                ((SWDownloadWorker)object).stopWorker();
                ((SWDownloadWorker)object).stopDownload();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeSegments() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        SWDownloadSegment sWDownloadSegment = null;
        NLogger.debug("DWNLD_SEG_MERGING_SORTING", "About to check for possible segment merging.");
        List list = this.downloadSegments;
        synchronized (list) {
            if (this.downloadSegments.size() == 0) {
                return;
            }
            ListIterator listIterator = this.downloadSegments.listIterator();
            if (listIterator.hasNext()) {
                sWDownloadSegment = (SWDownloadSegment)listIterator.next();
            }
            while (listIterator.hasNext()) {
                this.validateSegments();
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment;
                sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment2;
                synchronized (sWDownloadSegment3) {
                    SWDownloadSegment sWDownloadSegment4 = sWDownloadSegment;
                    synchronized (sWDownloadSegment4) {
                        if (sWDownloadSegment2.getNextDownloadSegment() == null) {
                            continue;
                        }
                        NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Performing merge cycle on\n\t" + sWDownloadSegment2 + " and\n\t" + sWDownloadSegment);
                        if (sWDownloadSegment2.getAllocatedByWorker() != null) {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Rejecting this, as the first segment is busy.");
                            continue;
                        }
                        if (sWDownloadSegment2.getTransferredDataSize() > 0L && sWDownloadSegment2.getTransferDataSizeLeft() > 0L) {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "current segment should be split, as it's not being used and it's incomplete:" + sWDownloadSegment2);
                            listIterator.previous();
                            this.validateSegments();
                            sWDownloadSegment2 = this.splitDownloadSegment(listIterator, sWDownloadSegment2.getTransferredDataSize(), sWDownloadSegment2.getTransferDataSizeLeft());
                            this.validateSegments();
                            sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "current segment is now:" + sWDownloadSegment2);
                        }
                        if (sWDownloadSegment != sWDownloadSegment2.getNextDownloadSegment()) {
                            continue;
                        }
                        if (sWDownloadSegment.getStartOffset() != sWDownloadSegment2.getEndOffset()) {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Rejecting this, as the second segment doesn't touch the first segment.");
                            continue;
                        }
                        if (sWDownloadSegment.getAllocatedByWorker() != null) {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Rejecting this, as the second segment is busy.");
                            continue;
                        }
                        if (sWDownloadSegment.getTransferredDataSize() > 0L && sWDownloadSegment.getTransferDataSizeLeft() > 0L) {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Second segment is partially complete, so need to split before we can evaluate.");
                            this.validateSegments();
                            this.splitDownloadSegment(listIterator, sWDownloadSegment.getTransferredDataSize(), sWDownloadSegment.getTransferDataSizeLeft());
                            this.validateSegments();
                            while ((SWDownloadSegment)listIterator.previous() != sWDownloadSegment2) {
                            }
                            listIterator.next();
                            sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "and the next segment - after a split - is now:" + sWDownloadSegment2);
                        }
                        if (sWDownloadSegment2.getTransferredDataSize() == 0L && sWDownloadSegment.getTransferredDataSize() == 0L && ((Object)sWDownloadSegment2.getRating()).equals(sWDownloadSegment.getRating()) || sWDownloadSegment2.getTransferDataSizeLeft() == 0L && sWDownloadSegment.getTransferDataSizeLeft() == 0L) {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Merging " + sWDownloadSegment2 + " with " + sWDownloadSegment);
                            this.validateSegments();
                            if (sWDownloadSegment2.getTransferDataSizeLeft() == 0L && sWDownloadSegment.getTransferDataSizeLeft() == 0L) {
                                try {
                                    FileUtils.truncateFile(sWDownloadSegment2.getIncompleteFile(), sWDownloadSegment2.getTransferDataSize());
                                    FileUtils.appendFile(sWDownloadSegment2.getIncompleteFile(), sWDownloadSegment.getIncompleteFile());
                                }
                                catch (IOException iOException) {
                                    Logger.logWarning(iOException);
                                }
                            }
                            sWDownloadSegment2.mergeWithNextSegment();
                            listIterator.remove();
                            listIterator.previous();
                            sWDownloadSegment = (SWDownloadSegment)listIterator.next();
                            ++n;
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Merged completed segment: " + sWDownloadSegment2);
                        } else {
                            NLogger.debug("DWNLD_SEG_MERGING_SORTING", "Rejected at final check: segments need to be both full or both empty.");
                        }
                    }
                }
            }
        }
        if (n > 0) {
            NLogger.info("DWNLD_SEG_MERGING_SORTING", "Performed " + n + " merges for " + this.destinationFile);
        }
        this.logDownloadSegments();
        SwarmingManager.getInstance().notifyDownloadListChange();
    }

    private SWDownloadSegment splitDownloadSegment(ListIterator listIterator, long l, long l2) {
        long l3;
        long l4;
        SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)listIterator.previous();
        if (!Thread.holdsLock(this.downloadSegments)) {
            throw new Error("This downloadSegments object is not locked by the thread about to perform a split");
        }
        if (!Thread.holdsLock(sWDownloadSegment)) {
            throw new Error("This segment is not locked by the thread about to perform a split");
        }
        listIterator.next();
        long l5 = sWDownloadSegment.getTransferDataSize();
        Logger.logMessage(Logger.FINER, (short)2, "Splitting segment " + sWDownloadSegment + " at offset " + l + ", length " + l2);
        if (l < 0L || l2 <= 0L || l5 == -1L || l + l2 > l5) {
            throw new IndexOutOfBoundsException("DownloadSegment Size: " + l5 + ", Offset: " + l + ", Length: " + l2);
        }
        if (l == 0L && l2 == l5) {
            return sWDownloadSegment;
        }
        long l6 = sWDownloadSegment.getStartOffset();
        long l7 = sWDownloadSegment.getEndOffset();
        SWDownloadSegment sWDownloadSegment2 = null;
        if (l == 0L) {
            sWDownloadSegment2 = sWDownloadSegment;
            sWDownloadSegment.setTransferDataSize(l2);
            l4 = l6 + l2;
            l3 = l7 - l4;
        } else {
            sWDownloadSegment.setTransferDataSize(l);
            l4 = l6 + l;
            l3 = l2;
        }
        SWDownloadSegment sWDownloadSegment3 = new SWDownloadSegment(this, this.nextSegmentNumber, l4, l3);
        sWDownloadSegment3.rating = sWDownloadSegment.rating;
        ++this.nextSegmentNumber;
        SWDownloadSegment sWDownloadSegment4 = sWDownloadSegment.getNextDownloadSegment();
        sWDownloadSegment3.setNextDownloadSegment(sWDownloadSegment4);
        sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment3);
        listIterator.add(sWDownloadSegment3);
        this.fireDownloadSegmentAdded(listIterator.previousIndex());
        if (sWDownloadSegment2 == null) {
            sWDownloadSegment2 = sWDownloadSegment3;
        }
        SWDownloadSegment sWDownloadSegment5 = null;
        long l8 = l4 + l3;
        if (l8 < l7) {
            sWDownloadSegment5 = new SWDownloadSegment(this, this.nextSegmentNumber, l8, l7 - l8);
            sWDownloadSegment5.rating = sWDownloadSegment.rating;
            ++this.nextSegmentNumber;
            sWDownloadSegment4 = sWDownloadSegment3.getNextDownloadSegment();
            sWDownloadSegment5.setNextDownloadSegment(sWDownloadSegment4);
            sWDownloadSegment3.setNextDownloadSegment(sWDownloadSegment5);
            listIterator.add(sWDownloadSegment5);
            this.fireDownloadSegmentAdded(listIterator.previousIndex());
        }
        this.logDownloadSegments();
        Logger.logMessage(Logger.FINE, (short)2, "Split segment: " + sWDownloadSegment + " - New Segment: " + sWDownloadSegment3 + " - End Segment: " + sWDownloadSegment5);
        SwarmingManager.getInstance().notifyDownloadListChange();
        return sWDownloadSegment2;
    }

    private void initAltLocContainers() {
        this.goodAltLocContainer = new AlternateLocationContainer(this.fileURN);
        this.badAltLocContainer = new AlternateLocationContainer(this.fileURN);
    }

    private void createDownloadSegments() {
        this.nextSegmentNumber = 0;
        this.downloadSegments = new ArrayList();
        SWDownloadSegment sWDownloadSegment = new SWDownloadSegment(this, this.nextSegmentNumber, 0L, this.fileSize);
        this.downloadSegments.add(sWDownloadSegment);
        ++this.nextSegmentNumber;
        this.logDownloadSegments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XJBSWDownloadFile createXJBSWDownloadFile() throws JAXBException {
        Object object;
        SWDownloadConstants sWDownloadConstants;
        Object object2;
        Object object3;
        ObjectFactory objectFactory = new ObjectFactory();
        XJBSWDownloadFile xJBSWDownloadFile = objectFactory.createXJBSWDownloadFile();
        xJBSWDownloadFile.setLocalFileName(this.destinationFile.getName());
        xJBSWDownloadFile.setFileSize(this.fileSize);
        xJBSWDownloadFile.setSearchTerm(this.researchSetting.getSearchTerm());
        xJBSWDownloadFile.setCreatedTime(this.createdDate.getTime());
        xJBSWDownloadFile.setModifiedTime(this.modifiedDate.getTime());
        if (this.fileURN != null) {
            xJBSWDownloadFile.setFileURN(this.fileURN.getAsString());
        }
        xJBSWDownloadFile.setStatus(this.status);
        Object object4 = this.candidatesLock;
        synchronized (object4) {
            object3 = xJBSWDownloadFile.getCandidateList();
            object2 = this.goodCandidatesList.iterator();
            while (object2.hasNext()) {
                sWDownloadConstants = (SWDownloadCandidate)object2.next();
                object = ((SWDownloadCandidate)sWDownloadConstants).createXJBSWDownloadCandidate();
                object3.add(object);
            }
            object2 = this.badCandidatesList.iterator();
            while (object2.hasNext()) {
                sWDownloadConstants = (SWDownloadCandidate)object2.next();
                if (((SWDownloadCandidate)sWDownloadConstants).getStatus() == 10) continue;
                object = ((SWDownloadCandidate)sWDownloadConstants).createXJBSWDownloadCandidate();
                object3.add(object);
            }
        }
        object4 = this.downloadSegments;
        synchronized (object4) {
            object3 = this.downloadSegments.iterator();
            object2 = xJBSWDownloadFile.getSegmentList();
            while (object3.hasNext()) {
                sWDownloadConstants = (SWDownloadSegment)object3.next();
                object = sWDownloadConstants;
                synchronized (object) {
                    XJBSWDownloadSegment xJBSWDownloadSegment = ((SWDownloadSegment)sWDownloadConstants).createXJBSWDownloadSegment();
                    object2.add(xJBSWDownloadSegment);
                }
            }
        }
        return xJBSWDownloadFile;
    }

    private void createDownloadSegments(XJBSWDownloadFile xJBSWDownloadFile) {
        this.downloadSegments = new ArrayList();
        SWDownloadSegment sWDownloadSegment = null;
        this.nextSegmentNumber = 0;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = xJBSWDownloadFile.getSegmentList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Collections.sort(arrayList, new SWDownloadSegmentComparatorByStartPosition());
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)iterator.next();
            SWDownloadSegment sWDownloadSegment2 = new SWDownloadSegment(this, xJBSWDownloadSegment);
            this.downloadSegments.add(sWDownloadSegment2);
            if (sWDownloadSegment != null) {
                sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment2);
            }
            this.nextSegmentNumber = Math.max(xJBSWDownloadSegment.getSegmentNumber() + 1, this.nextSegmentNumber);
            sWDownloadSegment = sWDownloadSegment2;
        }
        ++this.nextSegmentNumber;
        this.logDownloadSegments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDownloadCandidates(XJBSWDownloadFile xJBSWDownloadFile) {
        Object object = this.candidatesLock;
        synchronized (object) {
            this.allCandidatesList.clear();
            this.goodCandidatesList.clear();
            this.badCandidatesList.clear();
            Iterator iterator = xJBSWDownloadFile.getCandidateList().iterator();
            while (iterator.hasNext()) {
                try {
                    XJBSWDownloadCandidate xJBSWDownloadCandidate = (XJBSWDownloadCandidate)iterator.next();
                    SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(xJBSWDownloadCandidate, this);
                    NLogger.debug("DOWNLOAD", "Adding download candidate " + sWDownloadCandidate);
                    int n = this.allCandidatesList.size();
                    this.allCandidatesList.add(n, sWDownloadCandidate);
                    this.fireDownloadCandidateAdded(n);
                    if (xJBSWDownloadCandidate.getConnectionFailedRepetition() >= 3) {
                        this.badCandidatesList.add(sWDownloadCandidate);
                        continue;
                    }
                    this.goodCandidatesList.add(sWDownloadCandidate);
                }
                catch (MalformedHostAddressException malformedHostAddressException) {
                    NLogger.warn("DOWNLOAD", malformedHostAddressException, malformedHostAddressException);
                }
                catch (URIException uRIException) {
                    NLogger.warn("DOWNLOAD", uRIException, uRIException);
                }
                catch (Exception exception) {
                    NLogger.error("DOWNLOAD", "Error loading a download candidate from XML.", exception);
                }
            }
        }
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    private void logDownloadSegments() {
    }

    public void addDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.add(DownloadCandidatesChangeListener.class, downloadCandidatesChangeListener);
    }

    public void removeDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.remove(DownloadCandidatesChangeListener.class, downloadCandidatesChangeListener);
    }

    private void fireDownloadCandidateChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[i];
                    downloadCandidatesChangeListener.downloadCandidateChanged(n);
                }
            }
        });
    }

    private void fireDownloadCandidateAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[i];
                    downloadCandidatesChangeListener.downloadCandidateAdded(n);
                }
            }
        });
    }

    private void fireDownloadCandidateRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[i];
                    downloadCandidatesChangeListener.downloadCandidateRemoved(n);
                }
            }
        });
    }

    public void fireDownloadCandidateChanged(SWDownloadCandidate sWDownloadCandidate) {
        int n = this.allCandidatesList.indexOf(sWDownloadCandidate);
        if (n >= 0) {
            this.fireDownloadCandidateChanged(n);
        }
    }

    public void addDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.add(DownloadSegmentsChangeListener.class, downloadSegmentsChangeListener);
    }

    public void removeDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.remove(DownloadSegmentsChangeListener.class, downloadSegmentsChangeListener);
    }

    private void fireDownloadSegmentChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[i];
                    downloadSegmentsChangeListener.downloadSegmentChanged(n);
                }
            }
        });
    }

    private void fireDownloadSegmentAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[i];
                    downloadSegmentsChangeListener.downloadSegmentAdded(n);
                }
            }
        });
    }

    private void fireDownloadSegmentRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[i];
                    downloadSegmentsChangeListener.downloadSegmentRemoved(n);
                }
            }
        });
    }

    public void fireDownloadSegmentChanged(SWDownloadSegment sWDownloadSegment) {
        int n = this.downloadSegments.indexOf(sWDownloadSegment);
        if (n >= 0) {
            this.fireDownloadSegmentChanged(n);
        }
    }

    static {
        $assertionsDisabled = !SWDownloadFile.class.desiredAssertionStatus();
    }

    private static class SWDownloadSegmentComparatorByRating
    implements Comparator {
        private long previewLength;

        SWDownloadSegmentComparatorByRating(long l) {
            this.previewLength = l;
        }

        public int compare(Object object, Object object2) {
            long l;
            SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)object;
            SWDownloadSegment sWDownloadSegment2 = (SWDownloadSegment)object2;
            long l2 = sWDownloadSegment.rating.getValue();
            long l3 = l2 - (l = sWDownloadSegment2.rating.getValue());
            if (l3 == 0L || sWDownloadSegment.getTransferDataSizeLeft() == 0L || sWDownloadSegment2.getTransferDataSizeLeft() == 0L || sWDownloadSegment.getStartOffset() < this.previewLength || sWDownloadSegment2.getStartOffset() < this.previewLength) {
                l3 = sWDownloadSegment.getStartOffset() - sWDownloadSegment2.getStartOffset();
            }
            if (l3 < 0L) {
                return -1;
            }
            if (l3 > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class SWDownloadSegmentComparatorByPosition
    implements Comparator {
        private SWDownloadSegmentComparatorByPosition() {
        }

        public int compare(Object object, Object object2) {
            SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)object;
            SWDownloadSegment sWDownloadSegment2 = (SWDownloadSegment)object2;
            long l = sWDownloadSegment.getStartOffset() - sWDownloadSegment2.getStartOffset();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class SWDownloadSegmentComparatorByStartPosition
    implements Comparator {
        private SWDownloadSegmentComparatorByStartPosition() {
        }

        public int compare(Object object, Object object2) {
            XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)object;
            XJBSWDownloadSegment xJBSWDownloadSegment2 = (XJBSWDownloadSegment)object2;
            long l = xJBSWDownloadSegment.getStartPosition() - xJBSWDownloadSegment2.getStartPosition();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

