/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.utils.Localizer;
import phex.utils.StrUtil;

public final class SWDownloadInfo
implements SWDownloadConstants {
    private SWDownloadInfo() {
    }

    public static String getDownloadFileStatusString(int n) {
        switch (n) {
            case 1: {
                return Localizer.getString("WaitingForDownload");
            }
            case 2: {
                return Localizer.getString("Downloading");
            }
            case 3: 
            case 6: {
                return Localizer.getString("Completed");
            }
            case 4: {
                return Localizer.getString("Stopped");
            }
            case 5: {
                return Localizer.getString("FileQueued");
            }
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return Localizer.getFormatedString("UnrecognizedStatus", objectArray);
    }

    public static String getDownloadCandidateStatusString(SWDownloadCandidate sWDownloadCandidate) {
        short s = sWDownloadCandidate.getStatus();
        switch (s) {
            case 10: {
                return Localizer.getString("CandidateIgnored");
            }
            case 11: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L), StrUtil.convertSecondsToTime((int)(sWDownloadCandidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("CandidateOffline", objectArray);
            }
            case 12: {
                return Localizer.getString("WaitingForDownload");
            }
            case 14: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L), StrUtil.convertSecondsToTime((int)(sWDownloadCandidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("HostBusy", objectArray);
            }
            case 16: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("Connecting", objectArray);
            }
            case 15: {
                Object[] objectArray = new Object[]{StrUtil.convertSecondsToTime((int)(sWDownloadCandidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("RangeUnavailable", objectArray);
            }
            case 18: {
                Object[] objectArray = new Object[3];
                objectArray[0] = sWDownloadCandidate.getXQueueParameters().getPosition();
                objectArray[1] = StrUtil.convertSecondsToTime((int)(sWDownloadCandidate.getStatusTimeLeft() / 1000L));
                return Localizer.getFormatedString("RemotlyQueued", objectArray);
            }
            case 13: {
                Object[] objectArray = new Object[]{new Integer(sWDownloadCandidate.getFailedConnectionTries()), new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L), StrUtil.convertSecondsToTime((int)(sWDownloadCandidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("ConnectionFailed", objectArray);
            }
            case 17: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("PushRequest", objectArray);
            }
            case 19: {
                return Localizer.getFormatedString("Requesting", null);
            }
            case 20: {
                return Localizer.getFormatedString("Downloading", null);
            }
        }
        Object[] objectArray = new Object[]{new Integer(s)};
        return Localizer.getFormatedString("UnrecognizedStatus", objectArray);
    }
}

