/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.utils.NLogger;

public class SWDownloadSet {
    private SWDownloadFile downloadFile;
    private SWDownloadSegment downloadSegment;
    private SWDownloadCandidate downloadCandidate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SWDownloadSet(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) {
        this.downloadFile = sWDownloadFile;
        this.downloadCandidate = sWDownloadCandidate;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public SWDownloadCandidate getDownloadCandidate() {
        return this.downloadCandidate;
    }

    public SWDownloadSegment allocateDownloadSegment(SWDownloadWorker sWDownloadWorker) {
        NLogger.debug("DOWNLOAD_SET", "Allocate segment for: " + sWDownloadWorker + " on set " + this);
        if (this.downloadSegment == null) {
            this.downloadSegment = this.downloadFile.allocateDownloadSegment(sWDownloadWorker, this.downloadCandidate.getAvailableRangeSet(), this.downloadCandidate.getPreferredSegmentSize(), this.downloadCandidate.getSpeed());
            if (this.downloadSegment != null) {
                this.downloadCandidate.associateDownloadSegment(this.downloadSegment);
            }
        }
        if (this.downloadSegment == null) {
            return null;
        }
        NLogger.debug("DOWNLOAD_SET", "Allocated segment: " + this.downloadSegment + " on set " + this);
        if (!$assertionsDisabled && this.downloadSegment.getAllocatedByWorker() != sWDownloadWorker) {
            throw new AssertionError((Object)"Worker does not match allocated worker of download segment.");
        }
        return this.downloadSegment;
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            NLogger.debug("DOWNLOAD_SET", "Release file download segment: " + this.downloadSegment + " on set " + this);
            this.downloadFile.releaseDownloadSegment(this.downloadSegment);
            this.downloadSegment = null;
        }
        NLogger.debug("DOWNLOAD_SET", "Release candidate download segment on set " + this);
        this.downloadCandidate.releaseDownloadSegment();
    }

    public void releaseDownloadSet() {
        NLogger.debug("DOWNLOAD_SET", "Release download set on set " + this);
        if (this.downloadSegment != null) {
            this.downloadFile.releaseDownloadSegment(this.downloadSegment);
        }
        this.downloadCandidate.releaseDownloadSegment();
        this.downloadFile.releaseDownloadCandidate(this.downloadCandidate);
        this.downloadFile.decrementWorkerCount();
    }

    public String toString() {
        return "[DownloadSet@" + Integer.toHexString(this.hashCode()) + ": (Segment: " + this.downloadSegment + " - Candidate: " + this.downloadCandidate + " - File: " + this.downloadFile + ")]";
    }

    static {
        $assertionsDisabled = !SWDownloadSet.class.desiredAssertionStatus();
    }
}

