/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.download.DownloadEngine;
import phex.download.HostBusyException;
import phex.download.PushHandler;
import phex.download.RangeUnavailableException;
import phex.download.RemotelyQueuedException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SwarmingManager;
import phex.host.UnusableHostException;
import phex.http.HTTPMessageException;
import phex.utils.Logger;
import phex.utils.NLogger;

public class SWDownloadWorker
implements Runnable {
    private boolean isTemporaryWorker;
    private boolean isRunning;
    private DownloadEngine downloadEngine;
    private boolean cleanUp = true;

    public void setTemporaryWorker(boolean bl) {
        this.isTemporaryWorker = bl;
    }

    public boolean isTemporaryWorker() {
        return this.isTemporaryWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        try {
            if (this.isTemporaryWorker) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            while (this.isRunning) {
                boolean bl = swarmingManager.checkToStopWorker(this);
                if (bl) {
                    break;
                }
                NLogger.debug("DOWNLOAD_WORKER", " - Allocating DownloadSet - " + this);
                SWDownloadSet sWDownloadSet = swarmingManager.allocateDownloadSet(this);
                if (sWDownloadSet == null) {
                    if (this.isTemporaryWorker) {
                        swarmingManager.waitForNotify();
                        continue;
                    }
                    break;
                }
                NLogger.debug("DOWNLOAD_WORKER", "Allocated DownloadSet: " + sWDownloadSet.toString() + " - " + this);
                try {
                    this.handleDownload(sWDownloadSet);
                }
                finally {
                    if (sWDownloadSet == null) continue;
                    NLogger.debug("DOWNLOAD_WORKER", "Releasing DownloadSet: " + sWDownloadSet.toString() + " - " + this);
                    sWDownloadSet.releaseDownloadSet();
                }
            }
        }
        finally {
            if (this.isRunning) {
                swarmingManager.notifyWorkerShoutdown(this);
            }
            NLogger.debug("DOWNLOAD_WORKER", "Download worker finished: " + this);
        }
    }

    public void startWorker() {
        this.isRunning = true;
        ThreadPool.getInstance().addJob(this, "SWDownloadWorker-" + Integer.toHexString(this.hashCode()));
        NLogger.debug("DOWNLOAD_WORKER", "Started SWDownloadWorker " + this);
    }

    public void stopWorker() {
        NLogger.debug("DOWNLOAD_WORKER", "Download worker has been instructed to stop running: " + this);
        this.cleanUp = false;
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stopDownload() {
        NLogger.debug("DOWNLOAD_WORKER", "Download worker has been instructed to stop downloading: " + this);
        if (this.downloadEngine != null) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(SWDownloadSet sWDownloadSet) {
        NLogger.debug("DOWNLOAD_WORKER", "handleDownload() with: " + sWDownloadSet + " - " + this);
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        if (sWDownloadCandidate.getResourceURN() == null && sWDownloadCandidate.getFileIndex() < 0L) {
            NLogger.warn("DOWNLOAD_WORKER", "Download candidate has no associated file and URN is null:" + sWDownloadCandidate);
            return;
        }
        if (sWDownloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(sWDownloadSet);
        } else {
            this.connectDownloadEngine(sWDownloadSet);
        }
        if (this.downloadEngine == null) {
            return;
        }
        try {
            this.startDownload(sWDownloadSet);
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)12);
            Logger.logMessage(Logger.FINE, (short)128, iOException);
            Logger.logMessage(Logger.FINE, (short)128, sWDownloadCandidate);
        }
        finally {
            this.stopDownload();
            NLogger.debug("DOWNLOAD_WORKER", "Releasing DownloadSegment: " + sWDownloadSet.toString() + " - " + this);
            sWDownloadSet.releaseDownloadSegment();
            if (this.cleanUp) {
                sWDownloadFile.sortSegments();
                sWDownloadFile.mergeSegments();
            }
            sWDownloadFile.verifyStatus();
            if (sWDownloadFile.isFileCompleted()) {
                sWDownloadFile.moveToDestinationFile();
            }
        }
    }

    private void connectDownloadEngine(SWDownloadSet sWDownloadSet) {
        NLogger.debug("DOWNLOAD_WORKER", "connectDownloadEngine with: " + sWDownloadSet + " - " + this);
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        sWDownloadCandidate.setStatus((short)16);
        this.downloadEngine = null;
        this.downloadEngine = new DownloadEngine(sWDownloadFile, sWDownloadCandidate);
        try {
            this.downloadEngine.connect(ServiceManager.sCfg.socketConnectTimeout);
        }
        catch (ConnectionFailedException connectionFailedException) {
            Logger.logMessage(Logger.FINEST, (short)128, connectionFailedException.toString());
            this.connectDownloadEngineViaPush(sWDownloadSet);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Logger.logMessage(Logger.FINEST, (short)128, socketTimeoutException.toString());
            this.connectDownloadEngineViaPush(sWDownloadSet);
            return;
        }
        catch (IOException iOException) {
            if (this.downloadEngine != null) {
                this.downloadEngine.stopDownload();
                this.downloadEngine = null;
            }
            this.connectDownloadEngineViaPush(sWDownloadSet);
            Logger.logMessage(Logger.SEVERE, (short)128, iOException, (Object)("Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor()));
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadSet sWDownloadSet) {
        NLogger.debug("DOWNLOAD_WORKER", "connectDownloadEngineViaPush with: " + sWDownloadSet + " - " + this);
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        this.downloadEngine = null;
        if (!(NetworkManager.getInstance().hasConnectedIncoming() || ServiceManager.sCfg.connectedToLAN && !sWDownloadCandidate.getHostAddress().isPrivateIP())) {
            Logger.logMessage(Logger.FINEST, (short)128, this.toString() + sWDownloadCandidate.toString() + " Cant PUSH->me.isFirewalled||(!me.connectedToLAN&&candidate.isPrivateIP)");
            sWDownloadCandidate.setStatus((short)13);
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.markCandidateBad(sWDownloadCandidate, true);
            }
            return;
        }
        sWDownloadCandidate.setStatus((short)17);
        Socket socket = PushHandler.requestSocketViaPush(sWDownloadCandidate);
        if (socket == null) {
            sWDownloadCandidate.setStatus((short)13);
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.markCandidateBad(sWDownloadCandidate, true);
            }
            Logger.logMessage(Logger.FINE, (short)128, "Push request fails for candidate: " + sWDownloadCandidate);
            return;
        }
        this.downloadEngine = new DownloadEngine(socket, sWDownloadFile, sWDownloadCandidate);
        try {
            this.downloadEngine.connect(ServiceManager.sCfg.socketConnectTimeout);
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)13);
            Logger.logMessage(Logger.SEVERE, (short)128, iOException, (Object)("Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor()));
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            return;
        }
    }

    private void exchangeHTTPHandshake(SWDownloadSet sWDownloadSet) {
        NLogger.debug("DOWNLOAD_WORKER", "exchangeHTTPHandshake with: " + sWDownloadSet + " - " + this);
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        try {
            sWDownloadCandidate.setStatus((short)19);
            SWDownloadSegment sWDownloadSegment = sWDownloadSet.allocateDownloadSegment(this);
            if (sWDownloadSegment == null) {
                Logger.logMessage(Logger.FINE, (short)128, "No segment to allocate found");
                sWDownloadCandidate.setStatus((short)12);
                this.downloadEngine = null;
                return;
            }
            this.downloadEngine.exchangeHTTPHandshake(sWDownloadSegment);
        }
        catch (RemotelyQueuedException remotelyQueuedException) {
            NLogger.debug("DOWNLOAD_WORKER", "Releasing DownloadSegment (Queued): " + sWDownloadSet.toString() + " - " + this);
            sWDownloadSet.releaseDownloadSegment();
            sWDownloadCandidate.updateXQueueParameters(remotelyQueuedException.getXQueueParameters());
            sWDownloadCandidate.setStatus((short)18);
        }
        catch (RangeUnavailableException rangeUnavailableException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            sWDownloadCandidate.setStatus((short)15);
            Logger.logMessage(Logger.FINEST, (short)128, rangeUnavailableException);
            return;
        }
        catch (HostBusyException hostBusyException) {
            Logger.logMessage(Logger.FINEST, (short)128, sWDownloadCandidate + " " + hostBusyException.getMessage());
            if (this.downloadEngine != null) {
                this.downloadEngine.stopDownload();
                this.downloadEngine = null;
            }
            sWDownloadCandidate.setStatus((short)14, hostBusyException.getWaitTimeInSeconds());
            return;
        }
        catch (UnusableHostException unusableHostException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            Logger.logMessage(Logger.FINE, (short)128, unusableHostException);
            Logger.logMessage(Logger.FINE, (short)128, "Removing download candidate: " + sWDownloadCandidate);
            sWDownloadFile.markCandidateBad(sWDownloadCandidate, true);
            sWDownloadFile.addBadAltLoc(sWDownloadCandidate);
            return;
        }
        catch (HTTPMessageException hTTPMessageException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            Logger.logMessage(Logger.WARNING, (short)128, hTTPMessageException);
            sWDownloadFile.markCandidateBad(sWDownloadCandidate, true);
            sWDownloadFile.addBadAltLoc(sWDownloadCandidate);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Logger.logMessage(Logger.FINE, (short)128, socketTimeoutException);
            sWDownloadCandidate.setStatus((short)13);
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            return;
        }
        catch (SocketException socketException) {
            Logger.logMessage(Logger.FINE, (short)128, socketException);
            sWDownloadCandidate.setStatus((short)13);
            if (this.downloadEngine != null) {
                this.downloadEngine.stopDownload();
                this.downloadEngine = null;
            }
            return;
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)13);
            Logger.logMessage(Logger.WARNING, (short)128, iOException, (Object)("Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor()));
            if (this.downloadEngine == null) {
                Thread.dumpStack();
                Logger.logError((short)128, "DownloadEngine is null, why??" + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor());
            }
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            return;
        }
    }

    private void startDownload(SWDownloadSet sWDownloadSet) throws IOException {
        NLogger.debug("DOWNLOAD_WORKER", "startDownload with: " + sWDownloadSet + " - " + this);
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        sWDownloadFile.addGoodAltLoc(sWDownloadCandidate);
        sWDownloadFile.markCandidateGood(sWDownloadCandidate);
        while (true) {
            this.exchangeHTTPHandshake(sWDownloadSet);
            if (this.downloadEngine == null) {
                return;
            }
            if (sWDownloadCandidate.isRemotlyQueued()) {
                try {
                    Thread.sleep(sWDownloadCandidate.getXQueueParameters().getRequestSleepTime());
                    if (this.downloadEngine == null) {
                        Logger.logMessage(Logger.FINE, (short)128, "Download stopped while waiting for queue.");
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.logMessage(Logger.FINE, (short)128, "Interrupted Worker sleeping for queue.");
                    sWDownloadCandidate.setStatus((short)13);
                    this.downloadEngine.stopDownload();
                    this.downloadEngine = null;
                    return;
                }
            }
            if (sWDownloadCandidate.isRemotlyQueued()) continue;
            sWDownloadFile.setStatus((short)2);
            sWDownloadSet.getDownloadCandidate().setStatus((short)20);
            SWDownloadSegment sWDownloadSegment = sWDownloadSet.getDownloadSegment();
            File file = sWDownloadSegment.getIncompleteFile();
            this.downloadEngine.startDownload(file);
            Logger.logMessage(Logger.FINE, (short)128, "Completed a segment which started at " + sWDownloadSegment.getStartOffset() + " and was downloaded at a rate of " + sWDownloadSegment.getLongTermTransferRate());
            NLogger.debug("DOWNLOAD_WORKER", "Releasing DownloadSegment (completed): " + sWDownloadSet.toString() + " - " + this);
            sWDownloadSet.releaseDownloadSegment();
            sWDownloadFile.mergeSegments();
            if (!this.isRunning || !this.downloadEngine.isAcceptingNextSegment() || sWDownloadFile.isFull()) break;
        }
        sWDownloadCandidate.setStatus((short)12);
    }

    public String toString() {
        return "[SWDownloadWorker@" + Integer.toHexString(this.hashCode()) + ":running:" + this.isRunning + ",tempWorker:" + this.isTemporaryWorker + ",engine:" + this.downloadEngine + "]";
    }
}

