/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.ThreadTracking;
import phex.common.TransferRateService;
import phex.common.URN;
import phex.common.bandwidth.BandwidthManager;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadFilesChangeListener;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBPhex;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadList;
import phex.xml.XMLBuilder;

public class SwarmingManager
implements Manager {
    public static final short PRIORITY_MOVE_TO_TOP = 0;
    public static final short PRIORITY_MOVE_UP = 1;
    public static final short PRIORITY_MOVE_DOWN = 2;
    public static final short PRIORITY_MOVE_TO_BOTTOM = 3;
    private short workerCount;
    private ArrayList downloadList;
    private HashMap urnToDownloadMap;
    private TransferRateService transferRateService;
    private IPCounter ipDownloadCounter;
    private SWDownloadWorker temporaryWorker;
    private static Object saveDownloadListLock = new Object();
    private SaveDownloadListJob saveDownloadListJob;
    private boolean downloadListChangedSinceSave = false;
    private static SwarmingManager instance;
    private ArrayList listenerList = new ArrayList(2);

    private SwarmingManager() {
    }

    public static SwarmingManager getInstance() {
        if (instance == null) {
            instance = new SwarmingManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.workerCount = 0;
        this.downloadList = new ArrayList(5);
        this.urnToDownloadMap = new HashMap();
        this.transferRateService = BandwidthManager.getInstance().getTransferRateService();
        this.ipDownloadCounter = new IPCounter(ServiceManager.sCfg.maxDownloadsPerIP);
        return true;
    }

    public boolean onPostInitialization() {
        LoadDownloadListJob loadDownloadListJob = new LoadDownloadListJob();
        loadDownloadListJob.start();
        return true;
    }

    public void startupCompletedNotify() {
        this.createRequiredWorker();
        Environment.getInstance().scheduleTimerTask(new SaveDownloadListTimer(), 20000L, 20000L);
        Environment.getInstance().scheduleTimerTask(new RangePriorityRefreshTimer(), 15000L, 15000L);
    }

    public void shutdown() {
        this.forceSaveDownloadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(RemoteFile remoteFile, String string, String string2) {
        int n;
        SWDownloadFile sWDownloadFile = new SWDownloadFile(string, string2, remoteFile.getFileSize(), remoteFile.getURN());
        sWDownloadFile.addDownloadCandidate(remoteFile);
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            n = this.downloadList.size();
            this.downloadList.add(n, sWDownloadFile);
            URN uRN = sWDownloadFile.getFileURN();
            if (uRN != null) {
                this.urnToDownloadMap.put(uRN, sWDownloadFile);
            }
        }
        this.fireDownloadFileAdded(n);
        sWDownloadFile.setStatus((short)1);
        this.createRequiredWorker();
        this.triggerSaveDownloadList();
        return sWDownloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(URI uRI) throws URIException {
        int n;
        if (NLogger.isDebugEnabled("DOWNLOAD_MANAGER")) {
            NLogger.debug("DOWNLOAD_MANAGER", "Adding new download by URI: " + uRI.toString());
        }
        SWDownloadFile sWDownloadFile = new SWDownloadFile(uRI);
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            n = this.downloadList.size();
            this.downloadList.add(n, sWDownloadFile);
            URN uRN = sWDownloadFile.getFileURN();
            if (uRN != null) {
                this.urnToDownloadMap.put(uRN, sWDownloadFile);
            }
        }
        this.fireDownloadFileAdded(n);
        sWDownloadFile.setStatus((short)1);
        this.createRequiredWorker();
        this.triggerSaveDownloadList();
        return sWDownloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadFile(SWDownloadFile sWDownloadFile) {
        sWDownloadFile.stopDownload();
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            URN uRN;
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                this.downloadList.remove(n);
                this.fireDownloadFileRemoved(n);
            }
            if ((uRN = sWDownloadFile.getFileURN()) != null) {
                this.urnToDownloadMap.remove(uRN);
            }
        }
        sWDownloadFile.removeDownloadSegmentFiles();
        this.triggerSaveDownloadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadFiles(SWDownloadFile[] sWDownloadFileArray) {
        for (int i = 0; i < sWDownloadFileArray.length; ++i) {
            sWDownloadFileArray[i].stopDownload();
            ArrayList arrayList = this.downloadList;
            synchronized (arrayList) {
                URN uRN;
                int n = this.downloadList.indexOf(sWDownloadFileArray[i]);
                if (n >= 0) {
                    this.downloadList.remove(n);
                    this.fireDownloadFileRemoved(n);
                }
                if ((uRN = sWDownloadFileArray[i].getFileURN()) != null) {
                    this.urnToDownloadMap.remove(uRN);
                }
            }
            sWDownloadFileArray[i].removeDownloadSegmentFiles();
        }
        this.triggerSaveDownloadList();
    }

    public Integer getDownloadPriority(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            return new Integer(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDownloadFilePriorities(SWDownloadFile[] sWDownloadFileArray) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                int n = this.downloadList.indexOf(sWDownloadFileArray[i]);
                if (n < 0) continue;
                int n2 = i;
                if (n2 < 0 || n2 >= this.downloadList.size()) {
                    n2 = n;
                }
                this.downloadList.remove(n);
                this.downloadList.add(n2, sWDownloadFileArray[i]);
                this.fireDownloadFileRemoved(n);
                this.fireDownloadFileAdded(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveDownloadFilePriority(SWDownloadFile sWDownloadFile, short s) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                int n2 = n;
                switch (s) {
                    case 1: {
                        --n2;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 3: {
                        n2 = this.downloadList.size() - 1;
                    }
                }
                if (n2 < 0 || n2 >= this.downloadList.size()) {
                    return n;
                }
                this.downloadList.remove(n);
                this.downloadList.add(n2, sWDownloadFile);
                this.fireDownloadFileRemoved(n);
                this.fireDownloadFileAdded(n2);
                return n2;
            }
            return n;
        }
    }

    public int getDownloadFileCount() {
        return this.downloadList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadFileCount(int n) {
        int n2 = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                if (sWDownloadFile.getStatus() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(int n) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.downloadList.size()) {
                return null;
            }
            return (SWDownloadFile)this.downloadList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile[] getDownloadFilesAt(int[] nArray) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = nArray.length;
            SWDownloadFile[] sWDownloadFileArray = new SWDownloadFile[n];
            for (int i = 0; i < n; ++i) {
                sWDownloadFileArray[i] = nArray[i] < 0 || nArray[i] >= this.downloadList.size() ? null : (SWDownloadFile)this.downloadList.get(nArray[i]);
            }
            return sWDownloadFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(long l, URN uRN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = this.getDownloadFileByURN(uRN);
            if (sWDownloadFile != null && sWDownloadFile.getTotalDataSize() == l) {
                return sWDownloadFile;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFileByURN(URN uRN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = (SWDownloadFile)this.urnToDownloadMap.get(uRN);
            return sWDownloadFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNDownloaded(URN uRN) {
        if (uRN == null) {
            return false;
        }
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            return this.urnToDownloadMap.containsKey(uRN);
        }
    }

    public void releaseCandidateIP(SWDownloadCandidate sWDownloadCandidate) {
        this.ipDownloadCounter.relaseIP(sWDownloadCandidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadSet allocateDownloadSet(SWDownloadWorker sWDownloadWorker) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = null;
            SWDownloadCandidate sWDownloadCandidate = null;
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                boolean bl2;
                sWDownloadFile = (SWDownloadFile)iterator.next();
                if (!sWDownloadFile.isAbleToBeAllocated() || !(bl2 = sWDownloadFile.isDownloadSegmentAllocateable(null)) || (sWDownloadCandidate = sWDownloadFile.allocateDownloadCandidate(sWDownloadWorker)) == null) continue;
                try {
                    bl = this.ipDownloadCounter.validateAndCountIP(sWDownloadCandidate.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    sWDownloadCandidate.setStatus((short)13);
                    bl = false;
                }
                if (!bl) {
                    sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                    continue;
                }
                boolean bl3 = sWDownloadFile.isDownloadSegmentAllocateable(sWDownloadCandidate.getAvailableRangeSet());
                if (!bl3) {
                    sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                    continue;
                }
                sWDownloadFile.incrementWorkerCount();
                SWDownloadSet sWDownloadSet = new SWDownloadSet(sWDownloadFile, sWDownloadCandidate);
                if (sWDownloadWorker == this.temporaryWorker) {
                    this.unsetTemporaryWorker();
                }
                return sWDownloadSet;
            }
        }
        return null;
    }

    public boolean isNewLocalFilenameUsed(SWDownloadFile sWDownloadFile, File file) {
        int n = this.downloadList.size();
        for (int i = 0; i < n; ++i) {
            SWDownloadFile sWDownloadFile2 = (SWDownloadFile)this.downloadList.get(i);
            if (sWDownloadFile != null && sWDownloadFile2 == sWDownloadFile || sWDownloadFile2.getDestinationFile().compareTo(file) != 0) continue;
            return true;
        }
        return false;
    }

    public void notifyDownloadListChange() {
        this.downloadListChangedSinceSave = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSaveDownloadList() {
        if (!this.downloadListChangedSinceSave) {
            return;
        }
        Logger.logMessage(Logger.CONFIG, (short)2, "Trigger save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob != null) {
                this.saveDownloadListJob.triggerFollowUpSave();
            } else {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceSaveDownloadList() {
        Logger.logMessage(Logger.CONFIG, (short)2, "Force save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob == null) {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            } else {
                this.saveDownloadListJob.triggerFollowUpSave();
            }
        }
        try {
            if (this.saveDownloadListJob != null) {
                try {
                    this.saveDownloadListJob.setPriority(10);
                    this.saveDownloadListJob.join();
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.logError(interruptedException);
        }
    }

    private synchronized void unsetTemporaryWorker() {
        this.temporaryWorker.setTemporaryWorker(false);
        this.temporaryWorker = null;
        this.createNewTemporaryWorker();
    }

    private synchronized void createNewTemporaryWorker() {
        if (this.workerCount < ServiceManager.sCfg.maxTotalDownloadWorker) {
            this.temporaryWorker = new SWDownloadWorker();
            this.temporaryWorker.setTemporaryWorker(true);
            Logger.logMessage(Logger.FINE, (short)2, "Creating new worker: " + this.temporaryWorker);
            this.temporaryWorker.startWorker();
            this.workerCount = (short)(this.workerCount + 1);
        }
    }

    public synchronized void createRequiredWorker() {
        if (this.temporaryWorker == null) {
            this.createNewTemporaryWorker();
        }
    }

    public synchronized void notifyWaitingWorkers() {
        this.notifyAll();
    }

    public synchronized void waitForNotify() {
        try {
            this.wait(2000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean checkToStopWorker(SWDownloadWorker sWDownloadWorker) {
        int n = Math.min(this.downloadList.size() * ServiceManager.sCfg.maxWorkerPerDownload, ServiceManager.sCfg.maxTotalDownloadWorker);
        if (this.workerCount > n) {
            if (sWDownloadWorker.isRunning()) {
                sWDownloadWorker.stopWorker();
                this.workerCount = (short)(this.workerCount - 1);
                if (sWDownloadWorker.isTemporaryWorker()) {
                    this.temporaryWorker = null;
                }
            }
            return true;
        }
        if (this.workerCount < n) {
            this.createRequiredWorker();
        }
        return false;
    }

    public void notifyWorkerShoutdown(SWDownloadWorker sWDownloadWorker) {
        Logger.logMessage(Logger.FINE, (short)2, "Unexpected worker shutdown: " + sWDownloadWorker);
        sWDownloadWorker.stopWorker();
        this.workerCount = (short)(this.workerCount - 1);
        if (sWDownloadWorker.isTemporaryWorker()) {
            this.temporaryWorker = null;
        }
        this.createRequiredWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXJBSWDownloadList(XJBSWDownloadList xJBSWDownloadList) throws JAXBException {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Logger.logMessage(Logger.FINER, (short)2, "Loading SWDownload xml");
            this.downloadList.clear();
            this.urnToDownloadMap.clear();
            Iterator iterator = xJBSWDownloadList.getSWDownloadFileList().iterator();
            while (iterator.hasNext()) {
                try {
                    XJBSWDownloadFile xJBSWDownloadFile = (XJBSWDownloadFile)iterator.next();
                    SWDownloadFile sWDownloadFile = new SWDownloadFile(xJBSWDownloadFile);
                    int n = this.downloadList.size();
                    this.downloadList.add(n, sWDownloadFile);
                    URN uRN = sWDownloadFile.getFileURN();
                    if (uRN != null) {
                        this.urnToDownloadMap.put(uRN, sWDownloadFile);
                    }
                    Logger.logMessage(Logger.FINER, (short)2, "Loaded SWDownloadFile: " + sWDownloadFile);
                    this.fireDownloadFileAdded(n);
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error loading a download file from XML.");
                }
            }
        }
    }

    public void addDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.add(downloadFilesChangeListener);
    }

    public void removeDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.remove(downloadFilesChangeListener);
    }

    private void fireDownloadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileChanged(n);
                }
            }
        });
    }

    private void fireDownloadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileAdded(n);
                }
            }
        });
    }

    private void fireDownloadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileRemoved(n);
                }
            }
        });
    }

    public void fireDownloadFileChanged(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            this.fireDownloadFileChanged(n);
        }
    }

    private class RangePriorityRefreshJob
    implements Runnable {
        private RangePriorityRefreshTimer timer;

        public RangePriorityRefreshJob(RangePriorityRefreshTimer rangePriorityRefreshTimer) {
            this.timer = rangePriorityRefreshTimer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                Iterator iterator = SwarmingManager.this.downloadList.iterator();
                while (iterator.hasNext()) {
                    SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                    sWDownloadFile.refreshSegmentPriorities();
                }
            }
            this.timer.refreshJob = null;
        }
    }

    private class RangePriorityRefreshTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 15000L;
        private RangePriorityRefreshJob refreshJob;

        private RangePriorityRefreshTimer() {
        }

        public void run() {
            if (this.refreshJob == null && !SwarmingManager.this.downloadList.isEmpty()) {
                this.refreshJob = new RangePriorityRefreshJob(this);
                ThreadPool.getInstance().addJob(this.refreshJob, "RangePriorityRefreshJob");
            }
        }
    }

    private class SaveDownloadListJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "SaveDownloadListJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            do {
                Logger.logMessage(Logger.CONFIG, (short)2, "Start saving download list...");
                SwarmingManager.this.downloadListChangedSinceSave = false;
                this.isFollowUpSaveTriggered = false;
                try {
                    object = new ObjectFactory();
                    PhexElement phexElement = ((ObjectFactory)object).createPhexElement();
                    XJBSWDownloadList xJBSWDownloadList = this.createXJBSWDownloadList();
                    phexElement.setSWDownloadList(xJBSWDownloadList);
                    phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
                    File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
                    File file2 = new File(file.getAbsolutePath() + ".bak");
                    XMLBuilder.saveToFile(file2, phexElement);
                    FileUtils.copyFile(file2, file);
                    file2.delete();
                }
                catch (JAXBException jAXBException) {
                    Logger.logError(jAXBException);
                }
                catch (IOException iOException) {
                    Logger.logError(iOException);
                }
            } while (this.isFollowUpSaveTriggered);
            Logger.logMessage(Logger.CONFIG, (short)2, "Finished saving download list...");
            object = saveDownloadListLock;
            synchronized (object) {
                SwarmingManager.this.saveDownloadListJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XJBSWDownloadList createXJBSWDownloadList() throws JAXBException {
            ObjectFactory objectFactory = new ObjectFactory();
            XJBSWDownloadList xJBSWDownloadList = objectFactory.createXJBSWDownloadList();
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                Iterator iterator = SwarmingManager.this.downloadList.iterator();
                List list = xJBSWDownloadList.getSWDownloadFileList();
                while (iterator.hasNext()) {
                    SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                    list.add(sWDownloadFile.createXJBSWDownloadFile());
                }
            }
            return xJBSWDownloadList;
        }
    }

    private class SaveDownloadListTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 20000L;

        private SaveDownloadListTimer() {
        }

        public void run() {
            try {
                SwarmingManager.this.triggerSaveDownloadList();
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }

    private class LoadDownloadListJob
    extends Thread {
        private LoadDownloadListJob() {
        }

        public void run() {
            this.loadDownloadList();
        }

        private void loadDownloadList() {
            Logger.logMessage(Logger.CONFIG, (short)2, "Loading download list...");
            File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
            File file2 = new File(file.getAbsolutePath() + ".bak");
            if (!file.exists() && !file2.exists()) {
                Logger.logMessage(Logger.FINE, (short)2, "No download list file found.");
                return;
            }
            try {
                Logger.logMessage(Logger.FINER, (short)2, "Try to load from default download list.");
                XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
                if (xJBPhex == null) {
                    Logger.logMessage(Logger.FINER, (short)2, "Try to load from backup download list.");
                    xJBPhex = XMLBuilder.loadXJBPhexFromFile(file2);
                }
                if (xJBPhex == null) {
                    Logger.logMessage(Logger.SEVERE, (short)255, "Error loading download list.");
                    return;
                }
                XJBSWDownloadList xJBSWDownloadList = xJBPhex.getSWDownloadList();
                if (xJBSWDownloadList != null) {
                    SwarmingManager.this.loadXJBSWDownloadList(xJBSWDownloadList);
                } else {
                    Logger.logMessage(Logger.FINE, (short)2, "No SWDownloadList found.");
                }
            }
            catch (JAXBException jAXBException) {
                Throwable throwable = jAXBException.getLinkedException();
                if (throwable != null) {
                    Logger.logError(throwable);
                }
                Logger.logError(jAXBException);
                return;
            }
        }
    }
}

