/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.net.UnknownHostException;
import phex.common.ExpiryDate;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.host.FavoritesContainer;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.query.BrowseHostResults;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;

public class GUIActionPerformer {
    public static void browseHost(HostAddress hostAddress) {
        SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
        BrowseHostResults browseHostResults = searchContainer.createBrowseHostSearch(hostAddress, null);
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(browseHostResults);
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        SearchTab searchTab = (SearchTab)mainFrame.getTab(1101);
        mainFrame.setSelectedTab(1101);
        searchTab.setDisplayedSearch(searchResultsDataModel);
    }

    public static void banHosts(HostAddress[] hostAddressArray) {
        PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
        long l = System.currentTimeMillis() + 604800000L;
        ExpiryDate expiryDate = new ExpiryDate(l);
        for (int i = 0; i < hostAddressArray.length; ++i) {
            try {
                phexSecurityManager.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, hostAddressArray[i].getHostIP(), null, false, expiryDate, true);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static void addHostsToFavorites(HostAddress[] hostAddressArray) {
        HostManager hostManager = HostManager.getInstance();
        FavoritesContainer favoritesContainer = hostManager.getFavoritesContainer();
        favoritesContainer.addFavorites(hostAddressArray);
    }
}

