/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.HeadlessException;
import java.io.File;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.gui.actions.ConnectNetworkAction;
import phex.gui.actions.DisconnectNetworkAction;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWAction;
import phex.gui.actions.NewDownloadAction;
import phex.gui.actions.SwitchNetworkAction;
import phex.gui.chat.ChatFrameManager;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistryConstants;
import phex.gui.common.GUIUpdateNotificationListener;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.LookAndFeelFailedException;
import phex.gui.common.LookAndFeelUtils;
import phex.gui.common.MainFrame;
import phex.gui.common.TableUpdateService;
import phex.gui.macosx.MacOsxHandler;
import phex.update.UpdateManager;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITableList;
import phex.xml.XJBPhex;
import phex.xml.XMLBuilder;

public class GUIRegistry
implements GUIRegistryConstants {
    private static GUIRegistry instance;
    private HashMap globalActionMap;
    private LazyEventQueue lazyEventQueue;
    private TableUpdateService tableUpdateService;
    private DesktopIndicator desktopIndicator;
    private IconFactory iconFactory;
    private ChatFrameManager chatFrameManager;
    private MainFrame mainFrame;
    private boolean showTableHorizontalLines;
    private boolean showTableVerticalLines;
    private boolean useLogBandwidthSlider;
    static final /* synthetic */ boolean $assertionsDisabled;

    private GUIRegistry() {
    }

    public static GUIRegistry getInstance() {
        return instance;
    }

    public void initialize() {
        XJBGUISettings xJBGUISettings = this.loadGUISettings();
        this.initializeGUISettings(xJBGUISettings);
        this.iconFactory = new IconFactory("phex.gui.resources.Icons");
        if (Environment.getInstance().isWindowsOS()) {
            try {
                this.desktopIndicator = new DesktopIndicator();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.desktopIndicator = null;
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            new MacOsxHandler();
        }
        this.initializeGlobalActions();
        this.chatFrameManager = new ChatFrameManager();
        try {
            this.mainFrame = new MainFrame(null, xJBGUISettings);
            Logger.logMessage(Logger.FINE, (short)32, "GUIRegistry initialized.");
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        GUIUpdateNotificationListener gUIUpdateNotificationListener = new GUIUpdateNotificationListener();
        UpdateManager.getInstance().triggerAutoBackgroundCheck(gUIUpdateNotificationListener);
    }

    public DesktopIndicator getDesktopIndicator() {
        return this.desktopIndicator;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public IconFactory getIconFactory() {
        return this.iconFactory;
    }

    public LazyEventQueue getLazyEventQueue() {
        if (this.lazyEventQueue == null) {
            this.lazyEventQueue = new LazyEventQueue();
        }
        return this.lazyEventQueue;
    }

    public TableUpdateService getTableUpdateService() {
        if (this.tableUpdateService == null) {
            this.tableUpdateService = new TableUpdateService();
        }
        return this.tableUpdateService;
    }

    public FWAction getGlobalAction(String string) {
        return (FWAction)this.globalActionMap.get(string);
    }

    public String getUsedLAFClass() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public boolean getShowTableHorizontalLines() {
        return this.showTableHorizontalLines;
    }

    public void setShowTableHorizontalLines(boolean bl) {
        this.showTableHorizontalLines = bl;
    }

    public boolean getShowTableVerticalLines() {
        return this.showTableVerticalLines;
    }

    public void setShowTableVerticalLines(boolean bl) {
        this.showTableVerticalLines = bl;
    }

    public boolean useLogBandwidthSlider() {
        return this.useLogBandwidthSlider;
    }

    public void setLogBandwidthSliderUsed(boolean bl) {
        this.useLogBandwidthSlider = bl;
    }

    private XJBGUISettings loadGUISettings() {
        Logger.logMessage(Logger.FINE, (short)255, "Load gui settings file.");
        File file = Environment.getInstance().getPhexConfigFile("phexgui.xml");
        try {
            XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.FINE, (short)255, "No gui settings configuration file found.");
                return null;
            }
            this.updateGUISettings(xJBPhex);
            return xJBPhex.getGuiSettings();
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return null;
        }
    }

    public void saveGUISettings() {
        Logger.logMessage(Logger.CONFIG, (short)8, "Saving gui settings...");
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            PhexElement phexElement = objectFactory.createPhexElement();
            phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
            XJBGUISettings xJBGUISettings = objectFactory.createXJBGUISettings();
            phexElement.setGuiSettings(xJBGUISettings);
            XJBGUITableList xJBGUITableList = objectFactory.createXJBGUITableList();
            xJBGUITableList.setShowHorizontalLines(this.showTableHorizontalLines);
            xJBGUITableList.setShowVerticalLines(this.showTableVerticalLines);
            xJBGUISettings.setTableList(xJBGUITableList);
            xJBGUISettings.setLookAndFeelClass(this.getUsedLAFClass());
            this.mainFrame.saveGUISettings(xJBGUISettings);
            File file = Environment.getInstance().getPhexConfigFile("phexgui.xml");
            XMLBuilder.saveToFile(file, phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
    }

    private void initializeGlobalActions() {
        this.globalActionMap = new HashMap(2);
        FWAction fWAction = new ExitPhexAction();
        this.globalActionMap.put("ExitPhexAction", fWAction);
        fWAction = new NewDownloadAction();
        this.globalActionMap.put("NewDownloadAction", fWAction);
        fWAction = new ConnectNetworkAction();
        this.globalActionMap.put("ConnectNetworkAction", fWAction);
        fWAction = new DisconnectNetworkAction();
        this.globalActionMap.put("DisconnectNetworkAction", fWAction);
        fWAction = new SwitchNetworkAction();
        this.globalActionMap.put("SwitchNetworkAction", fWAction);
    }

    private void initializeGUISettings(XJBGUISettings xJBGUISettings) {
        block12: {
            String string;
            Object object;
            Environment environment = Environment.getInstance();
            if (environment.isMacOSX() || environment.isWindowsOS()) {
                this.showTableHorizontalLines = false;
                this.showTableVerticalLines = false;
            } else {
                this.showTableHorizontalLines = true;
                this.showTableVerticalLines = true;
            }
            this.useLogBandwidthSlider = false;
            ToolTipManager.sharedInstance().setEnabled(ServiceManager.sCfg.mUIDisplayTooltip);
            if (xJBGUISettings != null) {
                this.useLogBandwidthSlider = xJBGUISettings.isLogBandwidthSliderUsed();
                object = xJBGUISettings.getTableList();
                if (xJBGUISettings.getTableList().isSetShowHorizontalLines()) {
                    this.showTableHorizontalLines = object.isShowHorizontalLines();
                }
                if (xJBGUISettings.getTableList().isSetShowVerticalLines()) {
                    this.showTableVerticalLines = object.isShowVerticalLines();
                }
                string = xJBGUISettings.getLookAndFeelClass();
            } else {
                string = null;
            }
            object = LookAndFeelUtils.determineLAF(string);
            String string2 = object.getClass().getName();
            if (string != null && !string2.equals(string)) {
                JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("LAF_ErrorLoadingSwitchToDefault"), Localizer.getString("Error"), 0);
            }
            if (string2.equals(UIManager.getLookAndFeel().getClass().getName())) {
                GUIUtils.updateComponentsUI();
            } else {
                try {
                    LookAndFeelUtils.setLookAndFeel((LookAndFeel)object);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                }
                catch (LookAndFeelFailedException lookAndFeelFailedException) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
        }
    }

    private void updateGUISettings(XJBPhex xJBPhex) {
        if (xJBPhex == null) {
            return;
        }
        String string = xJBPhex.getPhexVersion();
        if (VersionUtils.compare("2.1.6.82", string) > 0) {
            this.updatesForBuild82(xJBPhex);
        }
    }

    private void updatesForBuild82(XJBPhex xJBPhex) {
        XJBGUISettings xJBGUISettings = xJBPhex.getGuiSettings();
        if (xJBGUISettings == null) {
            return;
        }
        String string = xJBGUISettings.getLookAndFeelClass();
        if (string == null) {
            return;
        }
        if (string.startsWith("com.jgoodies.plaf")) {
            string = StrUtil.replace(string, "com.jgoodies.plaf.", "com.jgoodies.looks.", 1);
            xJBGUISettings.setLookAndFeelClass(string);
        }
    }

    static {
        $assertionsDisabled = !GUIRegistry.class.desiredAssertionStatus();
        instance = new GUIRegistry();
    }
}

