/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class HTMLMultiLinePanel
extends JEditorPane {
    public HTMLMultiLinePanel(String string) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.setText(string);
        this.setFontAndColor(UIManager.getFont("Label.font"), UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
    }

    private void setFontAndColor(Font font, Color color) {
        StringBuffer stringBuffer = null;
        if (font != null) {
            stringBuffer = new StringBuffer("body { font-family: ");
            stringBuffer.append(font.getFamily());
            stringBuffer.append(";");
            stringBuffer.append(" font-size: ");
            stringBuffer.append(font.getSize());
            stringBuffer.append("pt");
            if (font.isBold()) {
                stringBuffer.append("; font-weight: 700");
            }
            if (font.isItalic()) {
                stringBuffer.append("; font-style: italic");
            }
        }
        if (color != null) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer("body { color: #");
            } else {
                stringBuffer.append("; color: #");
            }
            if (color.getRed() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getRed()));
            if (color.getGreen() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getGreen()));
            if (color.getBlue() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getBlue()));
        }
        if (stringBuffer != null) {
            stringBuffer.append(" }");
            try {
                StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
                styleSheet.addRule(stringBuffer.toString());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

