/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import phex.utils.IPUtils;

public class IPTextField
extends JPanel {
    private JTextField part1;
    private JTextField part2;
    private JTextField part3;
    private JTextField part4;
    private TextFieldFocusHandler textFieldFocusHandler;

    public IPTextField() {
        super(new GridBagLayout());
        this.setBorder((Border)UIManager.get("TextField.border"));
        this.textFieldFocusHandler = new TextFieldFocusHandler();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.part1 = this.createTextF(null);
        this.add((Component)this.part1, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buildLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.part2 = this.createTextF(this.part1);
        this.add((Component)this.part2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buildLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.part3 = this.createTextF(this.part2);
        this.add((Component)this.part3, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buildLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.part4 = this.createTextF(this.part3);
        this.add((Component)this.part4, gridBagConstraints);
        this.setBackground(this.part1.getBackground());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.part1.setEnabled(bl);
        this.part2.setEnabled(bl);
        this.part3.setEnabled(bl);
        this.part4.setEnabled(bl);
    }

    public boolean isInputValid() {
        if (!this.isFieldValid(this.part1)) {
            return false;
        }
        if (!this.isFieldValid(this.part2)) {
            return false;
        }
        if (!this.isFieldValid(this.part3)) {
            return false;
        }
        return this.isFieldValid(this.part4);
    }

    public boolean isFieldEmpty() {
        return this.part1.getText().trim().length() == 0 && this.part2.getText().trim().length() == 0 && this.part3.getText().trim().length() == 0 && this.part4.getText().trim().length() == 0;
    }

    private boolean isFieldValid(JTextField jTextField) {
        String string = jTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        try {
            int n = Integer.parseInt(string);
            if (n > 255) {
                jTextField.setText("");
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            jTextField.setText("");
            return false;
        }
    }

    public void setIPString(String string) {
        Document document = this.part1.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, new SimpleAttributeSet());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getIPString() {
        byte[] byArray = this.getIP();
        return IPUtils.ip2string(byArray);
    }

    public byte[] getIP() {
        String string;
        String string2;
        String string3;
        String string4 = this.part1.getText();
        if (string4.length() == 0) {
            string4 = "0";
        }
        if ((string3 = this.part2.getText()).length() == 0) {
            string3 = "0";
        }
        if ((string2 = this.part3.getText()).length() == 0) {
            string2 = "0";
        }
        if ((string = this.part4.getText()).length() == 0) {
            string = "0";
        }
        try {
            byte[] byArray = new byte[]{(byte)Integer.parseInt(string4), (byte)Integer.parseInt(string3), (byte)Integer.parseInt(string2), (byte)Integer.parseInt(string)};
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private JTextField createTextF(JTextField jTextField) {
        IPDocument iPDocument = new IPDocument();
        JTextField jTextField2 = new JTextField(iPDocument, null, 3);
        jTextField2.addFocusListener(this.textFieldFocusHandler);
        jTextField2.setBorder(null);
        jTextField2.setHorizontalAlignment(0);
        if (jTextField != null) {
            ((IPDocument)jTextField.getDocument()).setNextTextField(jTextField2);
        }
        return jTextField2;
    }

    private JLabel buildLabel() {
        JLabel jLabel = new JLabel(".");
        jLabel.setBackground(this.part1.getBackground());
        jLabel.setForeground(this.part1.getForeground());
        return jLabel;
    }

    private void addToNextTextField(String string, JTextField jTextField) {
        if (jTextField == null) {
            return;
        }
        jTextField.requestFocus();
        Document document = jTextField.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, new SimpleAttributeSet());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void selectNextTextField() {
        JTextField jTextField = this.getNextFocusTextField();
        if (jTextField == null) {
            return;
        }
        jTextField.requestFocus();
        jTextField.selectAll();
    }

    private JTextField getNextFocusTextField() {
        if (this.part1.hasFocus()) {
            return this.part2;
        }
        if (this.part2.hasFocus()) {
            return this.part3;
        }
        if (this.part3.hasFocus()) {
            return this.part4;
        }
        return null;
    }

    class IPDocument
    extends PlainDocument {
        protected JTextField nextTextField;

        IPDocument() {
        }

        public void setNextTextField(JTextField jTextField) {
            this.nextTextField = jTextField;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            int n2 = 3 - this.getLength();
            if (n2 == 0) {
                return;
            }
            char[] cArray = new char[n2];
            int n3 = 0;
            int n4 = string.length();
            int n5 = 0;
            boolean bl = false;
            for (n5 = 0; n5 < n4; ++n5) {
                char c = string.charAt(n5);
                if (Character.isDigit(c)) {
                    cArray[n3] = c;
                    if (++n3 != n2) continue;
                    break;
                }
                if (c != '.' || n3 <= 0) continue;
                bl = true;
                break;
            }
            super.insertString(n, new String(cArray, 0, n3), attributeSet);
            if (bl || n + n3 == 3) {
                if (n5 + 1 < n4) {
                    IPTextField.this.addToNextTextField(string.substring(n5 + 1), this.nextTextField);
                } else if (this.getLength() == 3) {
                    IPTextField.this.selectNextTextField();
                }
            }
        }
    }

    public class TextFieldFocusHandler
    extends FocusAdapter {
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            JTextField jTextField = (JTextField)focusEvent.getSource();
            String string = jTextField.getText();
            if (string.length() == 0) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n > 255) {
                    jTextField.setText("255");
                }
            }
            catch (NumberFormatException numberFormatException) {
                jTextField.setText("0");
            }
        }
    }
}

