/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import phex.gui.common.TreeTableModelAdapter;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.TreeTableModel;

public class JTreeTable
extends FWTable {
    protected TreeTableCellRenderer tree;
    private TableColumn treeTableColumn;

    public JTreeTable(TreeTableModel treeTableModel) {
        super((TableModel)null, (FWTableColumnModel)null);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.tree.setRowHeight(this.getRowHeight());
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.refreshTreeTableColumn();
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            public void setBounds(int n, int n2, int n3, int n4) {
                super.setBounds(n, n2, JTreeTable.this.treeTableColumn.getWidth() - n, n4);
            }
        };
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setOpaque(false);
        defaultTreeCellRenderer.setBackground(null);
        defaultTreeCellRenderer.setBackgroundNonSelectionColor(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addMouseListener(new UpdateTreeTableSelectionMouseListener());
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        super.setColumnModel(tableColumnModel);
        this.refreshTreeTableColumn();
    }

    public Object getNodeOfRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public void refreshTreeTableColumn() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnClass(i) != (class$phex$gui$models$TreeTableModel == null ? JTreeTable.class$("phex.gui.models.TreeTableModel") : class$phex$gui$models$TreeTableModel)) continue;
            this.treeTableColumn = this.getColumnModel().getColumn(i);
            break;
        }
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (JTreeTable.this.getColumnClass(i) != (class$phex$gui$models$TreeTableModel == null ? JTreeTable.class$("phex.gui.models.TreeTableModel") : class$phex$gui$models$TreeTableModel)) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            return false;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBorderSelectionColor(null);
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }
    }

    private final class UpdateTreeTableSelectionMouseListener
    extends MouseAdapter {
        private UpdateTreeTableSelectionMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = JTreeTable.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (JTreeTable.this.tree.isPathSelected(treePath)) {
                    JTreeTable.this.tree.removeSelectionPath(treePath);
                } else {
                    JTreeTable.this.tree.addSelectionPath(treePath);
                }
            }
        }
    }
}

