/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.actions.ActionViewAbout;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.actions.FilteredPortsAction;
import phex.gui.actions.OpenURLAction;
import phex.gui.actions.RescanSharedFilesAction;
import phex.gui.actions.ToggleToolbarAction;
import phex.gui.actions.ViewOptionsAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.DesktopIndicatorListener;
import phex.gui.common.FWLogoPanel;
import phex.gui.common.FWMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.SplashWindow;
import phex.gui.common.StatusBar;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.SWDownloadTab;
import phex.gui.tabs.SecurityTab;
import phex.gui.tabs.StatisticsTab;
import phex.gui.tabs.UploadTab;
import phex.gui.tabs.library.LibraryTab;
import phex.gui.tabs.network.NetworkTab;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.monitor.ResultMonitorTab;
import phex.gui.tabs.search.monitor.SearchMonitorTab;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITab;

public class MainFrame
extends JFrame {
    public static final int NETWORK_TAB_ID = 1000;
    public static final int SEARCH_TAB_ID = 1101;
    public static final int DOWNLOAD_TAB_ID = 1003;
    public static final int UPLOAD_TAB_ID = 1004;
    public static final int SECURITY_TAB_ID = 1005;
    public static final int STATISTICS_TAB_ID = 1006;
    public static final int LIBRARY_TAB_ID = 1007;
    public static final int SEARCH_MONITOR_TAB_ID = 1008;
    public static final int RESULT_MONITOR_TAB_ID = 1009;
    public static final int NETWORK_TAB_INDEX = 0;
    public static final int SEARCH_TAB_INDEX = 1;
    public static final int DOWNLOAD_TAB_INDEX = 3;
    public static final int SHARE_TAB_INDEX = 4;
    public static final int LIBRARY_TAB_INDEX = 5;
    public static final int SECURITY_TAB_INDEX = 6;
    public static final int STATISTICS_TAB_INDEX = 7;
    public static final int SEARCH_MONITOR_TAB_INDEX = 8;
    public static final int RESULT_MONITOR_TAB_INDEX = 9;
    private JTabbedPane tabbedPane;
    private JPanel logoPanel;
    private Timer refresher;
    private FWToolBar toolbar;
    private NetworkTab networkTab;
    private SearchTab searchTab;
    private UploadTab uploadTab;
    private LibraryTab libraryTab;
    private SWDownloadTab swDownloadTab;
    private SecurityTab securityTab;
    private StatisticsTab statisticsTab;
    private SearchMonitorTab searchMonitorTab;
    private ResultMonitorTab resultMonitorTab;

    public MainFrame(SplashWindow splashWindow, XJBGUISettings xJBGUISettings) {
        Icon icon = GUIRegistry.getInstance().getIconFactory().getIcon("Phex16");
        if (icon != null) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
        this.setupComponents(xJBGUISettings);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        DesktopIndicator desktopIndicator = GUIRegistry.getInstance().getDesktopIndicator();
        if (desktopIndicator != null) {
            desktopIndicator.addDesktopIndicatorListener(new DesktopIndicatorHandler());
        }
        this.pack();
        this.initFrameSize(xJBGUISettings);
        this.setTitle();
        this.refresher = new Timer(1000, new RefreshHandler());
        this.refresher.start();
    }

    private void initFrameSize(XJBGUISettings xJBGUISettings) {
        int n;
        GUIUtils.centerAndSizeWindow(this, 7, 8);
        if (xJBGUISettings == null) {
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        if (xJBGUISettings.isSetWindowWidth()) {
            rectangle.width = Math.min(dimension.width, xJBGUISettings.getWindowWidth());
        }
        if (xJBGUISettings.isSetWindowHeight()) {
            rectangle.height = Math.min(dimension.height, xJBGUISettings.getWindowHeight());
        }
        if (xJBGUISettings.isSetWindowPosX()) {
            n = xJBGUISettings.getWindowPosX();
            rectangle.x = Math.max(0, Math.min(n + rectangle.width, (int)dimension.getWidth()) - rectangle.width);
        }
        if (xJBGUISettings.isSetWindowPosY()) {
            n = xJBGUISettings.getWindowPosY();
            rectangle.y = Math.max(0, Math.min(n + rectangle.height, (int)dimension.getHeight()) - rectangle.height);
        }
        Logger.logMessage(Logger.FINE, (short)32, "Frame position: " + rectangle);
        this.setBounds(rectangle);
    }

    private void setupComponents(XJBGUISettings xJBGUISettings) {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setMinimumSize(new Dimension(50, 50));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = MainFrame.this.tabbedPane.getSelectedComponent();
                if (component instanceof FWTab) {
                    ((FWTab)component).tabSelectedNotify();
                }
            }
        });
        this.networkTab = new NetworkTab(this);
        this.networkTab.initComponent(xJBGUISettings);
        this.initializeTab(this.networkTab, 1000, xJBGUISettings);
        this.searchTab = new SearchTab();
        this.searchTab.initComponent(xJBGUISettings);
        this.initializeTab(this.searchTab, 1101, xJBGUISettings);
        this.swDownloadTab = new SWDownloadTab(this);
        this.swDownloadTab.initComponent(xJBGUISettings);
        this.initializeTab(this.swDownloadTab, 1003, xJBGUISettings);
        this.uploadTab = new UploadTab(this);
        this.uploadTab.initComponent(xJBGUISettings);
        this.initializeTab(this.uploadTab, 1004, xJBGUISettings);
        this.libraryTab = new LibraryTab();
        this.libraryTab.initComponent(xJBGUISettings);
        this.initializeTab(this.libraryTab, 1007, xJBGUISettings);
        this.securityTab = new SecurityTab();
        this.securityTab.initComponent(xJBGUISettings);
        this.initializeTab(this.securityTab, 1005, xJBGUISettings);
        this.statisticsTab = new StatisticsTab();
        this.statisticsTab.initComponent(xJBGUISettings);
        this.initializeTab(this.statisticsTab, 1006, xJBGUISettings);
        this.searchMonitorTab = new SearchMonitorTab();
        this.searchMonitorTab.initComponent(xJBGUISettings);
        this.initializeTab(this.searchMonitorTab, 1008, xJBGUISettings);
        this.resultMonitorTab = new ResultMonitorTab();
        this.resultMonitorTab.initComponent(xJBGUISettings);
        this.initializeTab(this.resultMonitorTab, 1009, xJBGUISettings);
        if (this.tabbedPane.getTabCount() == 0) {
            this.getContentPane().add("Center", this.getLogoPanel());
        } else {
            this.tabbedPane.setSelectedIndex(0);
            this.getContentPane().add("Center", this.tabbedPane);
        }
        JMenuBar jMenuBar = this.createMenuBar(xJBGUISettings);
        this.setJMenuBar(jMenuBar);
        boolean bl = true;
        if (xJBGUISettings != null && xJBGUISettings.isSetToolbarVisible()) {
            bl = xJBGUISettings.isToolbarVisible();
        }
        if (bl) {
            this.setToolbarVisible(true);
        }
        StatusBar statusBar = new StatusBar();
        this.getContentPane().add("South", statusBar);
    }

    public void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(Environment.getPhexVendor());
        NetworkManager networkManager = NetworkManager.getInstance();
        if (networkManager.isNetworkJoined()) {
            stringBuffer.append(" - ");
            stringBuffer.append(networkManager.getGnutellaNetwork().getName());
        }
        if (ServiceManager.sCfg.mProxyUse) {
            stringBuffer.append("  (via Proxy Server)");
        }
        super.setTitle(stringBuffer.toString());
    }

    public void setTabVisible(FWTab fWTab, boolean bl) {
        if (bl) {
            int n;
            int n2 = this.tabbedPane.getTabCount();
            int n3 = fWTab.getIndex();
            if (n2 == 0) {
                n = 0;
            } else {
                n = n2;
                FWTab fWTab2 = (FWTab)this.tabbedPane.getComponentAt(n - 1);
                int n4 = fWTab2.getIndex();
                while (n4 > n3 && --n != 0) {
                    fWTab2 = (FWTab)this.tabbedPane.getComponentAt(n - 1);
                    n4 = fWTab2.getIndex();
                }
            }
            int n5 = this.tabbedPane.getTabCount();
            if (n5 == 0) {
                this.getContentPane().remove(this.getLogoPanel());
                this.getContentPane().add("Center", this.tabbedPane);
                this.tabbedPane.setVisible(true);
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
            }
            this.tabbedPane.insertTab(fWTab.getName(), fWTab.getIcon(), fWTab, fWTab.getToolTip(), n);
            this.tabbedPane.setSelectedIndex(n);
            if (n5 == 0) {
                fWTab.setVisible(true);
            }
        } else {
            this.tabbedPane.remove(fWTab);
            if (this.tabbedPane.getTabCount() == 0) {
                this.getContentPane().remove(this.tabbedPane);
                this.getContentPane().add("Center", this.getLogoPanel());
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
                this.tabbedPane.setVisible(false);
            }
        }
    }

    public void setSelectedTab(int n) {
        FWTab fWTab = this.getTab(n);
        this.setSelectedTab(fWTab);
    }

    public FWTab getSelectedTab() {
        if (this.tabbedPane.getTabCount() == 0) {
            return null;
        }
        return (FWTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(FWTab fWTab) {
        if (fWTab == null) {
            return;
        }
        FWToggleAction fWToggleAction = fWTab.getToggleTabViewAction();
        if (!fWToggleAction.isSelected()) {
            fWToggleAction.actionPerformed(new ActionEvent(this, 0, null));
        }
        this.tabbedPane.setSelectedComponent(fWTab);
    }

    public FWTab getTab(int n) {
        switch (n) {
            case 1000: {
                return this.networkTab;
            }
            case 1101: {
                return this.searchTab;
            }
            case 1003: {
                return this.swDownloadTab;
            }
            case 1004: {
                return this.uploadTab;
            }
            case 1007: {
                return this.libraryTab;
            }
            case 1008: {
                return this.searchMonitorTab;
            }
            case 1009: {
                return this.resultMonitorTab;
            }
        }
        Logger.logWarning((short)32, "Unknown tab id: " + n);
        return null;
    }

    public NetworkTab getNetworkTab() {
        return this.networkTab;
    }

    public void saveGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        Rectangle rectangle = this.getBounds();
        xJBGUISettings.setWindowHeight(rectangle.height);
        xJBGUISettings.setWindowWidth(rectangle.width);
        xJBGUISettings.setWindowPosX(rectangle.x);
        xJBGUISettings.setWindowPosY(rectangle.y);
        xJBGUISettings.setToolbarVisible(this.toolbar != null);
        this.networkTab.appendXJBGUISettings(xJBGUISettings);
        this.searchTab.appendXJBGUISettings(xJBGUISettings);
        this.searchTab.appendXJBGUISettings(xJBGUISettings);
        this.swDownloadTab.appendXJBGUISettings(xJBGUISettings);
        this.uploadTab.appendXJBGUISettings(xJBGUISettings);
        this.libraryTab.appendXJBGUISettings(xJBGUISettings);
        this.securityTab.appendXJBGUISettings(xJBGUISettings);
        this.statisticsTab.appendXJBGUISettings(xJBGUISettings);
        this.searchMonitorTab.appendXJBGUISettings(xJBGUISettings);
        this.resultMonitorTab.appendXJBGUISettings(xJBGUISettings);
    }

    private void initializeTab(FWTab fWTab, int n, XJBGUISettings xJBGUISettings) {
        XJBGUITab xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, n);
        boolean bl = fWTab.isVisibleByDefault();
        if (xJBGUITab != null && xJBGUITab.isSetVisible()) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(fWTab, bl);
    }

    private JPanel getLogoPanel() {
        if (this.logoPanel == null) {
            ImageIcon imageIcon = new ImageIcon(MainFrame.class.getResource("/phex/resources/splash.jpg"));
            Image image = imageIcon.getImage();
            this.logoPanel = new FWLogoPanel(image);
            this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        return this.logoPanel;
    }

    public boolean isToolbarVisible() {
        return this.toolbar != null;
    }

    public void setToolbarVisible(boolean bl) {
        if (bl) {
            if (this.toolbar != null) {
                return;
            }
            this.toolbar = new FWToolBar(0);
            this.toolbar.setShowText(false);
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("ExitPhexAction"));
            this.toolbar.addSeparator();
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
            this.toolbar.addSeparator();
            this.toolbar.addAction(this.networkTab.getToggleTabViewAction());
            this.toolbar.addAction(this.searchTab.getToggleTabViewAction());
            this.toolbar.addAction(this.swDownloadTab.getToggleTabViewAction());
            this.toolbar.addAction(this.uploadTab.getToggleTabViewAction());
            this.toolbar.addAction(this.libraryTab.getToggleTabViewAction());
            this.toolbar.addAction(this.securityTab.getToggleTabViewAction());
            this.toolbar.addAction(this.statisticsTab.getToggleTabViewAction());
            this.toolbar.addAction(this.searchMonitorTab.getToggleTabViewAction());
            this.toolbar.addAction(this.resultMonitorTab.getToggleTabViewAction());
            this.getContentPane().add("North", this.toolbar);
            this.getContentPane().validate();
        } else {
            this.getContentPane().remove(this.toolbar);
            this.getContentPane().validate();
            this.toolbar = null;
        }
    }

    private JMenuBar createMenuBar(XJBGUISettings xJBGUISettings) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Localizer.getString("Network"));
        jMenu.setMnemonic(Localizer.getChar("NetworkMnemonic"));
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        FWMenu fWMenu = new FWMenu(Localizer.getString("New"));
        FWAction fWAction = gUIRegistry.getGlobalAction("NewDownloadAction");
        fWMenu.addAction(fWAction);
        jMenu.add(fWMenu);
        fWAction = gUIRegistry.getGlobalAction("ConnectNetworkAction");
        jMenu.add(fWAction);
        fWAction = gUIRegistry.getGlobalAction("DisconnectNetworkAction");
        jMenu.add(fWAction);
        jMenu.addSeparator();
        fWAction = gUIRegistry.getGlobalAction("SwitchNetworkAction");
        jMenu.add(fWAction);
        jMenu.addSeparator();
        fWAction = gUIRegistry.getGlobalAction("ExitPhexAction");
        jMenu.add(fWAction);
        jMenuBar.add(jMenu);
        FWMenu fWMenu2 = new FWMenu(Localizer.getString("View"));
        fWMenu2.setMnemonic(Localizer.getChar("ViewMnemonic"));
        boolean bl = true;
        if (xJBGUISettings != null && xJBGUISettings.isSetToolbarVisible()) {
            bl = xJBGUISettings.isToolbarVisible();
        }
        fWMenu2.addAction(new ToggleToolbarAction(bl));
        fWMenu2.addSeparator();
        fWMenu2.addAction(this.networkTab.getToggleTabViewAction());
        fWMenu2.addAction(this.searchTab.getToggleTabViewAction());
        fWMenu2.addAction(this.swDownloadTab.getToggleTabViewAction());
        fWMenu2.addAction(this.uploadTab.getToggleTabViewAction());
        fWMenu2.addAction(this.libraryTab.getToggleTabViewAction());
        fWMenu2.addAction(this.securityTab.getToggleTabViewAction());
        fWMenu2.addAction(this.statisticsTab.getToggleTabViewAction());
        fWMenu2.addAction(this.searchMonitorTab.getToggleTabViewAction());
        fWMenu2.addAction(this.resultMonitorTab.getToggleTabViewAction());
        jMenuBar.add(fWMenu2);
        FWMenu fWMenu3 = new FWMenu(Localizer.getString("Settings"));
        fWMenu3.setMnemonic(Localizer.getChar("SettingsMnemonic"));
        fWAction = new ViewOptionsAction();
        fWMenu3.addAction(fWAction);
        fWMenu3.addSeparator();
        fWAction = new FilteredPortsAction();
        fWMenu3.addAction(fWAction);
        fWMenu3.addSeparator();
        fWAction = new RescanSharedFilesAction();
        fWMenu3.addAction(fWAction);
        jMenuBar.add(fWMenu3);
        FWMenu fWMenu4 = new FWMenu(Localizer.getString("Help"));
        fWMenu4.setMnemonic(Localizer.getChar("HelpMnemonic"));
        fWMenu4.addAction(new OpenURLAction(Localizer.getString("PhexHomepage"), "http://phex.kouk.de", gUIRegistry.getIconFactory().getIcon("Network"), Localizer.getString("TTTPhexHomepage"), new Integer(Localizer.getChar("PhexHomepageMnemonic")), null));
        fWMenu4.addAction(new OpenURLAction(Localizer.getString("PhexForum"), "http://www.gnutellaforums.com/forumdisplay.php?s=&forumid=16", gUIRegistry.getIconFactory().getIcon("Network"), Localizer.getString("TTTPhexForum"), new Integer(Localizer.getChar("PhexForumMnemonic")), null));
        fWMenu4.addSeparator();
        fWMenu4.addAction(new ActionViewAbout());
        jMenuBar.add(fWMenu4);
        return jMenuBar;
    }

    private class RefreshHandler
    implements ActionListener {
        private RefreshHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.networkTab.refresh();
        }
    }

    private class DesktopIndicatorHandler
    implements DesktopIndicatorListener {
        private DesktopIndicatorHandler() {
        }

        public void onDesktopIndicatorClicked(DesktopIndicator desktopIndicator) {
            MainFrame.this.show();
            desktopIndicator.hideIndicator();
            if (MainFrame.this.getState() != 0) {
                MainFrame.this.setState(0);
            }
            MainFrame.this.requestFocus();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ExitPhexAction.performCloseGUIAction();
        }
    }
}

