/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.common.table.FWTableModel;
import phex.gui.models.ISortableModel;
import phex.gui.models.TreeTableModel;

public class TreeTableModelAdapter
extends FWTableModel
implements ISortableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
        super(null, null);
        this.tree = jTree;
        this.treeTableModel = treeTableModel;
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int n, int n2) {
        return this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
    }

    public Comparator getColumnComparator(int n) {
        return this.treeTableModel.getColumnComparator(n);
    }

    public Object getComparableValueAt(int n, int n2) {
        return this.treeTableModel.getComparableValueAt(this.nodeForRow(n), n2);
    }

    public int mapColumnIDToModelIndex(int n) {
        return this.treeTableModel.mapColumnIDToModelIndex(n);
    }

    public boolean isColumnHideable(int n) {
        return this.treeTableModel.isColumnHideable(n);
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    public int getSortByColumn() {
        if (this.treeTableModel instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.treeTableModel)).getSortByColumn();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    public boolean isSortedAscending() {
        if (this.treeTableModel instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.treeTableModel)).isSortedAscending();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    public void sortByColumn(int n, boolean bl) {
        if (!(this.treeTableModel instanceof ISortableModel)) {
            throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
        }
        ((ISortableModel)((Object)this.treeTableModel)).sortByColumn(n, bl);
    }
}

