/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.common.table.FWTable;
import phex.utils.Logger;

public class FWSortedTableModel
extends AbstractTableModel {
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    protected FWSortableTableModel tableModel;
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();
    private FWTable table;
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };

    public FWSortedTableModel() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public FWSortedTableModel(FWSortableTableModel fWSortableTableModel) {
        this();
        this.setTableModel(fWSortableTableModel);
    }

    public void setTable(FWTable fWTable) {
        this.table = fWTable;
    }

    public FWSortedTableModel(FWSortableTableModel fWSortableTableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader);
        this.setTableModel(fWSortableTableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(FWSortableTableModel fWSortableTableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = fWSortableTableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int n) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != n) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int n) {
        return this.getDirective(n).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (n2 != 0) {
            this.sortingColumns.add(new Directive(n, n2));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, n2, this.sortingColumns.indexOf(directive));
    }

    public void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator getComparator(int n) {
        Comparator comparator = this.tableModel.getColumnComparator(n);
        if (comparator != null) {
            return comparator;
        }
        Class clazz = this.tableModel.getColumnClass(n);
        comparator = (Comparator)this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n = this.tableModel.getRowCount();
            this.viewToModel = new Row[n];
            for (int i = 0; i < n; ++i) {
                this.viewToModel[i] = new Row(i);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int getModelIndex(int n) {
        try {
            Row[] rowArray = this.getViewToModel();
            if (n < 0 || n >= rowArray.length || rowArray[n] == null) {
                return -1;
            }
            return rowArray[n].modelIndex;
        }
        catch (RuntimeException runtimeException) {
            Logger.logError(runtimeException, this.tableModel.toString() + " " + n);
            throw runtimeException;
        }
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.getModelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public int getViewIndex(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return -1;
        }
        return this.getModelToView()[n];
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(this.getModelIndex(n), n2);
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.getModelIndex(n);
        if (n3 == -1) {
            return "";
        }
        return this.tableModel.getValueAt(n3, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.getModelIndex(n), n2);
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int n, int n2) {
            this.column = n;
            this.direction = n2;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                jLabel.setIcon(FWSortedTableModel.this.getHeaderRendererIcon(n3, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean bl, int n, int n2) {
            this.descending = bl;
            this.size = n;
            this.priority = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component == null ? Color.gray : component.getBackground();
            int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n4 = this.descending ? n3 : -n3;
            n2 = n2 + 5 * this.size / 7 + (this.descending ? -n4 : 0);
            int n5 = this.descending ? 1 : -1;
            graphics.translate(n, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 / 2, n4, 0, 0);
            graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 / 2, n4, n3, 0);
            graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n3, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                int n = mouseEvent.getClickCount();
                if (n != 1) {
                    return;
                }
                if (this.isResizingClick(mouseEvent.getPoint())) {
                    return;
                }
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n2 == -1) {
                    return;
                }
                int n3 = tableColumnModel.getColumn(n2).getModelIndex();
                if (n3 != -1) {
                    int n4 = FWSortedTableModel.this.getSortingStatus(n3);
                    if (!mouseEvent.isControlDown()) {
                        FWSortedTableModel.this.cancelSorting();
                    }
                    n4 += mouseEvent.isShiftDown() ? -1 : 1;
                    n4 = (n4 + 4) % 3 - 1;
                    jTableHeader.getTable().clearSelection();
                    FWSortedTableModel.this.setSortingStatus(n3, n4);
                }
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }

        public boolean isResizingClick(Point point) {
            int n;
            int n2 = FWSortedTableModel.this.tableHeader.columnAtPoint(point);
            if (n2 == -1) {
                return false;
            }
            Rectangle rectangle = FWSortedTableModel.this.tableHeader.getHeaderRect(n2);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return false;
            }
            int n3 = rectangle.x + rectangle.width / 2;
            if (FWSortedTableModel.this.tableHeader.getComponentOrientation().isLeftToRight()) {
                n = point.x < n3 ? n2 - 1 : n2;
            } else {
                int n4 = n = point.x < n3 ? n2 : n2 - 1;
            }
            return n != -1;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!FWSortedTableModel.this.isSorting()) {
                FWSortedTableModel.this.clearSortingState();
                FWSortedTableModel.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                FWSortedTableModel.this.cancelSorting();
                FWSortedTableModel.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && FWSortedTableModel.this.getSortingStatus(n) == 0 && FWSortedTableModel.this.modelToView != null) {
                int n2 = FWSortedTableModel.this.getModelToView()[tableModelEvent.getFirstRow()];
                FWSortedTableModel.this.fireTableChanged(new TableModelEvent(FWSortedTableModel.this, n2, n2, n, tableModelEvent.getType()));
                return;
            }
            FWSortedTableModel.this.clearSortingState();
            FWSortedTableModel.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            Iterator iterator = FWSortedTableModel.this.sortingColumns.iterator();
            while (iterator.hasNext()) {
                Directive directive = (Directive)iterator.next();
                int n3 = directive.column;
                Object object2 = FWSortedTableModel.this.tableModel.getComparableValueAt(n, n3);
                Object object3 = FWSortedTableModel.this.tableModel.getComparableValueAt(n2, n3);
                int n4 = 0;
                n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : FWSortedTableModel.this.getComparator(n3).compare(object2, object3)));
                if (n4 == 0) continue;
                return directive.direction == -1 ? -n4 : n4;
            }
            return 0;
        }
    }
}

