/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.xml.bind.JAXBException;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableModel;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUITableColumn;
import phex.xml.XJBGUITableColumnList;

public class FWTableColumnModel
extends DefaultTableColumnModel {
    private ArrayList allTableColumns = new ArrayList();

    public FWTableColumnModel(FWTableModel fWTableModel, int[] nArray) {
        this(fWTableModel, nArray, null);
    }

    public FWTableColumnModel(FWTableModel fWTableModel, int[] nArray, XJBGUITableColumnList xJBGUITableColumnList) {
        this.buildColumnsFromColumnIDs(nArray, fWTableModel, xJBGUITableColumnList);
    }

    public void addColumn(FWTableColumn fWTableColumn) {
        if (fWTableColumn.isVisible()) {
            super.addColumn(fWTableColumn);
        }
        this.allTableColumns.add(fWTableColumn);
    }

    public void showColumn(FWTableColumn fWTableColumn) {
        if (!fWTableColumn.isVisible()) {
            fWTableColumn.setVisible(true);
            super.addColumn(fWTableColumn);
            int n = this.getColumnCount() - 1;
            int n2 = fWTableColumn.getModelIndex();
            if (n == 0) {
                return;
            }
            TableColumn tableColumn = this.getColumn(n - 1);
            int n3 = tableColumn.getModelIndex();
            while (n3 > n2 && --n != 0) {
                tableColumn = this.getColumn(n - 1);
                n3 = tableColumn.getModelIndex();
            }
            if (n < this.getColumnCount() - 1) {
                this.moveColumn(this.getColumnCount() - 1, n);
            }
        }
    }

    public void hideColumn(FWTableColumn fWTableColumn) {
        if (fWTableColumn.isHideable() && fWTableColumn.isVisible()) {
            this.removeColumn(fWTableColumn);
            fWTableColumn.setVisible(false);
        }
    }

    public FWTableColumn getColumn(Object object) {
        Iterator iterator = this.allTableColumns.iterator();
        while (iterator.hasNext()) {
            FWTableColumn fWTableColumn = (FWTableColumn)iterator.next();
            if (!object.equals(fWTableColumn.getIdentifier())) continue;
            return fWTableColumn;
        }
        return null;
    }

    public Iterator createAllColumnsIterator() {
        return this.allTableColumns.iterator();
    }

    public XJBGUITableColumnList createXJBGUITableColumnList() throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        XJBGUITableColumnList xJBGUITableColumnList = objectFactory.createXJBGUITableColumnList();
        List list = xJBGUITableColumnList.getTableColumnList();
        Collections.sort(this.allTableColumns, new VisibleTableColumnComparator());
        Iterator iterator = this.allTableColumns.iterator();
        while (iterator.hasNext()) {
            FWTableColumn fWTableColumn = (FWTableColumn)iterator.next();
            XJBGUITableColumn xJBGUITableColumn = fWTableColumn.createXJBGUITableColumn();
            if (fWTableColumn.isVisible()) {
                xJBGUITableColumn.setVisibleIndex(this.getColumnIndex(fWTableColumn.getIdentifier()));
            }
            list.add(xJBGUITableColumn);
        }
        return xJBGUITableColumnList;
    }

    protected void buildColumnsFromColumnIDs(int[] nArray, FWTableModel fWTableModel, XJBGUITableColumnList xJBGUITableColumnList) {
        ArrayList<FWTableColumn> arrayList = new ArrayList<FWTableColumn>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            FWTableColumn fWTableColumn = null;
            if (xJBGUITableColumnList != null) {
                fWTableColumn = this.buildColumnFromXML(nArray[i], fWTableModel, xJBGUITableColumnList);
            }
            if (fWTableColumn != null) continue;
            fWTableColumn = this.buildDefaultColumn(nArray[i], fWTableModel);
            arrayList.add(fWTableColumn);
        }
        this.arrangeColumns(xJBGUITableColumnList, arrayList, fWTableModel);
    }

    protected FWTableColumn buildColumnFromXML(int n, FWTableModel fWTableModel, XJBGUITableColumnList xJBGUITableColumnList) {
        if (xJBGUITableColumnList == null) {
            return null;
        }
        try {
            FWTableColumn fWTableColumn = null;
            Iterator iterator = xJBGUITableColumnList.getTableColumnList().iterator();
            while (iterator.hasNext()) {
                XJBGUITableColumn xJBGUITableColumn = (XJBGUITableColumn)iterator.next();
                if (n != xJBGUITableColumn.getColumnID()) continue;
                int n2 = fWTableModel.mapColumnIDToModelIndex(n);
                fWTableColumn = new FWTableColumn(n2, fWTableModel.getColumnName(n2), new Integer(n));
                fWTableColumn.setHideable(fWTableModel.isColumnHideable(n));
                fWTableColumn.setVisible(xJBGUITableColumn.isVisible());
                fWTableColumn.setPreferredWidth(xJBGUITableColumn.getWidth());
                this.addColumn(fWTableColumn);
                return fWTableColumn;
            }
            return null;
        }
        catch (Exception exception) {
            Logger.logError(exception);
            return null;
        }
    }

    protected FWTableColumn buildDefaultColumn(int n, FWTableModel fWTableModel) {
        int n2 = fWTableModel.mapColumnIDToModelIndex(n);
        FWTableColumn fWTableColumn = new FWTableColumn(n2, fWTableModel.getColumnName(n2), new Integer(n));
        fWTableColumn.setHideable(fWTableModel.isColumnHideable(n));
        this.addColumn(fWTableColumn);
        return fWTableColumn;
    }

    protected void arrangeColumns(XJBGUITableColumnList xJBGUITableColumnList, ArrayList arrayList, FWTableModel fWTableModel) {
        int n;
        int n2;
        Object object;
        Object object2;
        if (xJBGUITableColumnList != null) {
            object2 = xJBGUITableColumnList.getTableColumnList().iterator();
            while (object2.hasNext()) {
                try {
                    object = (XJBGUITableColumn)object2.next();
                    n2 = object.getColumnID();
                    n = fWTableModel.mapColumnIDToModelIndex(n2);
                    if (!object.isVisible() || n < 0) continue;
                    int n3 = this.getColumnIndex(new Integer(n2));
                    int n4 = object.getVisibleIndex();
                    n4 = Math.min(n4, this.getColumnCount() - 1);
                    this.moveColumn(n3, n4);
                }
                catch (Exception exception) {
                    Logger.logError(exception);
                }
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            object2 = (FWTableColumn)object.next();
            n2 = this.getColumnIndex(((TableColumn)object2).getIdentifier());
            n = Math.min(fWTableModel.mapColumnIDToModelIndex((Integer)((TableColumn)object2).getIdentifier()), this.getColumnCount() - 1);
            this.moveColumn(n2, n);
        }
    }

    private class VisibleTableColumnComparator
    implements Comparator {
        private VisibleTableColumnComparator() {
        }

        public int compare(Object object, Object object2) {
            FWTableColumn fWTableColumn = (FWTableColumn)object;
            FWTableColumn fWTableColumn2 = (FWTableColumn)object2;
            if (!fWTableColumn.isVisible()) {
                return -1;
            }
            if (!fWTableColumn2.isVisible()) {
                return 1;
            }
            int n = FWTableColumnModel.this.getColumnIndex(fWTableColumn.getIdentifier());
            int n2 = FWTableColumnModel.this.getColumnIndex(fWTableColumn2.getIdentifier());
            return n - n2;
        }
    }
}

