/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PlainMultiLinePanel;
import phex.utils.Localizer;

public class CloseOptionsDialog
extends JDialog {
    private JRadioButton minimizeToBackgroundRBtn;
    private JRadioButton shutdownRBtn;
    private JCheckBox dontDisplayAgainChkBox;
    private boolean isOkActivated = false;

    public CloseOptionsDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("CloseOptions"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CloseOptionsDialog.this.closeDialog(false);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("d:grow", "top:p:grow, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        formLayout.setRowGroups(new int[][]{{3, 5, 9}});
        jPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.setDefaultDialogBorder();
        PlainMultiLinePanel plainMultiLinePanel = new PlainMultiLinePanel(Localizer.getString("CloseOptionsText"));
        panelBuilder.add((Component)plainMultiLinePanel, cellConstraints.xy(1, 1));
        String string = GUIRegistry.getInstance().getDesktopIndicator() != null ? Localizer.getString("MinimizeToSysTray") : Localizer.getString("MinimizeToBackground");
        this.minimizeToBackgroundRBtn = new JRadioButton(string, ServiceManager.sCfg.minimizeToBackground);
        Font font = this.minimizeToBackgroundRBtn.getFont();
        Font font2 = font.deriveFont(1, font.getSize() + 1);
        this.minimizeToBackgroundRBtn.setFont(font2);
        panelBuilder.add((Component)this.minimizeToBackgroundRBtn, cellConstraints.xy(1, 3));
        this.shutdownRBtn = new JRadioButton(Localizer.getString("Shutdown"), !ServiceManager.sCfg.minimizeToBackground);
        panelBuilder.add((Component)this.shutdownRBtn, cellConstraints.xy(1, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.minimizeToBackgroundRBtn);
        buttonGroup.add(this.shutdownRBtn);
        JSeparator jSeparator = new JSeparator();
        panelBuilder.add((Component)jSeparator, cellConstraints.xy(1, 7));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        this.dontDisplayAgainChkBox = new JCheckBox(Localizer.getString("DontAskAnymore"));
        buttonBarBuilder.addGridded(this.dontDisplayAgainChkBox);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGlue();
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.setRequestFocusEnabled(true);
        jButton.addActionListener(buttonActionHandler);
        jButton.setActionCommand("OK");
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.setRequestFocusEnabled(true);
        jButton2.addActionListener(buttonActionHandler);
        jButton2.setActionCommand("CANCEL");
        buttonBarBuilder.addGriddedButtons(new JButton[]{jButton, jButton2});
        JPanel jPanel2 = buttonBarBuilder.getPanel();
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(1, 9));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
        this.getContentPane().validate();
        jPanel.doLayout();
        jPanel.revalidate();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.dontDisplayAgainChkBox.isSelected();
        if (bl2 != ServiceManager.sCfg.showCloseOptionsDialog) {
            ServiceManager.sCfg.showCloseOptionsDialog = bl2;
            bl = true;
        }
        if (bl) {
            ServiceManager.sCfg.save();
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isOkActivated() {
        return this.isOkActivated;
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if (actionEvent.getActionCommand().equals("OK")) {
                boolean bl2 = CloseOptionsDialog.this.minimizeToBackgroundRBtn.isSelected();
                if (bl2 != ServiceManager.sCfg.minimizeToBackground) {
                    ServiceManager.sCfg.minimizeToBackground = bl2;
                    bl = true;
                }
                CloseOptionsDialog.this.isOkActivated = true;
            }
            CloseOptionsDialog.this.closeDialog(bl);
        }
    }
}

