/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.share.ShareManager;
import phex.utils.FileUtils;
import phex.utils.IOUtil;
import phex.utils.Localizer;
import phex.utils.Logger;

public class ExportDialog
extends JDialog {
    private JTextField customExportFormatTF;
    private JTextField outputFileTF;
    private JRadioButton defaultHTMLExport;
    private JRadioButton magmaYAMLHTMLExport;
    private JRadioButton customExport;

    public ExportDialog() throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExportDialog.this.closeDialog();
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("4dlu, d, 2dlu, d, 2dlu, fill:d:grow, 2dlu, d, 4dlu", "p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p 6dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        DialogBanner dialogBanner = new DialogBanner(Localizer.getString("ExportDialog_BannerHeader"), Localizer.getString("ExportDialog_BannerSubHeader"));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, 9, 1));
        ExportTypeListener exportTypeListener = new ExportTypeListener();
        panelBuilder.addSeparator(Localizer.getString("ExportDialog_ExportFormat"), cellConstraints.xywh(2, 3, 7, 1));
        this.defaultHTMLExport = new JRadioButton(Localizer.getString("ExportDialog_DefaultHTMLExport"));
        this.defaultHTMLExport.setSelected(true);
        this.defaultHTMLExport.addActionListener(exportTypeListener);
        this.magmaYAMLHTMLExport = new JRadioButton(Localizer.getString("ExportDialog_MagmaYAMLExport"));
        this.magmaYAMLHTMLExport.addActionListener(exportTypeListener);
        this.customExport = new JRadioButton(Localizer.getString("ExportDialog_CustomExportFormat"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultHTMLExport);
        buttonGroup.add(this.magmaYAMLHTMLExport);
        buttonGroup.add(this.customExport);
        this.defaultHTMLExport.setSelected(true);
        panelBuilder.add((Component)this.defaultHTMLExport, cellConstraints.xywh(4, 5, 3, 1));
        panelBuilder.add((Component)this.magmaYAMLHTMLExport, cellConstraints.xywh(4, 7, 3, 1));
        panelBuilder.add((Component)this.customExport, cellConstraints.xy(4, 9));
        this.customExportFormatTF = new JTextField(40);
        panelBuilder.add((Component)this.customExportFormatTF, cellConstraints.xywh(6, 9, 1, 1));
        JButton jButton = new JButton(Localizer.getString("ExportDialog_Browse"));
        jButton.addActionListener(new BrowseCustomFileBtnListener());
        panelBuilder.add((Component)jButton, cellConstraints.xy(8, 9));
        panelBuilder.addSeparator(Localizer.getString("ExportDialog_Output"), cellConstraints.xywh(2, 11, 7, 1));
        panelBuilder.addLabel(Localizer.getString("ExportDialog_FileName"), cellConstraints.xy(4, 13, "right, center"));
        this.outputFileTF = new JTextField(40);
        File file = new File(SystemUtils.USER_HOME, "shared_files.html");
        this.outputFileTF.setText(file.getAbsolutePath());
        panelBuilder.add((Component)this.outputFileTF, cellConstraints.xywh(6, 13, 1, 1));
        JButton jButton2 = new JButton(Localizer.getString("ExportDialog_Browse"));
        jButton2.addActionListener(new BrowseOutFileBtnListener());
        panelBuilder.add((Component)jButton2, cellConstraints.xy(8, 13));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 17, 9, 1));
        JButton jButton3 = new JButton(Localizer.getString("Cancel"));
        jButton3.addActionListener(new CancelBtnListener());
        JButton jButton4 = new JButton(Localizer.getString("OK"));
        jButton4.addActionListener(new OkBtnListener());
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton4, jButton3);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, 19, 7, 1));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExport() {
        BufferedOutputStream bufferedOutputStream;
        InputStream inputStream;
        block7: {
            block8: {
                String string = this.outputFileTF.getText();
                File file = new File(string);
                inputStream = null;
                bufferedOutputStream = null;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                if (this.defaultHTMLExport.isSelected()) {
                    inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/defaultSharedFilesHTMLExport.xsl");
                    break block7;
                }
                if (this.magmaYAMLHTMLExport.isSelected()) {
                    inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/magmaSharedFilesYAMLExport.xsl");
                    break block7;
                }
                if (!this.customExport.isSelected()) break block8;
                String string2 = this.customExportFormatTF.getText();
                File file2 = new File(string2);
                inputStream = new BufferedInputStream(new FileInputStream(file2));
                break block7;
            }
            IOUtil.closeQuietly(inputStream);
            IOUtil.closeQuietly(bufferedOutputStream);
            return;
        }
        try {
            ShareManager.getInstance().exportSharedFiles(inputStream, bufferedOutputStream);
        }
        catch (IOException iOException) {
            try {
                Logger.logError(iOException);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inputStream);
                IOUtil.closeQuietly(bufferedOutputStream);
                throw throwable;
            }
            IOUtil.closeQuietly(inputStream);
            IOUtil.closeQuietly(bufferedOutputStream);
        }
        IOUtil.closeQuietly(inputStream);
        IOUtil.closeQuietly(bufferedOutputStream);
    }

    private final class ExportTypeListener
    implements ActionListener {
        private ExportTypeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ExportDialog.this.outputFileTF.getText();
            String string2 = FileUtils.getFileExtension(string);
            if (ExportDialog.this.defaultHTMLExport.isSelected()) {
                if (!string2.equals("htm") && !string2.equals("html")) {
                    string = FileUtils.replaceFileExtension(string, "html");
                }
            } else if (ExportDialog.this.magmaYAMLHTMLExport.isSelected() && !string2.equals("magma")) {
                string = FileUtils.replaceFileExtension(string, "magma");
            }
            ExportDialog.this.outputFileTF.setText(string);
        }
    }

    private final class BrowseCustomFileBtnListener
    implements ActionListener {
        private BrowseCustomFileBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportDialog.this.customExport.setSelected(true);
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog fileDialog = new FileDialog((Frame)GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_SelectCustomStyleFile"), 0);
                fileDialog.show();
                ExportDialog.this.customExportFormatTF.setText(fileDialog.getDirectory() + fileDialog.getFile());
            } else {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(Localizer.getString("ExportDialog_SelectCustomStyleFile"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || FileUtils.getFileExtension(file).equalsIgnoreCase("XSL");
                    }

                    public String getDescription() {
                        return "XSL-Stylesheet";
                    }
                });
                int n = jFileChooser.showOpenDialog(ExportDialog.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    ExportDialog.this.customExportFormatTF.setText(file.getAbsolutePath());
                }
            }
        }
    }

    private final class BrowseOutFileBtnListener
    implements ActionListener {
        private BrowseOutFileBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog fileDialog = new FileDialog((Frame)GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_SelectOutputFile"), 1);
                fileDialog.show();
                String string = fileDialog.getDirectory() + fileDialog.getFile();
                string = this.adjustFileExtension(string);
                ExportDialog.this.outputFileTF.setText(string);
            } else {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(Localizer.getString("ExportDialog_SelectOutputFile"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(ExportDialog.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    String string = this.adjustFileExtension(file.getAbsolutePath());
                    ExportDialog.this.outputFileTF.setText(string);
                }
            }
        }

        private String adjustFileExtension(String string) {
            String string2 = FileUtils.getFileExtension(string);
            if (ExportDialog.this.defaultHTMLExport.isSelected()) {
                if (!string2.equals("htm") && !string2.equals("html")) {
                    string = string + ".html";
                }
            } else if (ExportDialog.this.magmaYAMLHTMLExport.isSelected() && !string2.equals("magma")) {
                string = string + ".magma";
            }
            return string;
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ExportDialog.this.closeDialog();
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ExportDialog.this.startExport();
                ExportDialog.this.closeDialog();
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }
}

