/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.MagmaParser;
import phex.utils.NLogger;

public class NewDownloadDialog
extends JDialog {
    public static final int URI_DOWNLOAD = 1;
    public static final int MAGMA_DOWNLOAD = 2;
    private JTextField uriTF;
    private JTextField magmaTF;
    private JTabbedPane downloadTabPane;

    public NewDownloadDialog() throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("NewDownload_DialogTitle"), false);
        this.prepareComponent();
    }

    public NewDownloadDialog(String string, int n) throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("NewDownload_DialogTitle"), false);
        this.prepareComponent();
        switch (n) {
            case 1: {
                this.uriTF.setText(string);
                this.downloadTabPane.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.magmaTF.setText(string);
                this.downloadTabPane.setSelectedIndex(1);
            }
        }
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NewDownloadDialog.this.closeDialog();
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "p, p, 2dlu, p, 6dlu, p, 3dlu, p 6dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        DialogBanner dialogBanner = new DialogBanner(Localizer.getString("NewDownload_BannerHeader"), Localizer.getString("NewDownload_BannerSubHeader"));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, 3, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 2, 3, 1));
        this.downloadTabPane = new JTabbedPane();
        JPanel jPanel2 = this.createByUrlPanel();
        this.downloadTabPane.addTab(Localizer.getString("NewDownload_ByUrl"), jPanel2);
        JPanel jPanel3 = this.createByMagmaPanel();
        this.downloadTabPane.addTab(Localizer.getString("NewDownload_ByMagmaFile"), jPanel3);
        panelBuilder.add((Component)this.downloadTabPane, cellConstraints.xy(2, 4));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 6, 3, 1));
        JButton jButton = new JButton(Localizer.getString("Cancel"));
        jButton.addActionListener(new CancelBtnListener());
        JButton jButton2 = new JButton(Localizer.getString("OK"));
        jButton2.addActionListener(new OkBtnListener());
        JPanel jPanel4 = ButtonBarFactory.buildOKCancelBar(jButton2, jButton);
        panelBuilder.add((Component)jPanel4, cellConstraints.xy(2, 8));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createByUrlPanel() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, d, 2dlu, d, fill:d:grow, 6dlu", "10dlu, p, 10dlu, p, 6dlu, p, 6dlu");
        JPanel jPanel = new JPanel();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        JLabel jLabel = new JLabel(Localizer.getString("NewDownload_UrlToDownload"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(2, 2));
        this.uriTF = new JTextField(40);
        panelBuilder.add((Component)this.uriTF, cellConstraints.xywh(4, 2, 2, 1));
        panelBuilder.addSeparator(Localizer.getString("NewDownload_Examples"), cellConstraints.xywh(2, 4, 4, 1));
        JPanel jPanel2 = new JPanel();
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, 6, 4, 1));
        FormLayout formLayout2 = new FormLayout("2dlu, d", "p, 3dlu, p");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel2);
        panelBuilder2.addLabel("http://www.host.com/path/file.zip", cellConstraints.xy(2, 1));
        panelBuilder2.addLabel("magnet:?xt=urn:sha1:AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPP", cellConstraints.xy(2, 3));
        return jPanel;
    }

    private JPanel createByMagmaPanel() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, d, 2dlu, d, fill:d:grow, 2dlu, d, 6dlu", "10dlu, p, 10dlu, p, 6dlu, p, 6dlu");
        JPanel jPanel = new JPanel();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        JLabel jLabel = new JLabel(Localizer.getString("NewDownload_MagmaFile"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(2, 2));
        this.magmaTF = new JTextField(30);
        panelBuilder.add((Component)this.magmaTF, cellConstraints.xywh(4, 2, 2, 1));
        panelBuilder.addSeparator(Localizer.getString("NewDownload_CreatingMagma"), cellConstraints.xywh(2, 4, 7, 1));
        HTMLMultiLinePanel hTMLMultiLinePanel = new HTMLMultiLinePanel(Localizer.getString("NewDownload_MagmaHowTo")){

            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        panelBuilder.add((Component)hTMLMultiLinePanel, cellConstraints.xywh(2, 6, 6, 1));
        JButton jButton = new JButton(Localizer.getString("NewDownload_Browse"));
        jButton.addActionListener(new SetDownlodDirectoryListener());
        panelBuilder.add((Component)jButton, cellConstraints.xy(7, 2));
        return jPanel;
    }

    private void createNewDownload() throws URIException {
        String string = this.uriTF.getText().trim();
        if (string.length() == 0) {
            return;
        }
        URI uRI = new URI(string, true);
        SwarmingManager.getInstance().addFileToDownload(uRI);
    }

    private void createNewMagmaDownload() {
        String string = this.magmaTF.getText().trim();
        if (string.length() == 0) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            MagmaParser magmaParser = new MagmaParser(bufferedReader);
            magmaParser.start();
            List list = magmaParser.getMagnets();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                URI uRI = new URI(string2, true);
                SwarmingManager.getInstance().addFileToDownload(uRI);
            }
        }
        catch (IOException iOException) {
            NLogger.warn("MAGMA", iOException.getMessage(), iOException);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    static class TransImageFilter
    extends RGBImageFilter {
        public static Icon createTransIcon(Icon icon) {
            TransImageFilter transImageFilter = new TransImageFilter();
            FilteredImageSource filteredImageSource = new FilteredImageSource(((ImageIcon)icon).getImage().getSource(), transImageFilter);
            Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            return new ImageIcon(image);
        }

        public TransImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 &= 0x33FFFFFF;
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NewDownloadDialog.this.closeDialog();
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NewDownloadDialog.this.createNewDownload();
                NewDownloadDialog.this.createNewMagmaDownload();
                NewDownloadDialog.this.closeDialog();
            }
            catch (URIException uRIException) {
                Logger.logError(uRIException);
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    private class SetDownlodDirectoryListener
    implements ActionListener {
        private SetDownlodDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(NewDownloadDialog.this.magmaTF.getText()));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(Localizer.getString("NewDownload_SelectMagmaFile"));
            jFileChooser.setApproveButtonText(Localizer.getString("Select"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int n = jFileChooser.showDialog(NewDownloadDialog.this, null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                NewDownloadDialog.this.magmaTF.setText(string);
            }
        }
    }
}

