/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PlainMultiLinePanel;
import phex.utils.Localizer;

public class SelectNetworkDialog
extends JDialog {
    private JComboBox networkCbx;
    private JCheckBox autoJoinNetworkChkbx;
    private JCheckBox autoConnectChkbx;

    public SelectNetworkDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("SelectNet_SelectNetwork"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SelectNetworkDialog.this.closeDialog(false);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, right:d, 4dlu, max(200dlu;d):grow", "p, 3dlu, p:grow, 6dlu, p, 3dlu, p, 3dlu, p, 9dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.addSeparator(Localizer.getString("SelectNet_SelectNetworkToJoin"), cellConstraints.xywh(1, 1, 4, 1));
        PlainMultiLinePanel plainMultiLinePanel = new PlainMultiLinePanel(Localizer.getString("SelectNet_NetworkSelectionText"));
        panelBuilder.add((Component)plainMultiLinePanel, cellConstraints.xywh(2, 3, 3, 1));
        this.networkCbx = new JComboBox();
        this.networkCbx.setEditable(true);
        this.networkCbx.addItem(Cfg.DEFAULT_NETWORK_TO_USE);
        if (Cfg.DEFAULT_NETWORK_TO_USE != "<General Gnutella Network>") {
            this.networkCbx.addItem("<General Gnutella Network>");
        }
        for (int i = 0; i < ServiceManager.sCfg.mNetNetworkHistory.size(); ++i) {
            this.networkCbx.addItem(ServiceManager.sCfg.mNetNetworkHistory.get(i));
        }
        NetworkManager networkManager = NetworkManager.getInstance();
        this.networkCbx.setSelectedItem(networkManager.getGnutellaNetwork().getName());
        panelBuilder.addLabel(Localizer.getString("SelectNet_NetworkName"), cellConstraints.xy(2, 5));
        panelBuilder.add((Component)this.networkCbx, cellConstraints.xy(4, 5));
        this.autoJoinNetworkChkbx = new JCheckBox(Localizer.getString("SelectNet_AutoJoinNetwork"), ServiceManager.sCfg.mAutoJoin);
        panelBuilder.add((Component)this.autoJoinNetworkChkbx, cellConstraints.xywh(2, 7, 3, 1));
        this.autoConnectChkbx = new JCheckBox(Localizer.getString("SelectNet_AutoConnectNetwork"), ServiceManager.sCfg.mAutoConnect);
        panelBuilder.add((Component)this.autoConnectChkbx, cellConstraints.xywh(2, 9, 3, 1));
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.addActionListener(buttonActionHandler);
        jButton.setActionCommand("OK");
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.addActionListener(buttonActionHandler);
        jButton2.setActionCommand("CANCEL");
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton, jButton2);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(1, 11, 4, 1));
        container.validate();
        jPanel.doLayout();
        jPanel.revalidate();
        this.doLayout();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog(boolean bl) {
        if (bl) {
            ServiceManager.sCfg.save();
            NetworkManager.getInstance().leaveNetwork();
            NetworkManager.getInstance().joinNetwork();
        }
        this.setVisible(false);
        this.dispose();
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if (actionEvent.getActionCommand().equals("OK")) {
                boolean bl2;
                boolean bl3;
                String string = (String)SelectNetworkDialog.this.networkCbx.getEditor().getItem();
                if ((string = string.trim()).length() == 0) {
                    string = Cfg.DEFAULT_NETWORK_TO_USE;
                }
                if (!ServiceManager.sCfg.mCurrentNetwork.equals(string)) {
                    ServiceManager.sCfg.mCurrentNetwork = string;
                    bl = true;
                }
                if (ServiceManager.sCfg.mAutoJoin != (bl3 = SelectNetworkDialog.this.autoJoinNetworkChkbx.isSelected())) {
                    ServiceManager.sCfg.mAutoJoin = bl3;
                    bl = true;
                }
                if (ServiceManager.sCfg.mAutoConnect != (bl2 = SelectNetworkDialog.this.autoConnectChkbx.isSelected())) {
                    ServiceManager.sCfg.mAutoConnect = bl2;
                    bl = true;
                }
                if (!string.equals("<General Gnutella Network>")) {
                    ServiceManager.sCfg.mNetNetworkHistory.remove(string);
                    ServiceManager.sCfg.mNetNetworkHistory.add(0, string);
                    if (ServiceManager.sCfg.mNetNetworkHistory.size() > 20) {
                        ServiceManager.sCfg.mNetNetworkHistory.remove(20);
                    }
                    bl = true;
                }
            }
            SelectNetworkDialog.this.closeDialog(bl);
        }
    }
}

