/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;
import phex.utils.Logger;

public class DebugPane
extends OptionsSettingsPane {
    private JComboBox logLevelCbBx;
    private JCheckBox performanceTypeChkbx;
    private JCheckBox guiTypeChkbx;
    private JCheckBox netTypeChkbx;
    private JCheckBox searchTypeChkbx;
    private JCheckBox uploadTypeChkbx;
    private JCheckBox downloadTypeChkbx;
    private JCheckBox downloadNetTypeChkbx;

    public DebugPane() {
        super("DebugSettings_Debug");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, d, 6dlu, d, 6dlu, d, 6dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        formLayout.setColumnGroups(new int[][]{{2, 4, 6}});
        formLayout.setRowGroups(new int[][]{{3, 5, 7}});
        jPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("DebugSettings_DebugSettings"), cellConstraints.xywh(1, 1, 7, 1));
        this.downloadTypeChkbx = new JCheckBox(Localizer.getString("Download"), Logger.isTypeLogged((short)2));
        this.downloadTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTDownloadType"));
        panelBuilder.add((Component)this.downloadTypeChkbx, cellConstraints.xy(2, 3));
        this.uploadTypeChkbx = new JCheckBox(Localizer.getString("Upload"), Logger.isTypeLogged((short)4));
        this.uploadTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTUploadType"));
        panelBuilder.add((Component)this.uploadTypeChkbx, cellConstraints.xy(4, 3));
        this.searchTypeChkbx = new JCheckBox(Localizer.getString("Search"), Logger.isTypeLogged((short)8));
        this.searchTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTSearchType"));
        panelBuilder.add((Component)this.searchTypeChkbx, cellConstraints.xy(6, 3));
        this.downloadNetTypeChkbx = new JCheckBox(Localizer.getString("DownloadNet"), Logger.isTypeLogged((short)128));
        this.downloadNetTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTDownloadNetType"));
        panelBuilder.add((Component)this.downloadNetTypeChkbx, cellConstraints.xy(8, 3));
        this.netTypeChkbx = new JCheckBox(Localizer.getString("Network"), Logger.isTypeLogged((short)16));
        this.netTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTNetworkType"));
        panelBuilder.add((Component)this.netTypeChkbx, cellConstraints.xy(2, 5));
        this.guiTypeChkbx = new JCheckBox(Localizer.getString("GUI"), Logger.isTypeLogged((short)32));
        this.guiTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTGuiType"));
        panelBuilder.add((Component)this.guiTypeChkbx, cellConstraints.xy(4, 5));
        this.performanceTypeChkbx = new JCheckBox(Localizer.getString("Performance"), Logger.isTypeLogged((short)64));
        this.performanceTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTPerformanceType"));
        panelBuilder.add((Component)this.performanceTypeChkbx, cellConstraints.xy(6, 5));
        JLabel jLabel = panelBuilder.addLabel(Localizer.getString("DebugSettings_LogLevel") + ": ", cellConstraints.xy(2, 7));
        jLabel.setToolTipText(Localizer.getString("DebugSettings_TTTLogLevel"));
        String[] stringArray = new String[]{"Finest", "Finer", "Fine", "Config", "Info", "Warning", "Severe"};
        this.logLevelCbBx = new JComboBox<String>(stringArray);
        this.logLevelCbBx.setSelectedIndex(Logger.getVerboseLevel());
        this.logLevelCbBx.setToolTipText(Localizer.getString("DebugSettings_TTTLogLevel"));
        panelBuilder.add((Component)this.logLevelCbBx, cellConstraints.xy(4, 7));
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        short s = (short)this.logLevelCbBx.getSelectedIndex();
        if (ServiceManager.sCfg.loggerVerboseLevel != s) {
            ServiceManager.sCfg.loggerVerboseLevel = s;
            Logger.setVerboseLevel(ServiceManager.sCfg.loggerVerboseLevel);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        short s2 = 1;
        if (this.downloadTypeChkbx.isSelected()) {
            s2 |= 2;
        }
        if (this.uploadTypeChkbx.isSelected()) {
            s2 |= 4;
        }
        if (this.searchTypeChkbx.isSelected()) {
            s2 |= 8;
        }
        if (this.netTypeChkbx.isSelected()) {
            s2 |= 0x10;
        }
        if (this.guiTypeChkbx.isSelected()) {
            s2 |= 0x20;
        }
        if (this.performanceTypeChkbx.isSelected()) {
            s2 |= 0x40;
        }
        if (this.downloadNetTypeChkbx.isSelected()) {
            s2 |= 0x80;
        }
        if (ServiceManager.sCfg.logType != s2) {
            ServiceManager.sCfg.logType = s2;
            Logger.setLogType(ServiceManager.sCfg.logType);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }
}

