/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import phex.common.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;

public class DirectoriesPane
extends OptionsSettingsPane {
    private static final String DIRECTORY_ERROR_KEY = "DirectoryErrorKey";
    private static final String DOWNLOAD_DIRECTORY_KEY = "DownloadDirectory";
    private static final String INCOMPLETE_DIRECTORY_KEY = "IncompleteDirectory";
    private static final String INCOMPLETE_DIR_SHARED = "IncompleteDirShared";
    private static final String NO_DIRECTORY_SHARED = "NoDirectoryShared";
    private static final String CANT_CREATE_DOWNLOAD_DIR = "CantCreateDownloadDir";
    private static final String CANT_CREATE_INCOMPLETE_DIR = "CantCreateIncompleteDir";
    private JTextField incompleteDirectoryTF;
    private JTextField downloadDirectoryTF;

    public DirectoriesPane() {
        super("Directories");
    }

    protected void prepareComponent() {
        FormLayout formLayout = new FormLayout("10dlu, right:d, 2dlu, d:grow, 2dlu, d, 2dlu", "p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 15dlu:grow, 3dlu, p, 3dlu, p, 3dlu, p");
        formLayout.setRowGroups(new int[][]{{3, 5, 9, 11, 14, 16, 18}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("DirSettings_DownloadFolders"), cellConstraints.xywh(1, 1, 7, 1));
        panelBuilder.addLabel(Localizer.getString("DirSettings_Incomplete") + ": ", cellConstraints.xy(2, 3));
        this.incompleteDirectoryTF = new JTextField(ServiceManager.sCfg.incompleteDir);
        panelBuilder.add((Component)this.incompleteDirectoryTF, cellConstraints.xy(4, 3));
        JButton jButton = new JButton(Localizer.getString("DirSettings_SetFolder"));
        jButton.addActionListener(new SetIncompleteDirectoryListener());
        panelBuilder.add((Component)jButton, cellConstraints.xy(6, 3));
        panelBuilder.addLabel(Localizer.getString("DirSettings_Completed") + ": ", cellConstraints.xy(2, 5));
        this.downloadDirectoryTF = new JTextField(ServiceManager.sCfg.mDownloadDir);
        panelBuilder.add((Component)this.downloadDirectoryTF, cellConstraints.xy(4, 5));
        jButton = new JButton(Localizer.getString("DirSettings_SetFolder"));
        jButton.addActionListener(new SetDownlodDirectoryListener());
        panelBuilder.add((Component)jButton, cellConstraints.xy(6, 5));
    }

    public void checkInput(HashMap hashMap) {
        boolean bl;
        File file = null;
        String string = this.downloadDirectoryTF.getText();
        file = new File(string);
        String string2 = this.incompleteDirectoryTF.getText();
        File file2 = new File(string2);
        if (!(file.exists() && file.isDirectory() || (bl = file.mkdirs()))) {
            hashMap.put(DIRECTORY_ERROR_KEY, CANT_CREATE_DOWNLOAD_DIR);
            this.setInputValid(hashMap, false);
            return;
        }
        if (!(file2.exists() && file2.isDirectory() || (bl = file2.mkdirs()))) {
            hashMap.put(DIRECTORY_ERROR_KEY, CANT_CREATE_INCOMPLETE_DIR);
            this.setInputValid(hashMap, false);
            return;
        }
        hashMap.put(DOWNLOAD_DIRECTORY_KEY, file);
        hashMap.put(INCOMPLETE_DIRECTORY_KEY, file2);
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        Object v = hashMap.get(DIRECTORY_ERROR_KEY);
        if (v == null) {
            return;
        }
        if (v.equals(INCOMPLETE_DIR_SHARED)) {
            this.incompleteDirectoryTF.requestFocus();
            this.incompleteDirectoryTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString(INCOMPLETE_DIR_SHARED), Localizer.getString("DirectoryError"));
        } else if (v.equals(NO_DIRECTORY_SHARED)) {
            GUIUtils.showErrorMessage(Localizer.getString(NO_DIRECTORY_SHARED), Localizer.getString("DirectoryError"));
        } else if (v.equals(CANT_CREATE_DOWNLOAD_DIR)) {
            this.downloadDirectoryTF.requestFocus();
            this.downloadDirectoryTF.selectAll();
            Object[] objectArray = new String[]{this.downloadDirectoryTF.getText()};
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_DOWNLOAD_DIR, objectArray), Localizer.getString("DirectoryError"));
        } else if (v.equals(CANT_CREATE_INCOMPLETE_DIR)) {
            this.incompleteDirectoryTF.requestFocus();
            this.incompleteDirectoryTF.selectAll();
            Object[] objectArray = new String[]{this.incompleteDirectoryTF.getText()};
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_INCOMPLETE_DIR, objectArray), Localizer.getString("DirectoryError"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        File file;
        String string;
        File file2 = (File)hashMap.get(DOWNLOAD_DIRECTORY_KEY);
        String string2 = file2.getAbsolutePath();
        if (!ServiceManager.sCfg.mDownloadDir.equals(string2)) {
            ServiceManager.sCfg.mDownloadDir = string2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.incompleteDir.equals(string = (file = (File)hashMap.get(INCOMPLETE_DIRECTORY_KEY)).getAbsolutePath())) {
            ServiceManager.sCfg.incompleteDir = string;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private class SetIncompleteDirectoryListener
    implements ActionListener {
        private SetIncompleteDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(DirectoriesPane.this.incompleteDirectoryTF.getText()));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(Localizer.getString("SelectIncompleteDirectory"));
            jFileChooser.setApproveButtonText(Localizer.getString("Select"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.incompleteDirectoryTF.setText(string);
            }
        }
    }

    private class SetDownlodDirectoryListener
    implements ActionListener {
        private SetDownlodDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(DirectoriesPane.this.downloadDirectoryTF.getText()));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(Localizer.getString("SelectDownloadDirectory"));
            jFileChooser.setApproveButtonText(Localizer.getString("Select"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.downloadDirectoryTF.setText(string);
            }
        }
    }

    private class AddUploadDirectoryListener
    implements ActionListener {
        private AddUploadDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setDialogTitle(Localizer.getString("AddUploadDirectories"));
            jFileChooser.setApproveButtonText(Localizer.getString("Add"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("AddDirectoryMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
            }
        }
    }
}

