/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JCheckBox;
import phex.common.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DownloadPane
extends OptionsSettingsPane {
    private static final String WORKER_PER_DOWNLOAD_KEY = "WorkerPerDownload";
    private static final String MAX_TOTAL_WORKER_KEY = "TotalWorker";
    private static final String PUSH_TIMEOUT_KEY = "PushTimeout";
    private static final String INITIAL_SEGMENT_SIZE_KEY = "InitialSegmentSize";
    private static final String SEGMENT_TRANSFER_TIME_KEY = "SegmentTransferTime";
    private IntegerTextField totalWorkersTF;
    private IntegerTextField workerPerDownloadTF;
    private IntegerTextField pushTimeoutTF;
    private IntegerTextField initialSegmentSizeTF;
    private IntegerTextField segmentTransferTimeTF;
    private JCheckBox removeCompletedDownloadsChkbx;
    private JCheckBox enableHitSnoopingChkbx;

    public DownloadPane() {
        super("Download");
    }

    protected void prepareComponent() {
        FormLayout formLayout = new FormLayout("10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        formLayout.setRowGroups(new int[][]{{3, 5, 7, 9, 11, 13, 15, 17}});
        this.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("GeneralDownloadSettings"), cellConstraints.xywh(1, 1, 5, 1));
        panelBuilder.addLabel(Localizer.getString("TotalParallelDownloads") + ": ", cellConstraints.xy(2, 3));
        this.totalWorkersTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxTotalDownloadWorker), 6, 2);
        panelBuilder.add((Component)this.totalWorkersTF, cellConstraints.xy(4, 3));
        panelBuilder.addLabel(Localizer.getString("ParallelDownloadsPerFile") + ": ", cellConstraints.xy(2, 5));
        this.workerPerDownloadTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxWorkerPerDownload), 6, 2);
        panelBuilder.add((Component)this.workerPerDownloadTF, cellConstraints.xy(4, 5));
        panelBuilder.addLabel(Localizer.getString("InitialSegmentSizeKb") + ": ", cellConstraints.xy(2, 7));
        this.initialSegmentSizeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.initialSegmentSize / 1024), 6, 4);
        panelBuilder.add((Component)this.initialSegmentSizeTF, cellConstraints.xy(4, 7));
        panelBuilder.addLabel(Localizer.getString("SegmentTransferTimeSec") + ": ", cellConstraints.xy(2, 9));
        this.segmentTransferTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.segmentTransferTime), 6, 3);
        panelBuilder.add((Component)this.segmentTransferTimeTF, cellConstraints.xy(4, 9));
        panelBuilder.addLabel(Localizer.getString(PUSH_TIMEOUT_KEY) + ": ", cellConstraints.xy(2, 11));
        this.pushTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPushTransferTimeout / 1000), 6, 3);
        panelBuilder.add((Component)this.pushTimeoutTF, cellConstraints.xy(4, 11));
        this.removeCompletedDownloadsChkbx = new JCheckBox(Localizer.getString("AutoRemoveCompletedDownloads"), ServiceManager.sCfg.mDownloadAutoRemoveCompleted);
        panelBuilder.add((Component)this.removeCompletedDownloadsChkbx, cellConstraints.xywh(2, 13, 4, 1));
        this.enableHitSnoopingChkbx = new JCheckBox(Localizer.getString("EnableHitSnooping"), ServiceManager.sCfg.enableHitSnooping);
        panelBuilder.add((Component)this.enableHitSnoopingChkbx, cellConstraints.xywh(2, 15, 4, 1));
        this.initConfigValues();
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Number number;
        String string;
        try {
            string = this.workerPerDownloadTF.getText();
            number = new Short(string);
            hashMap.put(WORKER_PER_DOWNLOAD_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.workerPerDownloadTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.totalWorkersTF.getText();
            number = new Short(string);
            hashMap.put(MAX_TOTAL_WORKER_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.totalWorkersTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.initialSegmentSizeTF.getText();
            number = new Short(string);
            hashMap.put(INITIAL_SEGMENT_SIZE_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.initialSegmentSizeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.segmentTransferTimeTF.getText();
            number = new Short(string);
            hashMap.put(SEGMENT_TRANSFER_TIME_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.segmentTransferTimeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.pushTimeoutTF.getText();
            number = new Integer(string);
            hashMap.put(PUSH_TIMEOUT_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.pushTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        Integer n;
        int n2;
        Short s;
        short s2;
        Short s3;
        short s4;
        Short s5;
        short s6;
        Short s7 = (Short)hashMap.get(MAX_TOTAL_WORKER_KEY);
        short s8 = s7;
        if (ServiceManager.sCfg.maxTotalDownloadWorker != s8) {
            ServiceManager.sCfg.maxTotalDownloadWorker = s8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.initialSegmentSize != (s6 = (s5 = (Short)hashMap.get(INITIAL_SEGMENT_SIZE_KEY)).shortValue()) * 1024) {
            ServiceManager.sCfg.initialSegmentSize = s6 * 1024;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.segmentTransferTime != (s4 = (s3 = (Short)hashMap.get(SEGMENT_TRANSFER_TIME_KEY)).shortValue())) {
            ServiceManager.sCfg.segmentTransferTime = s4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxWorkerPerDownload != (s2 = (s = (Short)hashMap.get(WORKER_PER_DOWNLOAD_KEY)).shortValue())) {
            ServiceManager.sCfg.maxWorkerPerDownload = s2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mPushTransferTimeout != (n2 = (n = (Integer)hashMap.get(PUSH_TIMEOUT_KEY)).intValue()) * 1000) {
            ServiceManager.sCfg.mPushTransferTimeout = n2 * 1000;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted != (bl2 = this.removeCompletedDownloadsChkbx.isSelected())) {
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.enableHitSnooping != (bl = this.enableHitSnoopingChkbx.isSelected())) {
            ServiceManager.sCfg.enableHitSnooping = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
    }

    private void initConfigValues() {
    }
}

