/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LookAndFeelFailedException;
import phex.gui.common.LookAndFeelUtils;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.renderer.LAFListCellRenderer;
import phex.gui.renderer.LAFThemeListCellRenderer;
import phex.gui.tabs.search.SearchTab;
import phex.utils.Localizer;
import phex.utils.Logger;

public class GeneralUIPane
extends OptionsSettingsPane {
    private static final String INSTANCIATED_LAF_KEY = "InstanciatedLAF";
    private static final String INSTANCIATED_THEME_KEY = "InstanciatedLAFTheme";
    private static final String LAF_ERROR_KEY = "LAFError";
    private static final String LAF_NOT_SUPPORTED = "LAFNotSupported";
    private static final String LAF_NOT_FOUND = "LAFNotFound";
    private static final String LAF_ACCESS_ERROR = "LAFAccessError";
    private static final String LAF_INSTANTIATION_ERROR = "LAFInstantiationError";
    private static final String THEME_NOT_FOUND = "ThemeNotFound";
    private static final String THEME_ACCESS_ERROR = "ThemeAccessError";
    private static final String THEME_INSTANTIATION_ERROR = "ThemeInstantiationError";
    private GUIRegistry guiRegistry = GUIRegistry.getInstance();
    private JComboBox lafBox;
    private DefaultComboBoxModel themeModel;
    private JComboBox themeBox;
    private JCheckBox displayTooltipChkbx;
    private JCheckBox showTableHorizontalLinesChkbx;
    private JCheckBox showTableVerticalLinesChkbx;
    private JCheckBox minimizeWhenClosingChkbx;

    public GeneralUIPane() {
        super("General");
    }

    public void checkInput(HashMap hashMap) {
        Object object;
        Object object2;
        hashMap.remove(INSTANCIATED_LAF_KEY);
        hashMap.remove(LAF_ERROR_KEY);
        hashMap.remove(INSTANCIATED_THEME_KEY);
        UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        try {
            object2 = Class.forName(lookAndFeelInfo.getClassName());
            object = (LookAndFeel)((Class)object2).newInstance();
            if (!((LookAndFeel)object).isSupportedLookAndFeel()) {
                hashMap.put(LAF_ERROR_KEY, LAF_NOT_SUPPORTED);
                this.setInputValid(hashMap, false);
                return;
            }
            hashMap.put(INSTANCIATED_LAF_KEY, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            hashMap.put(LAF_ERROR_KEY, LAF_NOT_FOUND);
            this.setInputValid(hashMap, false);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            hashMap.put(LAF_ERROR_KEY, LAF_ACCESS_ERROR);
            this.setInputValid(hashMap, false);
            return;
        }
        catch (InstantiationException instantiationException) {
            hashMap.put(LAF_ERROR_KEY, LAF_INSTANTIATION_ERROR);
            this.setInputValid(hashMap, false);
            return;
        }
        object2 = (LookAndFeelUtils.ThemeInfo)this.themeBox.getSelectedItem();
        object = LookAndFeelUtils.getCurrentTheme(UIManager.getLookAndFeel().getClass().getName());
        if (object2 != null && object != null && ((LookAndFeelUtils.ThemeInfo)object2).getClassName().equals(((LookAndFeelUtils.ThemeInfo)object).getClassName())) {
            object2 = null;
        }
        if (object2 != null) {
            try {
                Class<?> clazz = Class.forName(((LookAndFeelUtils.ThemeInfo)object2).getClassName());
                Object obj = clazz.newInstance();
                hashMap.put(INSTANCIATED_THEME_KEY, obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                hashMap.put(LAF_ERROR_KEY, THEME_NOT_FOUND);
                this.setInputValid(hashMap, false);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                hashMap.put(LAF_ERROR_KEY, THEME_ACCESS_ERROR);
                this.setInputValid(hashMap, false);
                return;
            }
            catch (InstantiationException instantiationException) {
                hashMap.put(LAF_ERROR_KEY, THEME_INSTANTIATION_ERROR);
                this.setInputValid(hashMap, false);
                return;
            }
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        Object v = hashMap.get(LAF_ERROR_KEY);
        if (v != null) {
            JOptionPane.showMessageDialog(this, Localizer.getString((String)v), Localizer.getString(LAF_ERROR_KEY), 0);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        Object v;
        LookAndFeel lookAndFeel = (LookAndFeel)hashMap.get(INSTANCIATED_LAF_KEY);
        if (!UIManager.getLookAndFeel().getClass().getName().equals(lookAndFeel.getClass().getName())) {
            try {
                LookAndFeelUtils.setLookAndFeel(lookAndFeel);
            }
            catch (LookAndFeelFailedException lookAndFeelFailedException) {
                JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + lookAndFeel.getName(), "Error", 0);
            }
        }
        if ((v = hashMap.get(INSTANCIATED_THEME_KEY)) != null) {
            LookAndFeelUtils.setCurrentTheme(lookAndFeel.getClass().getName(), v);
        }
        if (ServiceManager.sCfg.mUIDisplayTooltip != (bl2 = this.displayTooltipChkbx.isSelected())) {
            ServiceManager.sCfg.mUIDisplayTooltip = bl2;
            ToolTipManager.sharedInstance().setEnabled(bl2);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.minimizeToBackground != (bl = this.minimizeWhenClosingChkbx.isSelected())) {
            ServiceManager.sCfg.minimizeToBackground = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        boolean bl3 = false;
        boolean bl4 = this.showTableHorizontalLinesChkbx.isSelected();
        if (this.guiRegistry.getShowTableHorizontalLines() != bl4) {
            this.guiRegistry.setShowTableHorizontalLines(bl4);
            bl3 = true;
        }
        boolean bl5 = this.showTableVerticalLinesChkbx.isSelected();
        if (this.guiRegistry.getShowTableVerticalLines() != bl5) {
            this.guiRegistry.setShowTableVerticalLines(bl5);
            bl3 = true;
        }
        if (bl3) {
            GUIUtils.updateComponentsUI();
        }
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 5dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 5dlu, p");
        formLayout.setRowGroups(new int[][]{{3, 5, 7, 9, 11}});
        jPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("GeneralUserInterfaceSettings"), cellConstraints.xywh(1, 1, 5, 1));
        JLabel jLabel = panelBuilder.addLabel(Localizer.getString("LookAndFeel"), cellConstraints.xy(2, 3));
        jLabel.setToolTipText(Localizer.getString("TTTLookAndFeel"));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = LookAndFeelUtils.getAvailableLAFs();
        this.lafBox = new JComboBox<UIManager.LookAndFeelInfo>(lookAndFeelInfoArray);
        this.lafBox.addItemListener(new LAFItemListener());
        int n = this.determineCurrentLAFIndex(lookAndFeelInfoArray);
        this.lafBox.setSelectedIndex(n);
        this.lafBox.setRenderer(new LAFListCellRenderer());
        this.lafBox.setToolTipText(Localizer.getString("TTTLookAndFeel"));
        panelBuilder.add((Component)this.lafBox, cellConstraints.xy(4, 3));
        JLabel jLabel2 = panelBuilder.addLabel(Localizer.getString("ColorTheme"), cellConstraints.xy(2, 5));
        jLabel2.setToolTipText(Localizer.getString("TTTColorTheme"));
        this.themeModel = new DefaultComboBoxModel();
        this.themeBox = new JComboBox(this.themeModel);
        this.themeBox.setToolTipText(Localizer.getString("TTTColorTheme"));
        panelBuilder.add((Component)this.themeBox, cellConstraints.xy(4, 5));
        UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        this.updateThemes(lookAndFeelInfo);
        this.themeBox.setRenderer(new LAFThemeListCellRenderer());
        this.displayTooltipChkbx = new JCheckBox(Localizer.getString("DisplayTooltipText"), ServiceManager.sCfg.mUIDisplayTooltip);
        this.displayTooltipChkbx.setToolTipText(Localizer.getString("TTTDisplayTooltipText"));
        panelBuilder.add((Component)this.displayTooltipChkbx, cellConstraints.xywh(2, 7, 3, 1));
        this.showTableHorizontalLinesChkbx = new JCheckBox(Localizer.getString("ShowTableHorizontalLines"), this.guiRegistry.getShowTableHorizontalLines());
        this.showTableHorizontalLinesChkbx.setToolTipText(Localizer.getString("TTTShowTableHorizontalLines"));
        panelBuilder.add((Component)this.showTableHorizontalLinesChkbx, cellConstraints.xywh(2, 9, 3, 1));
        this.showTableVerticalLinesChkbx = new JCheckBox(Localizer.getString("ShowTableVerticalLines"), this.guiRegistry.getShowTableVerticalLines());
        this.showTableVerticalLinesChkbx.setToolTipText(Localizer.getString("TTTShowTableVerticalLines"));
        panelBuilder.add((Component)this.showTableVerticalLinesChkbx, cellConstraints.xywh(2, 11, 3, 1));
        String string = GUIRegistry.getInstance().getDesktopIndicator() != null ? Localizer.getString("WhenClosingMinToSysTray") : Localizer.getString("WhenClosingMinToBackground");
        this.minimizeWhenClosingChkbx = new JCheckBox(string, ServiceManager.sCfg.minimizeToBackground);
        panelBuilder.add((Component)this.minimizeWhenClosingChkbx, cellConstraints.xywh(2, 13, 3, 1));
        JButton jButton = new JButton(Localizer.getString("UISettings_ClearSearchHistory"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
                SearchTab searchTab = (SearchTab)mainFrame.getTab(1101);
                searchTab.clearSearchHistory();
            }
        });
        panelBuilder.add((Component)jButton, cellConstraints.xywh(2, 15, 3, 1, "left,center"));
    }

    private int determineCurrentLAFIndex(UIManager.LookAndFeelInfo[] lookAndFeelInfoArray) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getClass().getName();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            if (!string.equals(lookAndFeelInfoArray[i].getClassName())) continue;
            return i;
        }
        return -1;
    }

    private int determineCurrentThemeIndex(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelUtils.ThemeInfo themeInfo = LookAndFeelUtils.getCurrentTheme(lookAndFeelInfo.getClassName());
        if (themeInfo == null) {
            return -1;
        }
        return this.themeModel.getIndexOf(themeInfo);
    }

    private void updateThemes(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelUtils.ThemeInfo[] themeInfoArray = LookAndFeelUtils.getAvailableThemes(lookAndFeelInfo.getClassName());
        this.themeModel = new DefaultComboBoxModel<LookAndFeelUtils.ThemeInfo>(themeInfoArray);
        this.themeBox.setModel(this.themeModel);
        int n = this.determineCurrentThemeIndex(lookAndFeelInfo);
        this.themeBox.setSelectedIndex(n);
    }

    private class LAFItemListener
    implements ItemListener {
        private LAFItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                if (itemEvent.getStateChange() == 1) {
                    UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)itemEvent.getItem();
                    GeneralUIPane.this.updateThemes(lookAndFeelInfo);
                }
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }
}

