/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IPTextField;
import phex.gui.common.IntegerTextField;
import phex.gui.common.PlainMultiLinePanel;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.IPUtils;
import phex.utils.Localizer;

public class ProxyPane
extends OptionsSettingsPane {
    private static final String EXPORT_IP_KEY = "ExportIP";
    private static final String SOCKS5_PROXY_PORT_KEY = "SOCKS5ProxyPort";
    private static final String HTTP_PROXY_PORT_KEY = "HTTPProxyPort";
    private static final String EXPORT_IP_ERROR_KEY = "ExportIPError";
    private static final String WRONG_EXPORT_IP_FORMAT = "WrongExportIPFormat";
    private IPTextField exportIPTF;
    private JCheckBox socks5ProxyCkbx;
    private JLabel socks5HostLabel;
    private JTextField socks5ProxyHostTF;
    private JLabel socks5PortLabel;
    private IntegerTextField socks5ProxyPortTF;
    private JCheckBox socks5AuthenticationCkbx;
    private JLabel socks5UserLabel;
    private JTextField socks5UserNameTF;
    private JLabel socks5PasswordLabel;
    private JPasswordField socks5PasswordTF;
    private JCheckBox httpProxyCkbx;
    private PlainMultiLinePanel infoLabel;
    private JLabel httpHostLabel;
    private JTextField httpProxyHostTF;
    private JLabel httpPortLabel;
    private IntegerTextField httpProxyPortTF;

    public ProxyPane() {
        super("FirewallProxy");
    }

    protected void prepareComponent() {
        FormLayout formLayout = new FormLayout("10dlu, right:d, 2dlu, d, 10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 6dlu, p, 3dlu, fill:d:grow, 3dlu, p, 3dlu, p, 6dlu");
        formLayout.setRowGroups(new int[][]{{3, 5, 9, 11, 13, 15, 21}});
        this.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("FirewallSettings"), cellConstraints.xywh(1, 1, 9, 1));
        panelBuilder.addLabel(Localizer.getString("ExportIPAs") + ": ", cellConstraints.xy(2, 3));
        this.exportIPTF = new IPTextField();
        this.exportIPTF.setIPString(ServiceManager.sCfg.mMyIP);
        panelBuilder.add((Component)this.exportIPTF, cellConstraints.xy(4, 3));
        panelBuilder.addSeparator(Localizer.getString("SOCKSSettings"), cellConstraints.xywh(1, 5, 9, 1));
        this.socks5ProxyCkbx = new JCheckBox(Localizer.getString("UseSocks5Proxy"), ServiceManager.sCfg.mProxyUse);
        this.socks5ProxyCkbx.addActionListener(new CheckboxActionListener());
        panelBuilder.add((Component)this.socks5ProxyCkbx, cellConstraints.xywh(2, 7, 3, 1));
        this.socks5HostLabel = panelBuilder.addLabel(Localizer.getString("ProxyHostIP") + ": ", cellConstraints.xy(2, 9));
        this.socks5ProxyHostTF = new JTextField(ServiceManager.sCfg.mProxyHost, 15);
        panelBuilder.add((Component)this.socks5ProxyHostTF, cellConstraints.xy(4, 9));
        this.socks5PortLabel = panelBuilder.addLabel(Localizer.getString("Port") + ": ", cellConstraints.xy(6, 9));
        this.socks5ProxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mProxyPort), 5, 5);
        panelBuilder.add((Component)this.socks5ProxyPortTF, cellConstraints.xy(8, 9));
        this.socks5AuthenticationCkbx = new JCheckBox(Localizer.getString("Authentication"), ServiceManager.sCfg.useProxyAuthentication);
        this.socks5AuthenticationCkbx.addActionListener(new CheckboxActionListener());
        panelBuilder.add((Component)this.socks5AuthenticationCkbx, cellConstraints.xywh(2, 11, 3, 1));
        this.socks5UserLabel = panelBuilder.addLabel(Localizer.getString("Username") + ": ", cellConstraints.xy(2, 13));
        this.socks5UserNameTF = new JTextField(ServiceManager.sCfg.mProxyUserName, 10);
        panelBuilder.add((Component)this.socks5UserNameTF, cellConstraints.xy(4, 13));
        this.socks5PasswordLabel = panelBuilder.addLabel(Localizer.getString("Password") + ": ", cellConstraints.xy(6, 13));
        this.socks5PasswordTF = new JPasswordField(ServiceManager.sCfg.mProxyPassword, 10);
        panelBuilder.add((Component)this.socks5PasswordTF, cellConstraints.xy(8, 13));
        panelBuilder.addSeparator(Localizer.getString("HTTPProxySettings"), cellConstraints.xywh(1, 15, 9, 1));
        this.infoLabel = new PlainMultiLinePanel(Localizer.getString("HttpProxyInfoText"));
        panelBuilder.add((Component)this.infoLabel, cellConstraints.xywh(2, 17, 8, 1));
        this.httpProxyCkbx = new JCheckBox(Localizer.getString("UseHTTPProxy"), ServiceManager.sCfg.isHttpProxyUsed);
        this.httpProxyCkbx.addActionListener(new CheckboxActionListener());
        panelBuilder.add((Component)this.httpProxyCkbx, cellConstraints.xywh(2, 19, 3, 1));
        this.httpHostLabel = panelBuilder.addLabel(Localizer.getString("ProxyHostIP") + ": ", cellConstraints.xy(2, 21));
        this.httpProxyHostTF = new JTextField(ServiceManager.sCfg.httpProxyHost, 15);
        panelBuilder.add((Component)this.httpProxyHostTF, cellConstraints.xy(4, 21));
        this.httpPortLabel = panelBuilder.addLabel(Localizer.getString("Port") + ": ", cellConstraints.xy(6, 21));
        this.httpProxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.httpProxyPort), 5, 5);
        panelBuilder.add((Component)this.httpProxyPortTF, cellConstraints.xy(8, 21));
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        if (!this.exportIPTF.isFieldEmpty()) {
            if (this.exportIPTF.isInputValid()) {
                hashMap.put(EXPORT_IP_KEY, this.exportIPTF.getIP());
            } else {
                hashMap.put(EXPORT_IP_ERROR_KEY, WRONG_EXPORT_IP_FORMAT);
                this.setInputValid(hashMap, false);
                return;
            }
        }
        try {
            string = this.socks5ProxyPortTF.getText();
            n = new Integer(string);
            hashMap.put(SOCKS5_PROXY_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            string = this.httpProxyPortTF.getText();
            n = new Integer(string);
            hashMap.put(HTTP_PROXY_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
        if (hashMap.containsKey(EXPORT_IP_ERROR_KEY)) {
            this.exportIPTF.requestFocus();
            GUIUtils.showErrorMessage(Localizer.getString(WRONG_EXPORT_IP_FORMAT), Localizer.getString("IPFormatError"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        String string;
        String string2;
        String string3;
        boolean bl;
        String string4;
        boolean bl2;
        byte[] byArray = (byte[])hashMap.get(EXPORT_IP_KEY);
        String string5 = "";
        if (byArray != null) {
            string5 = IPUtils.ip2string(byArray);
        }
        if (!ServiceManager.sCfg.mMyIP.equals(string5)) {
            NetworkManager.getInstance().setForcedHostIP(byArray);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mProxyUse != (bl2 = this.socks5ProxyCkbx.isSelected())) {
            ServiceManager.sCfg.mProxyUse = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            GUIRegistry.getInstance().getMainFrame().setTitle();
        }
        if (!ServiceManager.sCfg.mProxyHost.equals(string4 = this.socks5ProxyHostTF.getText())) {
            ServiceManager.sCfg.mProxyHost = string4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        Integer n = (Integer)hashMap.get(SOCKS5_PROXY_PORT_KEY);
        int n2 = 1080;
        if (n != null) {
            n2 = n;
        }
        if (ServiceManager.sCfg.mProxyPort != n2) {
            ServiceManager.sCfg.mProxyPort = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.useProxyAuthentication != (bl = this.socks5AuthenticationCkbx.isSelected())) {
            ServiceManager.sCfg.useProxyAuthentication = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.mProxyUserName.equals(string3 = this.socks5UserNameTF.getText())) {
            ServiceManager.sCfg.mProxyUserName = string3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.mProxyPassword.equals(string2 = new String(this.socks5PasswordTF.getPassword()))) {
            ServiceManager.sCfg.mProxyPassword = string2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        boolean bl3 = false;
        boolean bl4 = this.httpProxyCkbx.isSelected();
        if (ServiceManager.sCfg.isHttpProxyUsed != bl4) {
            ServiceManager.sCfg.isHttpProxyUsed = bl4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            bl3 = true;
        }
        if (!ServiceManager.sCfg.httpProxyHost.equals(string = this.httpProxyHostTF.getText())) {
            ServiceManager.sCfg.httpProxyHost = string;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            bl3 = true;
        }
        Integer n3 = (Integer)hashMap.get(HTTP_PROXY_PORT_KEY);
        int n4 = 80;
        if (n3 != null) {
            n4 = n3;
        }
        if (ServiceManager.sCfg.httpProxyPort != n4) {
            ServiceManager.sCfg.httpProxyPort = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            bl3 = true;
        }
        if (bl3) {
            ServiceManager.sCfg.updateSystemSettings();
        }
    }

    private void refreshEnableState() {
        boolean bl = true;
        this.socks5ProxyCkbx.setEnabled(bl);
        boolean bl2 = this.socks5ProxyCkbx.isSelected();
        this.socks5HostLabel.setEnabled(bl && bl2);
        this.socks5ProxyHostTF.setEnabled(bl && bl2);
        this.socks5PortLabel.setEnabled(bl && bl2);
        this.socks5ProxyPortTF.setEnabled(bl && bl2);
        this.socks5AuthenticationCkbx.setEnabled(bl && bl2);
        this.socks5UserLabel.setEnabled(bl && bl2 && this.socks5AuthenticationCkbx.isSelected());
        this.socks5UserNameTF.setEnabled(bl && bl2 && this.socks5AuthenticationCkbx.isSelected());
        this.socks5PasswordLabel.setEnabled(bl && bl2 && this.socks5AuthenticationCkbx.isSelected());
        this.socks5PasswordTF.setEnabled(bl && bl2 && this.socks5AuthenticationCkbx.isSelected());
        this.httpHostLabel.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpProxyHostTF.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpPortLabel.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpProxyPortTF.setEnabled(this.httpProxyCkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProxyPane.this.refreshEnableState();
        }
    }
}

