/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.models.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected String[] tableColumns;
    protected Class[] tableClasses;
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel(Object object, String[] stringArray, Class[] classArray) {
        this.tableColumns = stringArray;
        this.tableClasses = classArray;
        this.root = object;
    }

    public String getColumnName(int n) {
        return this.tableColumns[n];
    }

    public int getColumnCount() {
        return this.tableColumns.length;
    }

    public Class getColumnClass(int n) {
        Class clazz = this.tableClasses[n];
        if (clazz == null) {
            clazz = String.class;
        }
        return clazz;
    }

    public Comparator getColumnComparator(int n) {
        return null;
    }

    public Object getComparableValueAt(Object object, int n) {
        return this.getValueAt(object, n);
    }

    public int mapColumnIDToModelIndex(int n) {
        throw new UnsupportedOperationException("Needs to be overloaded by the model.");
    }

    public boolean isColumnHideable(int n) {
        return true;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        for (int i = 0; i < this.getChildCount(object); ++i) {
            if (!this.getChild(object, i).equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    public void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    public void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    public void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public boolean isCellEditable(Object object, int n) {
        return this.getColumnClass(n) == TreeTableModel.class;
    }

    public void setValueAt(Object object, Object object2, int n) {
    }
}

