/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.TransferRateComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.renderer.DateCellRenderer;
import phex.gui.renderer.ProgressCellRenderer;
import phex.gui.renderer.TransferRateCellRenderer;
import phex.gui.renderer.TransferSizeCellRenderer;
import phex.utils.Localizer;

public class SWDownloadTableModel
extends FWSortableTableModel {
    private static final int FILE_COLUMN_ID = 1001;
    private static final int PROGRESS_COLUMN_ID = 1002;
    private static final int SIZE_COLUMN_ID = 1003;
    private static final int RATE_COLUMN_ID = 1004;
    private static final int STATUS_COLUMN_ID = 1005;
    private static final int CANDIDATE_COUNT_COLUMN_ID = 1006;
    private static final int SEARCH_TERM_COLUMN_ID = 1007;
    private static final int SHA1_COLUMN_ID = 1008;
    private static final int PRIORITY_COLUMN_ID = 1009;
    private static final int CREATED_TIME_COLUMN_ID = 1010;
    private static final int DOWNLOADED_TIME_COLUMN_ID = 1011;
    private static final int FILE_MODEL_INDEX = 0;
    private static final int PROGRESS_MODEL_INDEX = 1;
    private static final int SIZE_MODEL_INDEX = 2;
    private static final int RATE_MODEL_INDEX = 3;
    private static final int CANDIDATE_COUNT_MODEL_INDEX = 4;
    private static final int STATUS_MODEL_INDEX = 5;
    private static final int PRIORITY_MODEL_INDEX = 6;
    private static final int SEARCH_TERM_MODEL_INDEX = 7;
    private static final int CREATED_TIME_MODEL_INDEX = 8;
    private static final int DOWNLOADED_TIME_MODEL_INDEX = 9;
    private static final int SHA1_MODEL_INDEX = 10;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate"), Localizer.getString("NumberOfCandidates"), Localizer.getString("Status"), Localizer.getString("Priority"), Localizer.getString("SearchTerm"), Localizer.getString("Created"), Localizer.getString("Downloaded"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{String.class, ProgressCellRenderer.class, TransferSizeCellRenderer.class, TransferRateCellRenderer.class, String.class, String.class, Integer.class, String.class, DateCellRenderer.class, DateCellRenderer.class, String.class};
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();

    public SWDownloadTableModel() {
        super(tableColumns, tableClasses);
        this.swarmingMgr.addDownloadFilesChangeListener(new DownloadFilesListener());
    }

    public int getRowCount() {
        return this.swarmingMgr.getDownloadFileCount();
    }

    public Object getValueAt(int n, int n2) {
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n);
        if (sWDownloadFile == null) {
            this.fireTableRowsDeleted(n, n);
            return null;
        }
        switch (n2) {
            case 0: {
                return sWDownloadFile.getDestinationFile().getName();
            }
            case 1: {
                return sWDownloadFile.getProgress();
            }
            case 2: 
            case 3: {
                return sWDownloadFile;
            }
            case 4: {
                return String.valueOf(sWDownloadFile.getDownloadingCandidatesCountObject()) + " / " + String.valueOf(sWDownloadFile.getQueuedCandidatesCountObject()) + " / " + String.valueOf(sWDownloadFile.getCandidatesCountObject());
            }
            case 5: {
                return SWDownloadInfo.getDownloadFileStatusString(sWDownloadFile.getStatus());
            }
            case 6: {
                return this.swarmingMgr.getDownloadPriority(sWDownloadFile);
            }
            case 7: {
                return sWDownloadFile.getResearchSetting().getSearchTerm();
            }
            case 8: {
                return sWDownloadFile.getCreatedDate();
            }
            case 9: {
                return sWDownloadFile.getDownloadedDate();
            }
            case 10: {
                return sWDownloadFile.getResearchSetting().getSHA1();
            }
        }
        return "";
    }

    public Object getComparableValueAt(int n, int n2) {
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n);
        if (sWDownloadFile == null) {
            return "";
        }
        switch (n2) {
            case 4: {
                return sWDownloadFile.getCandidatesCountObject();
            }
        }
        return this.getValueAt(n, n2);
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 2: {
                return new TransferSizeComparator();
            }
            case 3: {
                return new TransferRateComparator();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1006: {
                return 4;
            }
            case 1005: {
                return 5;
            }
            case 1009: {
                return 6;
            }
            case 1007: {
                return 7;
            }
            case 1010: {
                return 8;
            }
            case 1011: {
                return 9;
            }
            case 1008: {
                return 10;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1006, 1005, 1009, 1007, 1010, 1011, 1008};
        return nArray;
    }

    private class DownloadFilesListener
    implements DownloadFilesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadFileChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SWDownloadTableModel.this, n, n, -1, 0));
        }

        public void downloadFileAdded(int n) {
            SWDownloadTableModel.this.fireTableChanged(new TableModelEvent(SWDownloadTableModel.this, n, n, -1, 1));
        }

        public void downloadFileRemoved(int n) {
            SWDownloadTableModel.this.fireTableChanged(new TableModelEvent(SWDownloadTableModel.this, n, n, -1, -1));
        }
    }
}

