/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.download.RemoteFile;
import phex.gui.models.AbstractTreeTableModel;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.ISortableModel;
import phex.gui.models.TreeTableModel;
import phex.gui.renderer.FileSizeCellRenderer;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.tabs.search.SearchResultElement;
import phex.utils.Localizer;

public class SearchTreeTableModel
extends AbstractTreeTableModel
implements TreeTableModel,
ISortableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int FILE_COLUMN_ID = 1002;
    public static final int EXTENSION_COLUMN_ID = 1003;
    public static final int SIZE_COLUMN_ID = 1004;
    public static final int SCORE_COLUMN_ID = 1005;
    public static final int HOST_RATING_COLUMN_ID = 1006;
    public static final int HOST_SPEED_COLUMN_ID = 1007;
    public static final int HOST_VENDOR_COLUMN_ID = 1008;
    public static final int META_DATA_COLUMN_ID = 1009;
    public static final int SHA1_COLUMN_ID = 1010;
    public static final int FILE_MODEL_INDEX = 0;
    public static final int EXTENSION_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int SCORE_MODEL_INDEX = 3;
    public static final int HOST_RATING_MODEL_INDEX = 4;
    public static final int HOST_SPEED_MODEL_INDEX = 5;
    public static final int HOST_MODEL_INDEX = 6;
    public static final int HOST_VENDOR_MODEL_INDEX = 7;
    public static final int META_DATA_MODEL_INDEX = 8;
    public static final int SHA1_MODEL_INDEX = 9;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Type"), Localizer.getString("Size"), Localizer.getString("Score"), Localizer.getString("Rating"), Localizer.getString("HostSpeed"), Localizer.getString("SharingHost"), Localizer.getString("Vendor"), Localizer.getString("Information"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{TreeTableModel.class, String.class, FileSizeCellRenderer.class, Short.class, Short.class, Integer.class, HostAddressCellRenderer.class, String.class, String.class, String.class};
    private static Object TREE_ROOT = new Object();
    private ISearchDataModel displayedDataModel;
    private int sortedColumn = -1;
    private boolean isAscending;

    public SearchTreeTableModel() {
        super(TREE_ROOT, tableColumns, tableClasses);
    }

    public void setDisplayedSearch(ISearchDataModel iSearchDataModel) {
        if (this.displayedDataModel != iSearchDataModel) {
            if (this.displayedDataModel != null) {
                this.displayedDataModel.setVisualizationModel(null);
            }
            this.displayedDataModel = iSearchDataModel;
            this.fireTreeStructureChanged(TREE_ROOT, new Object[]{TREE_ROOT}, null, null);
            if (this.displayedDataModel != null) {
                this.sortByColumn(this.sortedColumn, this.isAscending);
                this.displayedDataModel.setVisualizationModel(this);
            }
        }
    }

    public ISearchDataModel getDisplayedResultsData() {
        return this.displayedDataModel;
    }

    public Object getValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                RemoteFile remoteFile = this.getRemoteFile(object);
                return remoteFile.getDisplayName();
            }
            case 1: {
                return this.getRemoteFile(object).getFileExt();
            }
            case 2: {
                return this.getRemoteFile(object).getFileSizeObject();
            }
            case 8: {
                return this.getRemoteFile(object).getMetaData();
            }
            case 9: {
                return this.getRemoteFile(object).getSHA1();
            }
            case 3: {
                if (object instanceof SearchResultElement) {
                    return ((SearchResultElement)object).getValue(3);
                }
                return ((RemoteFile)object).getScore();
            }
            case 4: {
                if (object instanceof SearchResultElement) {
                    return ((SearchResultElement)object).getValue(4);
                }
                return ((RemoteFile)object).getQueryHitHost().getHostRatingObject();
            }
            case 5: {
                if (object instanceof SearchResultElement) {
                    return ((SearchResultElement)object).getValue(5);
                }
                return ((RemoteFile)object).getSpeedObject();
            }
            case 6: {
                if (object instanceof SearchResultElement) {
                    return ((SearchResultElement)object).getValue(6);
                }
                return ((RemoteFile)object).getHostAddress();
            }
            case 7: {
                if (object instanceof SearchResultElement) {
                    return ((SearchResultElement)object).getValue(7);
                }
                return ((RemoteFile)object).getQueryHitHost().getVendor();
            }
        }
        return "";
    }

    private RemoteFile getRemoteFile(Object object) {
        if (object instanceof SearchResultElement) {
            return ((SearchResultElement)object).getSingleRemoteFile();
        }
        return (RemoteFile)object;
    }

    public Object getChild(Object object, int n) {
        Object object2 = object == TREE_ROOT ? this.displayedDataModel.getSearchElementAt(n) : ((SearchResultElement)object).getRemoteFileAt(n);
        return object2;
    }

    public int getChildCount(Object object) {
        int n = object == TREE_ROOT && this.displayedDataModel != null ? this.displayedDataModel.getSearchElementCount() : (object instanceof SearchResultElement ? ((SearchResultElement)object).getRemoteFileListCount() : 0);
        return n;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 6;
            }
            case 1002: {
                return 0;
            }
            case 1003: {
                return 1;
            }
            case 1004: {
                return 2;
            }
            case 1005: {
                return 3;
            }
            case 1006: {
                return 4;
            }
            case 1007: {
                return 5;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
            case 1010: {
                return 9;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1002;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1002, 1003, 1004, 1005, 1006, 1007, 1001, 1008, 1009, 1010};
        return nArray;
    }

    public int getSortByColumn() {
        return this.sortedColumn;
    }

    public boolean isSortedAscending() {
        return this.isAscending;
    }

    public void sortByColumn(int n, boolean bl) {
        this.sortedColumn = n;
        this.isAscending = bl;
        switch (n) {
            case 2: {
                this.displayedDataModel.setSortBy(1, bl);
                break;
            }
            case 0: {
                this.displayedDataModel.setSortBy(2, bl);
                break;
            }
            case 1: {
                this.displayedDataModel.setSortBy(3, bl);
                break;
            }
            case 9: {
                this.displayedDataModel.setSortBy(4, bl);
                break;
            }
            case 6: {
                this.displayedDataModel.setSortBy(5, bl);
                break;
            }
            case 3: {
                this.displayedDataModel.setSortBy(10, bl);
                break;
            }
            case 4: {
                this.displayedDataModel.setSortBy(9, bl);
                break;
            }
            case 5: {
                this.displayedDataModel.setSortBy(8, bl);
                break;
            }
            case 7: {
                this.displayedDataModel.setSortBy(7, bl);
                break;
            }
            case 8: {
                this.displayedDataModel.setSortBy(6, bl);
            }
        }
    }
}

