/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.gui.common.table.FWSortableTableModel;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticProviderConstants;
import phex.statistic.StatisticsManager;
import phex.utils.Localizer;

public class StatisticsTableModel
extends FWSortableTableModel
implements StatisticProviderConstants {
    private static final int NAME_COLUMN_ID = 1001;
    private static final int VALUE_COLUMN_ID = 1002;
    private static final int AVG_COLUMN_ID = 1003;
    private static final int MAX_COLUMN_ID = 1004;
    private static final int NAME_MODEL_INDEX = 0;
    private static final int VALUE_MODEL_INDEX = 1;
    private static final int AVG_MODEL_INDEX = 2;
    private static final int MAX_MODEL_INDEX = 3;
    private static String[] tableColumns = new String[]{Localizer.getString("Name"), Localizer.getString("Value"), Localizer.getString("Avg."), Localizer.getString("Max.")};
    private static Class[] tableClasses = new Class[]{String.class, String.class, String.class, String.class};
    private static String[] rowKeys = new String[]{"TotalBandwidthProvider", "NetworkBandwidthProvider", "DownloadBandwidthProvider", "UploadBandwidthProvider", "HorizonHostCountProvider", "HorizonFileCountProvider", "HorizonFileSizeProvider", "TotalMsgInProvider", "PingMsgInProvider", "PongMsgInProvider", "QueryMsgInProvider", "QueryHitMsgInProvider", "PushMsgInProvider", "TotalMsgOutProvider", "PingMsgOutProvider", "PongMsgOutProvider", "QueryMsgOutProvider", "QueryHitMsgOutProvider", "PushMsgOutProvider", "DropedMsgTotalProvider", "DropedMsgInProvider", "DropedMsgOutProvider", "PushDownloadAttemptsProvider", "PushDownloadSucessProvider", "PushDownloadFailureProvider", "PushDldPushProxyAttemptsProvider", "PushDldPushProxySuccessProvider", "PushUploadAttemptsProvider", "PushUploadSucessProvider", "PushUploadFailureProvider", "UptimeProvider", "DailyUptimeProvider"};
    private StatisticsManager statisticsMgr = StatisticsManager.getInstance();

    public StatisticsTableModel() {
        super(tableColumns, tableClasses);
    }

    public int getRowCount() {
        return rowKeys.length;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return Localizer.getString(rowKeys[n]);
        }
        if (n2 == 1) {
            StatisticProvider statisticProvider = this.statisticsMgr.getStatisticProvider(rowKeys[n]);
            if (statisticProvider == null) {
                return "";
            }
            Object object = statisticProvider.getValue();
            if (object != null) {
                return statisticProvider.toStatisticString(object);
            }
        } else if (n2 == 2) {
            StatisticProvider statisticProvider = this.statisticsMgr.getStatisticProvider(rowKeys[n]);
            if (statisticProvider == null) {
                return "";
            }
            Object object = statisticProvider.getAverageValue();
            if (object != null) {
                return statisticProvider.toStatisticString(object);
            }
        } else if (n2 == 3) {
            StatisticProvider statisticProvider = this.statisticsMgr.getStatisticProvider(rowKeys[n]);
            if (statisticProvider == null) {
                return "";
            }
            Object object = statisticProvider.getMaxValue();
            if (object != null) {
                return statisticProvider.toStatisticString(object);
            }
        }
        return "";
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004};
        return nArray;
    }
}

