/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import phex.event.UploadFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.HostAddressComparator;
import phex.gui.comparator.TransferRateComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.renderer.ProgressCellRenderer;
import phex.gui.renderer.TransferRateCellRenderer;
import phex.gui.renderer.TransferSizeCellRenderer;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.upload.UploadStatusInfo;
import phex.utils.Localizer;

public class UploadFilesTableModel
extends FWSortableTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int FILE_COLUMN_ID = 1003;
    public static final int PROGRESS_COLUMN_ID = 1004;
    public static final int SIZE_COLUMN_ID = 1005;
    public static final int RATE_COLUMN_ID = 1006;
    public static final int STATUS_COLUMN_ID = 1007;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int FILE_MODEL_INDEX = 2;
    public static final int PROGRESS_MODEL_INDEX = 3;
    public static final int SIZE_MODEL_INDEX = 4;
    public static final int RATE_MODEL_INDEX = 5;
    public static final int STATUS_MODEL_INDEX = 6;
    private static String[] tableColumns = new String[]{Localizer.getString("Host"), Localizer.getString("Vendor"), Localizer.getString("File"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, String.class, ProgressCellRenderer.class, TransferSizeCellRenderer.class, TransferRateCellRenderer.class, String.class};
    private UploadManager uploadMgr = UploadManager.getInstance();

    public UploadFilesTableModel() {
        super(tableColumns, tableClasses);
        this.uploadMgr.addUploadFilesChangeListener(new UploadFilesListener());
    }

    public int getRowCount() {
        return this.uploadMgr.getUploadListSize();
    }

    public Object getValueAt(int n, int n2) {
        UploadState uploadState = this.uploadMgr.getUploadStateAt(n);
        if (uploadState == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return uploadState.getHostAddress();
            }
            case 1: {
                String string = uploadState.getVendor();
                if (string == null) {
                    return "";
                }
                return string;
            }
            case 2: {
                return uploadState.getFileName();
            }
            case 3: {
                return uploadState.getProgress();
            }
            case 4: 
            case 5: {
                return uploadState;
            }
            case 6: {
                return UploadStatusInfo.getUploadStatusString(uploadState.getStatus());
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 0: {
                return new HostAddressComparator();
            }
            case 4: {
                return new TransferSizeComparator();
            }
            case 5: {
                return new TransferRateComparator();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1006: {
                return 5;
            }
            case 1007: {
                return 6;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1003;
    }

    private class UploadFilesListener
    implements UploadFilesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void uploadFileChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(UploadFilesTableModel.this, n, n, -1, 0));
        }

        public void uploadFileAdded(int n) {
            UploadFilesTableModel.this.fireTableChanged(new TableModelEvent(UploadFilesTableModel.this, n, n, -1, 1));
        }

        public void uploadQueueChanged() {
        }

        public void uploadFileRemoved(int n) {
            UploadFilesTableModel.this.fireTableChanged(new TableModelEvent(UploadFilesTableModel.this, n, n, -1, -1));
        }
    }
}

