/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.JTreeTable;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.share.ShareManager;
import phex.share.SharedFilesService;

public class SearchResultsRowRenderer
implements TableCellRenderer {
    private static final Color DOWNLOAD_COLOR = new Color(0, 127, 0);
    private static final Color SHARE_COLOR = Color.lightGray;
    private SharedFilesService sharedFilesService;
    private SwarmingManager swarmingMgr;
    private SearchTreeTableModel searchModel;

    public SearchResultsRowRenderer(SearchTreeTableModel searchTreeTableModel) {
        this.searchModel = searchTreeTableModel;
        this.sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        this.swarmingMgr = SwarmingManager.getInstance();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3;
        JTreeTable jTreeTable = (JTreeTable)jTable;
        TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(jTable.getColumnClass(n2));
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        component.setForeground(jTable.getForeground());
        Object object2 = jTreeTable.getNodeOfRow(n);
        if (object2 == null || bl) {
            component.setForeground(jTable.getSelectionForeground());
            return component;
        }
        RemoteFile remoteFile = this.getRemoteFile(object2);
        URN uRN = remoteFile.getURN();
        boolean bl4 = this.sharedFilesService.isURNShared(uRN);
        if (bl4) {
            component.setForeground(SHARE_COLOR);
            return component;
        }
        boolean bl5 = bl3 = remoteFile.isInDownloadQueue() || this.swarmingMgr.isURNDownloaded(uRN);
        if (bl3) {
            component.setForeground(DOWNLOAD_COLOR);
            return component;
        }
        return component;
    }

    private RemoteFile getRemoteFile(Object object) {
        if (object instanceof SearchResultElement) {
            return ((SearchResultElement)object).getSingleRemoteFile();
        }
        return (RemoteFile)object;
    }
}

