/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.SWCandidateTableModel;
import phex.gui.models.SWDownloadTableModel;
import phex.gui.models.SWSegmentTableModel;
import phex.gui.tabs.FWTab;
import phex.host.HostAddress;
import phex.query.ResearchSetting;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class SWDownloadTab
extends FWTab {
    private static final String DOWNLOAD_TABLE_IDENTIFIER = "DownloadTable";
    private static final String SEGMENT_TABLE_IDENTIFIER = "SegmentTable";
    private static final String CANDIDATE_TABLE_IDENTIFIER = "CandidateTable";
    private static final SWDownloadFile[] EMPTY_DOWNLOADFILE_ARRAY = new SWDownloadFile[0];
    private static final SWDownloadCandidate[] EMPTY_DOWNLOADCANDIDATE_ARRAY = new SWDownloadCandidate[0];
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private FWTable downloadTable;
    private JScrollPane downloadTableScrollPane;
    private FWTableColumnModel downloadColumnModel;
    private SWDownloadTableModel downloadModel;
    private JTabbedPane downloadDetails;
    private JPopupMenu downloadPopup;
    private PanelBuilder candidatePanelBuilder;
    private JComponent candidateTitleBorder;
    private FWTable candidateTable;
    private JScrollPane candidateTableScrollPane;
    private FWTableColumnModel candidateColumnModel;
    private SWCandidateTableModel candidateModel;
    private JPopupMenu candidatePopup;
    private FWTable segmentTable;
    private JScrollPane segmentTableScrollPane;
    private FWTableColumnModel segmentColumnModel;
    private SWSegmentTableModel segmentModel;
    private MainFrame mainFrame;

    public SWDownloadTab(MainFrame mainFrame) {
        super(1003, Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTDownloadTab"), Localizer.getChar("DownloadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("DownloadAccelerator")), 3);
        this.swarmingMgr.addDownloadFilesChangeListener(new DownloadFilesChangeHandler());
        this.mainFrame = mainFrame;
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        MouseHandler mouseHandler = new MouseHandler();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, fill:d:grow, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = this.initDownloadTablePanel(xJBGUISettings, mouseHandler);
        JPanel jPanel2 = this.initDownloadCandidatePanel(xJBGUISettings, mouseHandler);
        JPanel jPanel3 = this.initDownloadSegmentPanel(xJBGUISettings);
        this.downloadDetails = new JTabbedPane(3);
        this.downloadDetails.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.downloadDetails.addTab(Localizer.getString("Candidates"), jPanel2);
        this.downloadDetails.addTab(Localizer.getString("Segments"), jPanel3);
        Dimension dimension = new Dimension(400, 300);
        jPanel.setPreferredSize(dimension);
        this.downloadDetails.setPreferredSize(dimension);
        dimension = new Dimension(0, 0);
        jPanel.setMinimumSize(dimension);
        this.downloadDetails.setMinimumSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.downloadDetails);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        panelBuilder.add((Component)jSplitPane, cellConstraints.xy(2, 2));
        GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        GUIUtils.adjustTableProgresssBarHeight(this.candidateTable);
        GUIUtils.adjustTableProgresssBarHeight(this.segmentTable);
    }

    private JPanel initDownloadSegmentPanel(XJBGUISettings xJBGUISettings) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("0dlu, fill:d:grow, 0dlu", "0dlu, p, 3dlu, fill:d:grow, 0dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.addSeparator(Localizer.getString("DownloadSegments"), cellConstraints.xy(2, 2));
        this.segmentModel = new SWSegmentTableModel(this.downloadTable);
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SEGMENT_TABLE_IDENTIFIER);
        this.buildSegmentTableColumnModel(xJBGUITable);
        this.segmentTable = new FWTable((TableModel)new FWSortedTableModel(this.segmentModel), this.segmentColumnModel);
        this.segmentTable.activateAllHeaderActions();
        this.segmentTable.setSelectionMode(0);
        this.segmentTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.segmentTable);
        this.segmentTableScrollPane = FWTable.createFWTableScrollPane(this.segmentTable);
        panelBuilder.add((Component)this.segmentTableScrollPane, cellConstraints.xy(2, 4));
        return jPanel;
    }

    private JPanel initDownloadCandidatePanel(XJBGUISettings xJBGUISettings, MouseHandler mouseHandler) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("0dlu, fill:d:grow, 0dlu", "0dlu, p, 3dlu, fill:d:grow, 1dlu, p, 0dlu");
        this.candidatePanelBuilder = new PanelBuilder(formLayout, jPanel);
        this.candidateTitleBorder = this.candidatePanelBuilder.addSeparator(Localizer.getString("DownloadCandidates"), cellConstraints.xy(2, 2));
        this.candidateModel = new SWCandidateTableModel(this.downloadTable);
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, CANDIDATE_TABLE_IDENTIFIER);
        this.buildCandidateTableColumnModel(xJBGUITable);
        this.candidateTable = new FWTable((TableModel)new FWSortedTableModel(this.candidateModel), this.candidateColumnModel);
        this.candidateTable.activateAllHeaderActions();
        this.candidateTable.getSelectionModel().addListSelectionListener(new CandidateSelectionHandler());
        this.candidateTable.setAutoResizeMode(0);
        this.candidateTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.candidateTable);
        this.candidateTableScrollPane = FWTable.createFWTableScrollPane(this.candidateTable);
        this.candidateTableScrollPane.addMouseListener(mouseHandler);
        this.candidatePanelBuilder.add((Component)this.candidateTableScrollPane, cellConstraints.xy(2, 4));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        this.candidatePanelBuilder.add((Component)fWToolBar, cellConstraints.xy(2, 6));
        this.candidatePopup = new JPopupMenu();
        FWAction fWAction = new RetryCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new RemoveCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        this.candidatePopup.addSeparator();
        fWToolBar.addSeparator();
        fWAction = new AddToFavoritesAction();
        this.addTabAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new BrowseHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new BanHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        return jPanel;
    }

    private JPanel initDownloadTablePanel(XJBGUISettings xJBGUISettings, MouseHandler mouseHandler) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("0dlu, fill:d:grow, 0dlu", "0dlu, p, 3dlu, fill:d:grow, 1dlu, p, 0dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.addSeparator(Localizer.getString("DownloadFiles"), cellConstraints.xy(2, 2));
        this.downloadModel = new SWDownloadTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, DOWNLOAD_TABLE_IDENTIFIER);
        this.buildDownloadTableColumnModel(xJBGUITable);
        this.downloadTable = new FWTable((TableModel)new FWSortedTableModel(this.downloadModel), this.downloadColumnModel);
        this.downloadTable.activateAllHeaderActions();
        this.downloadTable.setAutoResizeMode(0);
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        this.downloadTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.downloadTable);
        this.downloadTableScrollPane = FWTable.createFWTableScrollPane(this.downloadTable);
        this.downloadTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.downloadTableScrollPane, cellConstraints.xy(2, 4));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xy(2, 6));
        this.downloadPopup = new JPopupMenu();
        FWAction fWAction = new StartDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new StopDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new RemoveDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWToolBar.addSeparator();
        this.downloadPopup.addSeparator();
        fWAction = new ConfigureDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new SearchCandidatesAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        JMenu jMenu = new JMenu(Localizer.getString("Priority"));
        fWAction = new MoveDownloadPriorityAction(0);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(1);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(100);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(2);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(3);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        this.downloadPopup.add(jMenu);
        JMenu jMenu2 = new JMenu(Localizer.getString("Ordering"));
        fWAction = new MoveDownloadOrderingAction(1);
        jMenu2.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadOrderingAction(2);
        jMenu2.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadOrderingAction(3);
        jMenu2.add(fWAction);
        this.addTabAction(fWAction);
        this.downloadPopup.add(jMenu2);
        fWAction = new GeneratePreviewAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(fWAction);
        this.downloadPopup.add(fWAction);
        return jPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.downloadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        }
        if (this.downloadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.downloadTableScrollPane);
        }
        if (this.candidateTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.candidateTableScrollPane);
        }
        if (this.segmentTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.segmentTableScrollPane);
        }
    }

    private void updateDownloadFileInfo(int n) {
        int n2 = this.downloadTable.getSelectedRow();
        int n3 = this.downloadTable.convertRowIndexToModel(n2);
        if (n3 == n) {
            this.refreshTabActions();
            SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n3);
            if (sWDownloadFile != null) {
                ResearchSetting researchSetting = sWDownloadFile.getResearchSetting();
                if (researchSetting.isSearchRunning()) {
                    Object[] objectArray = new Object[]{new Integer(researchSetting.getSearchHitCount()), new Integer(researchSetting.getSearchProgress())};
                    StringBuffer stringBuffer = new StringBuffer(Localizer.getString("DownloadCandidates"));
                    stringBuffer.append(' ');
                    stringBuffer.append(Localizer.getFormatedString("CandidatesSearchingExt", objectArray));
                    CellConstraints cellConstraints = new CellConstraints();
                    this.candidatePanelBuilder.getPanel().remove(this.candidateTitleBorder);
                    this.candidateTitleBorder = this.candidatePanelBuilder.addSeparator(stringBuffer.toString(), cellConstraints.xy(2, 2));
                } else {
                    CellConstraints cellConstraints = new CellConstraints();
                    this.candidatePanelBuilder.getPanel().remove(this.candidateTitleBorder);
                    this.candidateTitleBorder = this.candidatePanelBuilder.addSeparator(Localizer.getString("DownloadCandidates"), cellConstraints.xy(2, 2));
                }
                this.candidateTitleBorder.revalidate();
                this.candidateTitleBorder.repaint();
            }
        }
    }

    private SWDownloadFile[] getSelectedDownloadFiles() {
        if (this.downloadTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADFILE_ARRAY;
        }
        int[] nArray = this.downloadTable.getSelectedRows();
        int[] nArray2 = this.downloadTable.convertRowIndicesToModel(nArray);
        SWDownloadFile[] sWDownloadFileArray = this.swarmingMgr.getDownloadFilesAt(nArray2);
        return sWDownloadFileArray;
    }

    private SWDownloadFile getSelectedDownloadFile() {
        int n = this.downloadTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.downloadTable.convertRowIndexToModel(n);
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n2);
        return sWDownloadFile;
    }

    private SWDownloadCandidate[] getSelectedDownloadCandidates() {
        if (this.candidateTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADCANDIDATE_ARRAY;
        }
        int[] nArray = this.candidateTable.getSelectedRows();
        int[] nArray2 = this.candidateTable.convertRowIndicesToModel(nArray);
        SWDownloadCandidate[] sWDownloadCandidateArray = new SWDownloadCandidate[nArray2.length];
        SWDownloadFile sWDownloadFile = this.candidateModel.getDownloadFile();
        for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
            sWDownloadCandidateArray[i] = sWDownloadFile.getCandidate(nArray2[i]);
        }
        return sWDownloadCandidateArray;
    }

    private SWDownloadCandidate getSelectedDownloadCandidate() {
        int n = this.candidateTable.getSelectedRow();
        int n2 = this.candidateTable.convertRowIndexToModel(n);
        if (n2 < 0) {
            return null;
        }
        SWDownloadFile sWDownloadFile = this.candidateModel.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadFile.getCandidate(n2);
        return sWDownloadCandidate;
    }

    private void buildDownloadTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SWDownloadTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.downloadColumnModel = new FWTableColumnModel(this.downloadModel, nArray, xJBGUITableColumnList);
    }

    private void buildSegmentTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004};
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.segmentColumnModel = new FWTableColumnModel(this.segmentModel, nArray, xJBGUITableColumnList);
    }

    private void buildCandidateTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SWCandidateTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.candidateColumnModel = new FWTableColumnModel(this.candidateModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.downloadColumnModel.createXJBGUITableColumnList();
        ObjectFactory objectFactory = new ObjectFactory();
        XJBGUITable xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(DOWNLOAD_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
        xJBGUITableColumnList = this.segmentColumnModel.createXJBGUITableColumnList();
        xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SEGMENT_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
        xJBGUITableColumnList = this.candidateColumnModel.createXJBGUITableColumnList();
        xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(CANDIDATE_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    private class SearchCandidatesAction
    extends FWAction {
        public SearchCandidatesAction() {
            super(Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTSearchCandidates"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            sWDownloadFile.startSearchForCandidates();
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile == null) {
                this.setEnabled(false);
            } else if (sWDownloadFile.getResearchSetting().isSearchRunning() || sWDownloadFile.isFileCompletedOrMoved()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            HostAddress[] hostAddressArray = new HostAddress[sWDownloadCandidateArray.length];
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                hostAddressArray[i] = sWDownloadCandidateArray[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(hostAddressArray);
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class BanHostAction
    extends FWAction {
        public BanHostAction() {
            super(Localizer.getString("BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("TTTBanHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.candidateModel.getDownloadFile();
            HostAddress[] hostAddressArray = new HostAddress[sWDownloadCandidateArray.length];
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                sWDownloadFile.stopDownload(sWDownloadCandidateArray[i]);
                sWDownloadFile.markCandidateBad(sWDownloadCandidateArray[i], true);
                hostAddressArray[i] = sWDownloadCandidateArray[i].getHostAddress();
            }
            GUIActionPerformer.banHosts(hostAddressArray);
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (sWDownloadCandidate == null) {
                return;
            }
            GUIActionPerformer.browseHost(sWDownloadCandidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (sWDownloadCandidate == null) {
                return;
            }
            if (!sWDownloadCandidate.isChatSupported()) {
                return;
            }
            ChatManager.getInstance().openChat(sWDownloadCandidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null && sWDownloadCandidate.isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    class RetryCandidateAction
    extends FWAction {
        RetryCandidateAction() {
            super(Localizer.getString("RetryCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("ReconnectHost"), Localizer.getString("TTTRetryCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                sWDownloadCandidateArray[i].manualConnectionRetry();
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RemoveCandidateAction
    extends FWAction {
        RemoveCandidateAction() {
            super(Localizer.getString("RemoveCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.candidateModel.getDownloadFile();
            for (int i = 0; i < sWDownloadCandidateArray.length; ++i) {
                sWDownloadFile.stopDownload(sWDownloadCandidateArray[i]);
                sWDownloadFile.markCandidateBad(sWDownloadCandidateArray[i], true);
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
                if (sWDownloadFile == null) {
                    return;
                }
                URN uRN = sWDownloadFile.getFileURN();
                if (uRN == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(uRN);
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(SWDownloadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class MoveDownloadOrderingAction
    extends FWAction {
        private static final int FORCE_BY_POSITION = 1;
        private static final int FORCE_BY_RATING = 2;
        private static final int FORCE_WITH_PREVIEW = 3;
        int selection;

        MoveDownloadOrderingAction(int n) {
            this.selection = n;
            switch (n) {
                case 1: {
                    this.setName(Localizer.getString("OrderByPosition"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("OrderByPosition"));
                    this.setToolTipText(Localizer.getString("TTTOrderByPosition"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("OrderByRating"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("OrderByRating"));
                    this.setToolTipText(Localizer.getString("TTTOrderByRating"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("OrderWithPreview"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("OrderWithPreview"));
                    this.setToolTipText(Localizer.getString("TTTOrderWithPreview"));
                }
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
            if (sWDownloadFile == null) {
                return;
            }
            sWDownloadFile.setOrdering(this.selection);
        }

        public void refreshActionState() {
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
            boolean bl = false;
            if (sWDownloadFile != null) {
                bl = sWDownloadFile.getOrdering() == this.selection;
            }
            this.setEnabled(!bl);
        }
    }

    class GeneratePreviewAction
    extends FWAction {
        GeneratePreviewAction() {
            this.setName(Localizer.getString("GeneratePreview"));
            this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("GeneratePreview"));
            this.setToolTipText(Localizer.getString("TTTGeneratePreview"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
            if (sWDownloadFile == null) {
                return;
            }
            sWDownloadFile.generatePreview();
        }

        public void refreshActionState() {
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
            if (sWDownloadFile == null) {
                this.setEnabled(false);
            }
            try {
                String string = sWDownloadFile.canPreview();
                if (string != null) {
                    if (ServiceManager.sCfg.copyBeforePreviewing) {
                        this.setName(Localizer.getString("GeneratePreview"));
                        this.setToolTipText(Localizer.getString("TTTGeneratePreview") + ": " + string);
                        this.setEnabled(true);
                    } else {
                        this.setName(Localizer.getString("ExecutePreview"));
                        this.setToolTipText(Localizer.getString("TTTExecutePreview") + ": " + string);
                        this.setEnabled(true);
                    }
                } else {
                    this.setEnabled(false);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class MoveDownloadPriorityAction
    extends FWAction {
        private static final short PRIORITY_MOVE_TO_TOP = 0;
        private static final short PRIORITY_MOVE_UP = 1;
        private static final short PRIORITY_MOVE_DOWN = 2;
        private static final short PRIORITY_MOVE_TO_BOTTOM = 3;
        private static final short PRIORITY_RESORT = 100;
        private short moveDirection;

        MoveDownloadPriorityAction(short s) {
            this.moveDirection = s;
            switch (s) {
                case 0: {
                    this.setName(Localizer.getString("MoveToTop"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveToTop"));
                    this.setToolTipText(Localizer.getString("TTTMoveToTop"));
                    break;
                }
                case 1: {
                    this.setName(Localizer.getString("MoveUp"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveUp"));
                    this.setToolTipText(Localizer.getString("TTTMoveUp"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("MoveDown"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveDown"));
                    this.setToolTipText(Localizer.getString("TTTMoveDown"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("MoveToBottom"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveToBottom"));
                    this.setToolTipText(Localizer.getString("TTTMoveToBottom"));
                    break;
                }
                case 100: {
                    this.setName(Localizer.getString("Resort"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Resort"));
                    this.setToolTipText(Localizer.getString("TTTResort"));
                }
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.moveDirection == 100) {
                int[] nArray = new int[SWDownloadTab.this.downloadTable.getRowCount()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i;
                }
                int[] nArray2 = SWDownloadTab.this.downloadTable.convertRowIndicesToModel(nArray);
                SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.swarmingMgr.getDownloadFilesAt(nArray2);
                SWDownloadTab.this.swarmingMgr.updateDownloadFilePriorities(sWDownloadFileArray);
            } else {
                SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
                for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                    if (sWDownloadFileArray[i] == null) continue;
                    SWDownloadTab.this.swarmingMgr.moveDownloadFilePriority(sWDownloadFileArray[i], this.moveDirection);
                }
            }
        }

        public void refreshActionState() {
            if (this.moveDirection == 100) {
                this.setEnabled(true);
            } else if (SWDownloadTab.this.downloadTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class RemoveDownloadAction
    extends FWAction {
        RemoveDownloadAction() {
            super(Localizer.getString("RemoveDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            ArrayList<SWDownloadFile> arrayList = new ArrayList<SWDownloadFile>(sWDownloadFileArray.length);
            ArrayList<SWDownloadFile> arrayList2 = new ArrayList<SWDownloadFile>(sWDownloadFileArray.length);
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null) continue;
                if (sWDownloadFileArray[i].isFileCompletedMoved()) {
                    arrayList2.add(sWDownloadFileArray[i]);
                    continue;
                }
                if (sWDownloadFileArray[i].isFileCompleted()) continue;
                if (sWDownloadFileArray[i].getTransferredDataSize() == 0L) {
                    arrayList2.add(sWDownloadFileArray[i]);
                    continue;
                }
                arrayList.add(sWDownloadFileArray[i]);
            }
            Integer n = new Integer(arrayList.size());
            for (int i = 0; i < n; ++i) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)arrayList.get(i);
                sWDownloadFile.forceCollectionOfTransferData();
                Object[] objectArray = new Object[]{sWDownloadFile.getDestinationFile().getName(), StrUtil.formatSizeBytes(sWDownloadFile.getTransferredDataSize()), StrUtil.formatSizeBytes(sWDownloadFile.getTransferDataSize())};
                Object[] objectArray2 = new Object[]{new Integer(i + 1), n};
                Object[] objectArray3 = n - i > 1 ? new Object[]{Localizer.getString("Yes"), Localizer.getString("No"), Localizer.getString("YesToAll"), Localizer.getString("NoToAll")} : new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                int n2 = JOptionPane.showOptionDialog(SWDownloadTab.this.mainFrame, Localizer.getFormatedString("RemoveDownloadWarning", objectArray), Localizer.getFormatedString("RemoveDownloadTitle", objectArray2), 0, 2, null, objectArray3, Localizer.getString("Yes"));
                if (n2 == 0) {
                    arrayList2.add(sWDownloadFile);
                    continue;
                }
                if (n2 == 2) {
                    arrayList2.addAll(arrayList.subList(i, arrayList.size()));
                    break;
                }
                if (n2 == 3) break;
            }
            if (arrayList2.size() > 0) {
                SWDownloadFile[] sWDownloadFileArray2 = new SWDownloadFile[arrayList2.size()];
                arrayList2.toArray(sWDownloadFileArray2);
                SWDownloadTab.this.swarmingMgr.removeDownloadFiles(sWDownloadFileArray2);
                SWDownloadTab.this.downloadTable.getSelectionModel().clearSelection();
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class ConfigureDownloadAction
    extends FWAction {
        ConfigureDownloadAction() {
            super(Localizer.getString("ConfigureDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTConfigureDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile != null) {
                if (sWDownloadFile.isDownloadInProgress()) {
                    JOptionPane.showMessageDialog(SWDownloadTab.this, Localizer.getString("NoConfigDownloadInProgress"), Localizer.getString("DownloadInProgress"), 2);
                    return;
                }
                short s = sWDownloadFile.getStatus();
                sWDownloadFile.stopDownload();
                DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(sWDownloadFile);
                downloadConfigDialog.show();
                sWDownloadFile.setStatus(s);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class StopDownloadAction
    extends FWAction {
        StopDownloadAction() {
            super(Localizer.getString("StopDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"), Localizer.getString("TTTStopDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || sWDownloadFileArray[i].isFileCompletedOrMoved() || sWDownloadFileArray[i].isDownloadStopped()) continue;
                sWDownloadFileArray[i].stopDownload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean bl = false;
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || sWDownloadFileArray[i].isFileCompletedOrMoved() || sWDownloadFileArray[i].isDownloadStopped()) continue;
                bl = true;
                break;
            }
            this.setEnabled(bl);
        }
    }

    class StartDownloadAction
    extends FWAction {
        StartDownloadAction() {
            super(Localizer.getString("StartDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Start"), Localizer.getString("TTTStartDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || !sWDownloadFileArray[i].isDownloadStopped()) continue;
                sWDownloadFileArray[i].startDownload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean bl = false;
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                if (sWDownloadFileArray[i] == null || !sWDownloadFileArray[i].isDownloadStopped()) continue;
                bl = true;
                break;
            }
            this.setEnabled(bl);
        }
    }

    private class DownloadFilesChangeHandler
    implements DownloadFilesChangeListener {
        private DownloadFilesChangeHandler() {
        }

        public void downloadFileChanged(int n) {
            SWDownloadTab.this.updateDownloadFileInfo(n);
        }

        public void downloadFileAdded(int n) {
        }

        public void downloadFileRemoved(int n) {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SWDownloadTab.this.downloadTable || component == SWDownloadTab.this.downloadTableScrollPane) {
                SWDownloadTab.this.refreshTabActions();
                SWDownloadTab.this.downloadPopup.show(component, n, n2);
            } else if (component == SWDownloadTab.this.candidateTable || component == SWDownloadTab.this.candidateTableScrollPane) {
                SWDownloadTab.this.candidatePopup.show(component, n, n2);
            }
        }
    }

    class CandidateSelectionHandler
    implements ListSelectionListener {
        CandidateSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                SWDownloadTab.this.refreshTabActions();
            }
        }
    }

    class DownloadSelectionHandler
    implements ListSelectionListener {
        DownloadSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getLeadSelectionIndex();
                SWDownloadTab.this.updateDownloadFileInfo(n);
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }
}

