/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.gui.actions.FWAction;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.SecurityRuleConfigDialog;
import phex.gui.models.SecurityTableModel;
import phex.gui.renderer.SecurityRuleRowRenderer;
import phex.gui.tabs.FWTab;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.utils.Localizer;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class SecurityTab
extends FWTab {
    private static final String SECURITY_TABLE_IDENTIFIER = "SecurityTable";
    private static final SecurityRule[] EMPTY_SECURITYRULE_ARRAY = new SecurityRule[0];
    private JPopupMenu securityPopup;
    private SecurityTableModel securityModel;
    private FWTableColumnModel securityColumnModel;
    private FWTable securityTable;
    private JScrollPane securityTableScrollPane;
    private PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
    private static final String EDIT_SECURITY_RULE_ACTION_KEY = "EditSecurityRuleAction";

    public SecurityTab() {
        super(1005, Localizer.getString("Security"), GUIRegistry.getInstance().getIconFactory().getIcon("Security"), Localizer.getString("TTTSecurity"), Localizer.getChar("SecurityMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SecurityAccelerator")), 6);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        Serializable serializable;
        MouseHandler mouseHandler = new MouseHandler();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, p, 3dlu, fill:d:grow, 1dlu, p, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.addSeparator(Localizer.getString("Security"), cellConstraints.xy(2, 2));
        this.securityModel = new SecurityTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SECURITY_TABLE_IDENTIFIER);
        this.buildSecurityTableColumnModel(xJBGUITable);
        this.securityTable = new FWTable((TableModel)new FWSortedTableModel(this.securityModel), this.securityColumnModel);
        SecurityRuleRowRenderer securityRuleRowRenderer = new SecurityRuleRowRenderer();
        Enumeration<TableColumn> enumeration = this.securityColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setCellRenderer(securityRuleRowRenderer);
        }
        this.securityTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.securityTable.activateAllHeaderActions();
        this.securityTable.setAutoResizeMode(0);
        this.securityTable.addMouseListener(mouseHandler);
        this.securityTableScrollPane = FWTable.createFWTableScrollPane(this.securityTable);
        this.securityTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.securityTableScrollPane, cellConstraints.xy(2, 4));
        serializable = new FWToolBar(0);
        ((JToolBar)serializable).setBorderPainted(false);
        ((JToolBar)serializable).setFloatable(false);
        panelBuilder.add((Component)serializable, cellConstraints.xy(2, 6));
        this.securityPopup = new JPopupMenu();
        FWAction fWAction = new NewSecurityRuleAction();
        this.addTabAction(fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.securityPopup.add(fWAction);
        fWAction = new EditSecurityRuleAction();
        this.addTabAction(EDIT_SECURITY_RULE_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.securityPopup.add(fWAction);
        fWAction = new RemoveSecurityRuleAction();
        this.addTabAction(fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.securityPopup.add(fWAction);
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.securityTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.securityTableScrollPane);
        }
    }

    private SecurityRule[] getSelectedSecurityRules() {
        if (this.securityTable.getSelectedRowCount() == 0) {
            return EMPTY_SECURITYRULE_ARRAY;
        }
        int[] nArray = this.securityTable.getSelectedRows();
        int[] nArray2 = this.securityTable.convertRowIndicesToModel(nArray);
        SecurityRule[] securityRuleArray = this.securityMgr.getIPAccessRulesAt(nArray2);
        return securityRuleArray;
    }

    private void buildSecurityTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SecurityTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.securityColumnModel = new FWTableColumnModel(this.securityModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.securityColumnModel.createXJBGUITableColumnList();
        ObjectFactory objectFactory = new ObjectFactory();
        XJBGUITable xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SECURITY_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    public class RemoveSecurityRuleAction
    extends FWAction {
        public RemoveSecurityRuleAction() {
            super(Localizer.getString("RemoveSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SecurityTab.this.securityTable.getSelectedRow() < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRuleArray = SecurityTab.this.getSelectedSecurityRules();
            for (int i = 0; i < securityRuleArray.length; ++i) {
                if (securityRuleArray[i] == null || securityRuleArray[i].isSystemRule()) continue;
                PhexSecurityManager.getInstance().removeSecurityRule(securityRuleArray[i]);
            }
        }

        public void refreshActionState() {
            int n = SecurityTab.this.securityTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRuleArray = SecurityTab.this.getSelectedSecurityRules();
            for (int i = 0; i < securityRuleArray.length; ++i) {
                if (securityRuleArray[i].isSystemRule()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    public class EditSecurityRuleAction
    extends FWAction {
        public EditSecurityRuleAction() {
            super(Localizer.getString("EditSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Edit"), Localizer.getString("TTTEditSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SecurityTab.this.securityTable.getSelectedRowCount() != 1) {
                return;
            }
            int n = SecurityTab.this.securityTable.getSelectedRow();
            int n2 = SecurityTab.this.securityTable.convertRowIndexToModel(n);
            IPAccessRule iPAccessRule = SecurityTab.this.securityMgr.getIPAccessRule(n2);
            if (iPAccessRule == null || iPAccessRule.isSystemRule()) {
                return;
            }
            SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog(iPAccessRule);
            securityRuleConfigDialog.show();
        }

        public void refreshActionState() {
            if (SecurityTab.this.securityTable.getSelectedRowCount() == 1) {
                int n = SecurityTab.this.securityTable.getSelectedRow();
                int n2 = SecurityTab.this.securityTable.convertRowIndexToModel(n);
                IPAccessRule iPAccessRule = SecurityTab.this.securityMgr.getIPAccessRule(n2);
                if (iPAccessRule.isSystemRule()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class NewSecurityRuleAction
    extends FWAction {
        public NewSecurityRuleAction() {
            super(Localizer.getString("NewSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("New"), Localizer.getString("TTTNewSecurityRule"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog();
            securityRuleConfigDialog.show();
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SecurityTab.this.securityTable) {
                SecurityTab.this.getTabAction(SecurityTab.EDIT_SECURITY_RULE_ACTION_KEY).actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && (component = (Component)mouseEvent.getSource()) == SecurityTab.this.securityTable) {
                Point point = mouseEvent.getPoint();
                int n = SecurityTab.this.securityTable.rowAtPoint(point);
                int n2 = SecurityTab.this.securityTable.columnAtPoint(point);
                SecurityTab.this.securityTable.changeSelection(n, n2, false, false);
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SecurityTab.this.securityTable || component == SecurityTab.this.securityTableScrollPane) {
                SecurityTab.this.securityPopup.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SecurityTab.this.refreshTabActions();
        }
    }
}

