/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.StatisticsTableModel;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class StatisticsTab
extends FWTab {
    private static final String STATISTICS_TABLE_IDENTIFIER = "StatisticsTable";
    private StatisticsTableModel statisticsModel;
    private FWTableColumnModel statisticsColumnModel;
    private FWTable statisticsTable;
    private JScrollPane statisticsTableScrollPane;

    public StatisticsTab() {
        super(1006, Localizer.getString("Statistics"), GUIRegistry.getInstance().getIconFactory().getIcon("Statistics"), Localizer.getString("TTTStatistics"), Localizer.getChar("StatisticsMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("StatisticsAccelerator")), 7);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, p, 3dlu, fill:d:grow, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.addSeparator(Localizer.getString("Statistics"), cellConstraints.xy(2, 2));
        this.statisticsModel = new StatisticsTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, STATISTICS_TABLE_IDENTIFIER);
        this.buildStatisticsTableColumnModel(xJBGUITable);
        this.statisticsTable = new FWTable((TableModel)new FWSortedTableModel(this.statisticsModel), this.statisticsColumnModel);
        this.statisticsTable.activateAllHeaderActions();
        this.statisticsTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.statisticsTable);
        this.statisticsTableScrollPane = FWTable.createFWTableScrollPane(this.statisticsTable);
        panelBuilder.add((Component)this.statisticsTableScrollPane, cellConstraints.xy(2, 4));
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.statisticsTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.statisticsTableScrollPane);
        }
    }

    private void buildStatisticsTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = StatisticsTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.statisticsColumnModel = new FWTableColumnModel(this.statisticsModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.statisticsColumnModel.createXJBGUITableColumnList();
        ObjectFactory objectFactory = new ObjectFactory();
        XJBGUITable xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(STATISTICS_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }
}

