/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.chat.ChatManager;
import phex.event.UploadFilesChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.models.UploadFilesTableModel;
import phex.gui.tabs.FWTab;
import phex.host.HostAddress;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class UploadTab
extends FWTab {
    private static final String UPLOAD_TABLE_IDENTIFIER = "UploadTable";
    private static final UploadState[] EMPTY_UPLOADSTATE_ARRAY = new UploadState[0];
    private UploadManager uploadManager;
    private MainFrame mainFrame;
    private FWTable uploadTable;
    private JScrollPane uploadTableScrollPane;
    private UploadFilesTableModel uploadModel;
    private FWTableColumnModel uploadColumnModel;
    private JPopupMenu uploadPopup;

    public UploadTab(MainFrame mainFrame) {
        super(1004, Localizer.getString("Upload"), GUIRegistry.getInstance().getIconFactory().getIcon("Upload"), Localizer.getString("TTTUpload"), Localizer.getChar("UploadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("UploadAccelerator")), 4);
        this.mainFrame = mainFrame;
        this.uploadManager = UploadManager.getInstance();
        this.uploadManager.addUploadFilesChangeListener(new UploadStateChangeHandler());
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, p, 3dlu, fill:d:grow, 1dlu, p, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.addSeparator(Localizer.getString("Uploads"), cellConstraints.xy(2, 2));
        this.uploadModel = new UploadFilesTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, UPLOAD_TABLE_IDENTIFIER);
        this.buildUploadTableColumnModel(xJBGUITable);
        MouseHandler mouseHandler = new MouseHandler();
        this.uploadTable = new FWTable((TableModel)new FWSortedTableModel(this.uploadModel), this.uploadColumnModel);
        this.uploadTable.activateAllHeaderActions();
        this.uploadTable.setAutoResizeMode(0);
        this.uploadTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.uploadTable.addMouseListener(mouseHandler);
        this.uploadTableScrollPane = FWTable.createFWTableScrollPane(this.uploadTable);
        this.uploadTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.uploadTableScrollPane, cellConstraints.xy(2, 4));
        GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xy(2, 6));
        this.uploadPopup = new JPopupMenu();
        FWAction fWAction = new AbortUploadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new RemoveUploadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWToolBar.addSeparator();
        this.uploadPopup.addSeparator();
        fWAction = new AddToFavoritesAction();
        this.addTabAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new BrowseHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new BanHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWToolBar.addSeparator();
        this.uploadPopup.addSeparator();
        fWAction = new ClearUploadsAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.uploadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        }
        if (this.uploadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.uploadTableScrollPane);
        }
    }

    private UploadState[] getSelectedUploadStates() {
        int[] nArray = this.uploadTable.getSelectedRows();
        if (nArray.length == 0) {
            return EMPTY_UPLOADSTATE_ARRAY;
        }
        int[] nArray2 = this.uploadTable.convertRowIndicesToModel(nArray);
        UploadState[] uploadStateArray = this.uploadManager.getUploadStatesAt(nArray2);
        return uploadStateArray;
    }

    private UploadState getSelectedUploadState() {
        int n = this.uploadTable.getSelectedRow();
        int n2 = this.uploadTable.convertRowIndexToModel(n);
        UploadState uploadState = this.uploadManager.getUploadStateAt(n2);
        return uploadState;
    }

    private void buildUploadTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006, 1007};
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.uploadColumnModel = new FWTableColumnModel(this.uploadModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.uploadColumnModel.createXJBGUITableColumnList();
        ObjectFactory objectFactory = new ObjectFactory();
        XJBGUITable xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(UPLOAD_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == UploadTab.this.uploadTable || component == UploadTab.this.uploadTableScrollPane) {
                UploadTab.this.uploadPopup.show(component, n, n2);
            }
        }
    }

    private class UploadStateChangeHandler
    implements UploadFilesChangeListener {
        private UploadStateChangeHandler() {
        }

        public void uploadFileChanged(int n) {
            UploadTab.this.refreshTabActions();
        }

        public void uploadFileAdded(int n) {
            UploadTab.this.refreshTabActions();
        }

        public void uploadQueueChanged() {
        }

        public void uploadFileRemoved(int n) {
            UploadTab.this.refreshTabActions();
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                UploadTab.this.refreshTabActions();
            }
        }
    }

    class ClearUploadsAction
    extends FWAction {
        ClearUploadsAction() {
            super(Localizer.getString("ClearCompleted"), GUIRegistry.getInstance().getIconFactory().getIcon("Trash"), Localizer.getString("TTTClearCompleted"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadTab.this.uploadManager.cleanUploadStateList();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState uploadState = UploadTab.this.getSelectedUploadState();
            if (uploadState == null) {
                return;
            }
            GUIActionPerformer.browseHost(uploadState.getHostAddress());
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                UploadState uploadState = UploadTab.this.getSelectedUploadState();
                if (uploadState == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(uploadState.getFileURN());
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(UploadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState[] uploadStateArray = UploadTab.this.getSelectedUploadStates();
            HostAddress[] hostAddressArray = new HostAddress[uploadStateArray.length];
            for (int i = 0; i < uploadStateArray.length; ++i) {
                hostAddressArray[i] = uploadStateArray[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(hostAddressArray);
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class BanHostAction
    extends FWAction {
        BanHostAction() {
            super(Localizer.getString("BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("TTTBanHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState[] uploadStateArray = UploadTab.this.getSelectedUploadStates();
            HostAddress[] hostAddressArray = new HostAddress[uploadStateArray.length];
            for (int i = 0; i < uploadStateArray.length; ++i) {
                UploadTab.this.uploadManager.removeUploadState(uploadStateArray[i]);
                hostAddressArray[i] = uploadStateArray[i].getHostAddress();
            }
            GUIActionPerformer.banHosts(hostAddressArray);
            this.refreshActionState();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState uploadState = UploadTab.this.getSelectedUploadState();
            if (uploadState == null) {
                return;
            }
            ChatManager.getInstance().openChat(uploadState.getHostAddress());
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class RemoveUploadAction
    extends FWAction {
        RemoveUploadAction() {
            super(Localizer.getString("RemoveUpload"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState[] uploadStateArray = UploadTab.this.getSelectedUploadStates();
            for (int i = 0; i < uploadStateArray.length; ++i) {
                if (uploadStateArray[i] == null) continue;
                UploadTab.this.uploadManager.removeUploadState(uploadStateArray[i]);
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AbortUploadAction
    extends FWAction {
        AbortUploadAction() {
            super(Localizer.getString("AbortUpload"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"), Localizer.getString("TTTAbortUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState[] uploadStateArray = UploadTab.this.getSelectedUploadStates();
            for (int i = 0; i < uploadStateArray.length; ++i) {
                if (uploadStateArray[i] == null || !uploadStateArray[i].isUploadRunning()) continue;
                uploadStateArray[i].stopUpload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            UploadState[] uploadStateArray = UploadTab.this.getSelectedUploadStates();
            boolean bl = false;
            for (int i = 0; i < uploadStateArray.length; ++i) {
                if (uploadStateArray[i] == null || !uploadStateArray[i].isUploadRunning()) continue;
                bl = true;
                break;
            }
            this.setEnabled(bl);
        }
    }
}

